/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CFF
extends Table {
    Type1C cffData;
    PdfJavaGlyphs glyphs = new T1Glyphs(false);
    boolean hasCFFdata = false;

    public CFF(FontFile2 currentFontFile) {
        LogWriter.writeMethod("{readCFFTable}", 0);
        int startPointer = currentFontFile.selectTable(16);
        if (startPointer != 0) {
            int length = currentFontFile.getTableSize(16);
            byte[] data = currentFontFile.readBytes(startPointer, length);
            try {
                this.cffData = new Type1C(data, null, this.glyphs);
                this.hasCFFdata = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasCFFData() {
        return this.hasCFFdata;
    }

    public PdfGlyph getCFFGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        return this.glyphs.getEmbeddedGlyph(factory, glyph, Trm, rawInt, displayValue, currentWidth, key);
    }
}

