/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class T1Glyph
implements PdfGlyph,
Serializable {
    private transient Vector_Path cached_current_path = null;
    private float glyfwidth = 1000.0f;
    Area glyphShape = null;

    public T1Glyph() {
    }

    public T1Glyph(Vector_Path cached_current_path) {
        this.cached_current_path = cached_current_path;
    }

    public void render(int text_fill_type, Graphics2D g2, boolean debug, float scaling) {
        if (this.cached_current_path != null) {
            GeneralPath[] paths = this.cached_current_path.get();
            int cacheCount = paths.length;
            int i = 0;
            while (i < cacheCount) {
                if (paths[i] == null) break;
                if (text_fill_type == 2) {
                    g2.fill(paths[i]);
                }
                if (debug | text_fill_type == 1) {
                    g2.draw(paths[i]);
                }
                ++i;
            }
        }
    }

    public float getmaxWidth() {
        return this.glyfwidth;
    }

    public int getmaxHeight() {
        return 0;
    }

    public void lockColors(PdfPaint strokeColor, PdfPaint nonstrokeColor) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public Area getShape() {
        if (this.cached_current_path != null) {
            GeneralPath[] paths = this.cached_current_path.get();
            int cacheCount = paths.length;
            int i = 1;
            while (i < cacheCount) {
                if (paths[i] == null) break;
                paths[0].append(paths[i], false);
                ++i;
            }
            if (paths != null && paths[0] != null) {
                this.glyphShape = new Area(paths[0]);
            }
        }
        return this.glyphShape;
    }

    public String getGlyphName() {
        return "";
    }

    public void setPaths(Vector_Path vp) {
        this.cached_current_path = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.cached_current_path != null) {
            GeneralPath[] paths = this.cached_current_path.get();
            int count = 0;
            int i = 0;
            while (i < paths.length) {
                if (paths[i] == null) {
                    count = i;
                    break;
                }
                ++i;
            }
            os.writeObject(new Integer(count));
            i = 0;
            while (i < count) {
                PathIterator pathIterator = paths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
                ++i;
            }
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    public void setWidth(float width) {
        this.glyfwidth = width;
    }
}

