/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.utils.LogWriter;

public class StandardFonts {
    private static Map unicode_name_mapping_table = new Hashtable();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE1 = 1;
    public static final int TRUETYPE = 2;
    public static final int TYPE3 = 3;
    public static final int CIDTYPE0 = 4;
    public static final int CIDTYPE2 = 5;
    public static final int OPENTYPE = 6;
    public static final int TRUETYPE_COLLECTION = 7;
    public static final int FONT_UNSUPPORTED = 8;
    private static final String enc = "Cp1252";
    private static Map uniqueValues = null;
    private static Map[] glyphToChar = new Hashtable[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static ClassLoader loader;
    private static Hashtable standardFileList;
    private static Hashtable standardFontLoaded;
    private static Map widthTableStandard;
    private static String[] CIDFonts;
    protected static Map javaFontList;
    protected static final String[] javaFonts;
    protected static final String[] files_names;
    protected static final String[] files_names_bis;
    private static Hashtable adobeMap;

    static {
        loader = StandardFonts.class.getClassLoader();
        standardFileList = new Hashtable();
        standardFontLoaded = new Hashtable();
        widthTableStandard = new Hashtable();
        CIDFonts = new String[]{"83pv-RKSJ-H", "90msp-RKSJ-H", "90msp-RKSJ-V", "90ms-RKSJ-H", "90ms-RKSJ-UCS2", "90ms-RKSJ-V", "90pv-RKSJ-H", "90pv-RKSJ-UCS2", "90pv-RKSJ-UCS2C", "Add-RKSJ-H", "Add-RKSJ-V", "Adobe-CNS1-3", "Adobe-CNS1-UCS2", "Adobe-GB1-4", "Adobe-GB1-UCS2", "Adobe-Japan1-4", "Adobe-Japan1-UCS2", "Adobe-Korea1-2", "Adobe-Korea1-UCS2", "B5pc-H", "B5pc-UCS2", "B5pc-UCS2C", "B5pc-V", "CNS-EUC-H", "CNS-EUC-V", "ETen-B5-H", "ETen-B5-UCS2", "ETen-B5-V", "euc-h", "euc-v", "Ext-RKSJ-H", "Ext-RKSJ-V", "gb-euc-h", "gb-euc-v", "gbk2k-h", "gbk2k-v", "GBK-EUC-H", "GBK-EUC-UCS2", "GBK-EUC-V", "GBKp-EUC-H", "GBKp-EUC-V", "GBpc-EUC-H", "GBpc-EUC-UCS2", "GBpc-EUC-UCS2C", "GBpc-EUC-V", "GBT-EUC-H", "GBT-EUC-V", "h", "HKscs-B5-H", "HKscs-B5-V", "KSC-EUC-H", "KSC-EUC-V", "KSCms-UHC-H", "KSCms-UHC-HW-H", "KSCms-UHC-HW-V", "KSCms-UHC-UCS2", "KSCms-UHC-V", "KSCpc-EUC-H", "KSCpc-EUC-UCS2", "KSCpc-EUC-UCS2C", "UniCNS-UCS2-H", "UniCNS-UCS2-V", "UniGB-UCS2-H", "UniGB-UCS2-V", "UniJIS-UCS2-H", "UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-V", "UniJIS-UCS2-V", "UniKS-UCS2-H", "UniKS-UCS2-V", "v"};
        javaFontList = new Hashtable();
        javaFonts = new String[]{"Courier", "Courier-Bold", "Courier", "Courier-Bold", "Arial", "Arial-Bold", "Arial", "Arial-Italic", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Wingdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
        adobeMap = null;
        int i = 0;
        while (i < files_names.length) {
            standardFileList.put(files_names_bis[i], new Integer(i));
            standardFileList.put(files_names[i], new Integer(i));
            ++i;
        }
        StandardFonts.loadAdobeMap();
    }

    public static int getFontType(String name) {
        int type = 8;
        if (name.endsWith(".ttf")) {
            type = 2;
        } else if (name.endsWith(".otf")) {
            type = 6;
        } else if (name.endsWith(".ttc")) {
            type = 7;
        } else if (name.endsWith(".afm")) {
            type = 1;
        }
        return type;
    }

    public static String getUnicodeName(String key) {
        return (String)unicode_name_mapping_table.get(key);
    }

    public static String getUnicodeChar(int i, int key) {
        return unicode_char_decoding_table[i][key];
    }

    public static Map getUniqueMappings() {
        if (uniqueValues == null) {
            uniqueValues = new HashMap();
            int ii = 0;
            while (ii < 256) {
                if (WIN_char_encoding_table[ii] == null && MAC_char_encoding_table[ii] != null) {
                    uniqueValues.put(new Integer(ii), new Integer(1));
                }
                if (WIN_char_encoding_table[ii] != null && MAC_char_encoding_table[ii] == null) {
                    uniqueValues.put(new Integer(ii), new Integer(-1));
                }
                ++ii;
            }
        }
        return uniqueValues;
    }

    public static Float getStandardWidth(String font, String key) {
        String altfont;
        int p;
        Object value = widthTableStandard.get(String.valueOf(font) + key);
        if (value == null && (p = (altfont = font).indexOf(44)) != -1) {
            altfont = altfont.substring(0, p);
            value = widthTableStandard.get(String.valueOf(altfont) + key);
        }
        return (Float)value;
    }

    private static final void readStandardMappingTable(int key, String file_name) {
        String line = null;
        String hexVal = null;
        int value = 0;
        BufferedReader input_stream = null;
        StandardFonts.glyphToChar[key] = new Hashtable();
        try {
            BufferedReader bufferedReader = input_stream = file_name.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + file_name), enc)) : new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + file_name), "UTF-16"));
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open " + file_name + " to read standard encoding");
            }
            while ((line = input_stream.readLine()) != null) {
                String VAL;
                String NAME;
                String char_value;
                StringTokenizer values = new StringTokenizer(line);
                if (line.indexOf("space") != -1 || values.countTokens() <= 1) continue;
                if (values.countTokens() == 3) {
                    char_value = values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                } else if (values.countTokens() == 4) {
                    hexVal = values.nextToken();
                    char_value = values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                    char_value = Character.toString((char)Integer.parseInt(hexVal, 16));
                } else if (values.countTokens() == 2) {
                    char_value = " ";
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                } else {
                    char_value = values.nextToken();
                    NAME = values.nextToken();
                    VAL = values.nextToken();
                }
                unicode_name_mapping_table.put(String.valueOf(key) + NAME, char_value);
                glyphToChar[key].put(NAME, new Integer(Integer.parseInt(VAL)));
                unicode_name_mapping_table.put(NAME, char_value);
                if (!Character.isDigit(VAL.charAt(0))) continue;
                value = Integer.parseInt(VAL, 8);
                if (key == 5) {
                    StandardFonts.ZAPF_char_encoding_table[value] = char_value;
                } else if (key == 4) {
                    StandardFonts.SYMBOL_char_encoding_table[value] = char_value;
                } else if (key == 3) {
                    StandardFonts.MACEXPERT_char_encoding_table[value] = char_value;
                }
                StandardFonts.unicode_char_decoding_table[key][value] = NAME;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading lookup table for pdf");
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    private static final void readStandardMappingTable(int idx) {
        String char_value = null;
        int mac_value = 0;
        int win_value = 0;
        int std_value = 0;
        String line = null;
        BufferedReader input_stream = null;
        if (idx == 0) {
            StandardFonts.checkLoaded(2);
        }
        try {
            StandardFonts.glyphToChar[idx] = new Hashtable();
            input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), enc));
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
            }
            while ((line = input_stream.readLine()) != null) {
                StringTokenizer values = new StringTokenizer(line);
                int count = values.countTokens();
                String NAME = values.nextToken();
                String STD_value = values.nextToken();
                String MAC_value = values.nextToken();
                String WIN_value = values.nextToken();
                String PDF_value = values.nextToken();
                String raw = values.nextToken();
                char_value = count == 7 ? Character.toString((char)Integer.parseInt(raw, 16)) : raw;
                unicode_name_mapping_table.put(NAME, char_value);
                if (idx == 0 && Character.isDigit(MAC_value.charAt(0))) {
                    mac_value = Integer.parseInt(MAC_value, 8);
                    StandardFonts.MAC_char_encoding_table[mac_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[0][mac_value] = NAME;
                    glyphToChar[0].put(NAME, new Integer(mac_value));
                    if (!Character.isDigit(WIN_value.charAt(0))) continue;
                    win_value = Integer.parseInt(WIN_value, 8);
                    continue;
                }
                if (idx == 1 && Character.isDigit(STD_value.charAt(0))) {
                    std_value = Integer.parseInt(STD_value, 8);
                    StandardFonts.STD_char_encoding_table[std_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[1][std_value] = NAME;
                    glyphToChar[1].put(NAME, new Integer(std_value));
                    continue;
                }
                if (idx == 6 && Character.isDigit(PDF_value.charAt(0))) {
                    std_value = Integer.parseInt(PDF_value, 8);
                    StandardFonts.PDF_char_encoding_table[std_value] = char_value;
                    StandardFonts.unicode_char_decoding_table[6][std_value] = NAME;
                    continue;
                }
                if (idx != 2 || !Character.isDigit(WIN_value.charAt(0))) continue;
                win_value = Integer.parseInt(WIN_value, 8);
                StandardFonts.WIN_char_encoding_table[win_value] = char_value;
                StandardFonts.unicode_char_decoding_table[2][win_value] = NAME;
                glyphToChar[2].put(NAME, new Integer(win_value));
            }
            if (idx == 0) {
                StandardFonts.MAC_char_encoding_table[202] = " ";
            }
            if (idx == 2) {
                StandardFonts.WIN_char_encoding_table[160] = " ";
                StandardFonts.WIN_char_encoding_table[255] = "-";
                StandardFonts.unicode_char_decoding_table[2][160] = "space";
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for " + idx);
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static String getEncodedChar(int font_encoding, int char_int) {
        String return_character = null;
        if (font_encoding == 2) {
            return_character = WIN_char_encoding_table[char_int];
        } else if (font_encoding == 1) {
            return_character = STD_char_encoding_table[char_int];
        } else if (font_encoding == 0) {
            return_character = MAC_char_encoding_table[char_int];
        } else if (font_encoding == 6) {
            return_character = PDF_char_encoding_table[char_int];
        } else if (font_encoding == 5) {
            return_character = ZAPF_char_encoding_table[char_int];
        } else if (font_encoding == 4) {
            return_character = SYMBOL_char_encoding_table[char_int];
        } else if (font_encoding == 3) {
            return_character = MACEXPERT_char_encoding_table[char_int];
        }
        if (return_character == null) {
            return_character = "&#" + char_int + ';';
        }
        return return_character;
    }

    public static boolean isValidMacEncoding(int idx) {
        return MAC_char_encoding_table[idx] != null;
    }

    public static boolean isValidWinEncoding(int idx) {
        return WIN_char_encoding_table[idx] != null;
    }

    public static void checkLoaded(int enc) {
        if (enc == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(enc);
        } else if (enc == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (enc == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (enc == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    private static final void loadStandardFont(int i) throws IOException {
        String line = "";
        String next_command = "";
        String char_name = "";
        BufferedReader input_stream = null;
        float width = 200.0f;
        input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[i] + ".afm"), enc));
        boolean char_mapping_table = false;
        while ((line = input_stream.readLine()) != null) {
            if (line.startsWith("EndCharMetrics")) {
                char_mapping_table = false;
            }
            if (char_mapping_table) {
                StringTokenizer values = new StringTokenizer(line, " ;");
                while (values.hasMoreTokens()) {
                    next_command = values.nextToken();
                    if (next_command.equals("WX")) {
                        width = Float.parseFloat(values.nextToken()) / 1000.0f;
                        continue;
                    }
                    if (!next_command.equals("N")) continue;
                    char_name = values.nextToken();
                }
                widthTableStandard.put(String.valueOf(files_names_bis[i]) + char_name, new Float(width));
                widthTableStandard.put(String.valueOf(files_names[i]) + char_name, new Float(width));
            }
            if (!line.startsWith("StartCharMetrics")) continue;
            char_mapping_table = true;
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    protected static void loadStandardFontWidth(String fontName) {
        Integer fileNumber = (Integer)standardFileList.get(fontName);
        if (fileNumber != null && standardFontLoaded.get(fileNumber) == null) {
            standardFontLoaded.put(fileNumber, "x");
            try {
                StandardFonts.loadStandardFont(fileNumber);
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] " + e + " problem reading lookup table for pdf font " + fontName + ' ' + fontName);
            }
        }
    }

    public static int lookupCharacterIndex(String glyph, int idx) {
        Object value = glyphToChar[idx].get(glyph);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    private static void loadAdobeMap() {
        BufferedReader input_stream = null;
        if (adobeMap == null) {
            try {
                String line;
                adobeMap = new Hashtable();
                input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/glyphlist.cfg"), enc));
                if (input_stream == null) {
                    LogWriter.writeLog("Unable to open sglyphlist.cfg from jar");
                }
                while ((line = input_stream.readLine()) != null) {
                    if (line.startsWith("#") || line.indexOf(59) == -1) continue;
                    StringTokenizer vals = new StringTokenizer(line, ";");
                    String key = vals.nextToken();
                    String operand = vals.nextToken();
                    int space = operand.indexOf(32);
                    if (space != -1) {
                        operand = operand.substring(0, space);
                    }
                    int opVal = Integer.parseInt(operand, 16);
                    adobeMap.put(key, new Integer(opVal));
                    unicode_name_mapping_table.put(key, Character.toString((char)opVal));
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
                e.printStackTrace();
            }
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static int getAdobeMap(String key) {
        return (Integer)adobeMap.get(key);
    }

    public static boolean isValidGlyphName(String key) {
        if (key == null) {
            return false;
        }
        return adobeMap.get(key) != null;
    }

    public static boolean isStandardFont(String fontName) {
        return standardFileList.get(fontName) != null;
    }

    public static String[] readPostscriptNames(int type, String subFont) throws Exception {
        String[] fontNames = new String[]{""};
        if (type == 2 || type == 7) {
            TTGlyphs currentFont = new TTGlyphs();
            fontNames = currentFont.readPostScriptFontNames(new FontData(subFont));
        }
        return fontNames;
    }

    public static String convertNumberToGlyph(String mappedChar) {
        int charCount = mappedChar.length();
        boolean isNumber = true;
        if (mappedChar.length() == 2 || mappedChar.length() == 3) {
            int ii = 0;
            while (ii < charCount) {
                char c = mappedChar.charAt(ii);
                if (c < '0' || c > '9') {
                    isNumber = false;
                    ii = charCount;
                }
                ++ii;
            }
            if (isNumber) {
                mappedChar = String.valueOf((char)Integer.parseInt(mappedChar));
            }
        }
        return mappedChar;
    }
}

