/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jpedal.utils.LogWriter;

public class PdfHeightTable {
    private int[][] default_height_lookup = new int[200][256];
    private ClassLoader loader = this.getClass().getClassLoader();
    private static final String enc = "Cp1252";

    public PdfHeightTable() {
        BufferedReader input_stream = null;
        String line = null;
        try {
            input_stream = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/font_heights.cfg"), enc));
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open font_heights.cfg from jar");
            }
            while ((line = input_stream.readLine()) != null) {
                int value;
                int pointer1 = line.indexOf(45);
                int pointer2 = line.indexOf(58);
                int key1 = Integer.parseInt(line.substring(0, pointer1).trim());
                int key2 = Integer.parseInt(line.substring(pointer1 + 1, pointer2).trim());
                this.default_height_lookup[key1][key2] = value = Integer.parseInt(line.substring(pointer2 + 1, line.length()).trim());
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception " + ee + " reading line from height table");
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public final float getCharHeight(int char_number, int current_font_size) {
        if (current_font_size < 0) {
            current_font_size = -current_font_size;
        }
        float height = 0.0f;
        if (current_font_size < 200 & char_number < 256) {
            height = this.default_height_lookup[current_font_size][char_number];
        }
        return height;
    }
}

