/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfArray;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;

public class PdfFont
implements Serializable {
    public Font javaFont = null;
    protected String embeddedFontName = null;
    protected String embeddedFamilyName = null;
    protected String copyright = null;
    private float missingWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    protected boolean cleanupFonts = false;
    protected String substituteFont = null;
    protected boolean renderPage = false;
    private static final float xscale = 0.001f;
    protected int embeddedEnc = 1;
    protected String[] diffs;
    public boolean isFontEmbedded = false;
    protected boolean TTstreamisCID = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    private boolean isDoubleByte = false;
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private int spaceChar = -1;
    private String[] diffTable;
    private int fontFlag = 0;
    private float[] widthTable;
    private float possibleSpaceWidth = -1.0f;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    protected String[] CMAP;
    protected String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    protected boolean hasFontEncoding;
    protected int italicAngle = 0;
    private static boolean isCidJarPresent;

    static {
        PdfFont.setStandardFontMappings();
    }

    public PdfFont() {
    }

    public void createFont(String fontName) throws Exception {
    }

    public PdfFont(PdfObjectReader current_pdf_file) {
        this.init(current_pdf_file);
    }

    public static void setStandardFontMappings() {
        String value;
        String key;
        int count = StandardFonts.files_names.length;
        int i = 0;
        while (i < count) {
            key = StandardFonts.files_names_bis[i].toLowerCase();
            if (!key.equals(value = StandardFonts.javaFonts[i].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(key)) {
                FontMappings.fontSubstitutionAliasTable.put(key, value);
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            key = StandardFonts.files_names[i].toLowerCase();
            if (!key.equals(value = StandardFonts.javaFonts[i].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(key)) {
                FontMappings.fontSubstitutionAliasTable.put(key, value);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[i], "x");
            ++i;
        }
        FontMappings.fontSubstitutionAliasTable.put("arialmt", "arial");
        FontMappings.fontSubstitutionAliasTable.put("arial-boldmt", "arialbd");
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    protected final void setCIDFontDefaultWidth(String value) {
        this.defaultWidth = Float.parseFloat(value) / 1000.0f;
    }

    protected final void setCIDFontWidths(String values) {
        values = values.substring(1, values.length() - 1).trim();
        this.widthTable = new float[65536];
        int ii = 0;
        while (ii < 65536) {
            this.widthTable[ii] = -1.0f;
            ++ii;
        }
        StringTokenizer widthValues = new StringTokenizer(values, " []", true);
        block1: while (widthValues.hasMoreTokens()) {
            String nextValue;
            if (!widthValues.hasMoreTokens()) break;
            while ((nextValue = widthValues.nextToken()).equals(" ")) {
            }
            int pointer = Integer.parseInt(nextValue);
            while ((nextValue = widthValues.nextToken()).equals(" ")) {
            }
            if (nextValue.equals("[")) {
                while (true) {
                    if ((nextValue = widthValues.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (nextValue.equals("]")) continue block1;
                    this.widthTable[pointer] = Float.parseFloat(nextValue) / 1000.0f;
                    ++pointer;
                }
            }
            int endPointer = 1 + Integer.parseInt(nextValue);
            while ((nextValue = widthValues.nextToken()).equals(" ")) {
            }
            int ii2 = pointer;
            while (ii2 < endPointer) {
                this.widthTable[ii2] = Float.parseFloat(nextValue) / 1000.0f;
                ++ii2;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader current_pdf_file) {
        this.currentPdfFile = current_pdf_file;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    private final String getUnicodeMapping(int char_int) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[char_int];
    }

    protected final void putFontEncoding(int enc) {
        this.fontEnc = enc;
        StandardFonts.checkLoaded(enc);
    }

    public final String getUnicodeValue(String displayValue, int rawInt) {
        String textValue = this.getUnicodeMapping(rawInt);
        if (textValue == null) {
            textValue = displayValue;
        }
        return textValue;
    }

    public final String getGlyphValue(int rawInt) {
        if (this.cachedValue[rawInt] != null) {
            return this.cachedValue[rawInt];
        }
        String return_value = null;
        if (this.isCIDFont) {
            String unicodeMappings = this.getUnicodeMapping(rawInt);
            if (unicodeMappings != null) {
                return_value = unicodeMappings;
            }
            if (return_value == null) {
                String fontEncoding = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    return_value = this.diffTable[rawInt];
                } else if (fontEncoding != null) {
                    String newChar;
                    if (fontEncoding.startsWith("Identity-")) {
                        return_value = String.valueOf((char)rawInt);
                    } else if (this.CMAP != null && (newChar = this.CMAP[rawInt]) != null) {
                        return_value = newChar;
                    }
                }
                if (return_value == null) {
                    return_value = String.valueOf((char)rawInt);
                }
            }
        } else {
            return_value = this.getStandardGlyphValue(rawInt);
        }
        this.cachedValue[rawInt] = return_value;
        return return_value;
    }

    private final Map handleCIDEncoding(String encodingType) throws PdfFontException {
        String CMapName;
        String line = "";
        boolean inDefinition = false;
        BufferedReader CIDstream = null;
        Map obj = null;
        if (encodingType.indexOf(" R") != -1 && (CMapName = (String)(obj = this.currentPdfFile.readObject(encodingType, false, null)).get("CMapName")) != null) {
            byte[] stream = this.currentPdfFile.readStream(encodingType, true);
            encodingType = CMapName;
            CIDstream = new BufferedReader(new StringReader(new String(stream)));
        }
        if (encodingType.startsWith("/")) {
            encodingType = encodingType.substring(1);
        }
        if (CIDstream == null) {
            this.CIDfontEncoding = encodingType;
        }
        if (encodingType.startsWith("Identity-")) {
            this.isDoubleByte = true;
            this.glyphs.setIsIdentity(true);
        } else {
            this.glyphs.setIsIdentity(false);
            if (!isCidJarPresent && CIDstream == null) {
                isCidJarPresent = true;
                InputStream in = PdfFont.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf");
                if (in == null) {
                    throw new PdfFontException("cid.jar not on classpath");
                }
            }
            this.CMAP = new String[65536];
            if (encodingType.equals("ETenms-B5-H")) {
                encodingType = "ETen-B5-H";
            } else if (encodingType.equals("ETenms-B5-V")) {
                encodingType = "ETen-B5-V";
            }
            try {
                if (CIDstream == null) {
                    CIDstream = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + encodingType), "Cp1252"));
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("1.Problem reading encoding for CID font " + this.fontID + " encoding=" + encodingType + " Check CID.jar installed");
            }
            if (encodingType.equals("UniJIS-UCS2-H")) {
                this.isDoubleByte = true;
            }
            if (CIDstream != null) {
                while (true) {
                    try {
                        line = CIDstream.readLine();
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("[PDF] Error reading line fron font");
                    }
                    if (line == null) break;
                    if (line.indexOf("endcidrange") != -1) {
                        inDefinition = false;
                    }
                    if (inDefinition) {
                        StringTokenizer CIDentry = new StringTokenizer(line, " <>[]");
                        boolean multiple_values = false;
                        if (line.indexOf(91) != -1) {
                            multiple_values = true;
                        }
                        int begin = Integer.parseInt(CIDentry.nextToken(), 16);
                        int end = Integer.parseInt(CIDentry.nextToken(), 16);
                        int entry = Integer.parseInt(CIDentry.nextToken(), 16);
                        int i = begin;
                        while (i < end + 1) {
                            if (multiple_values) {
                                entry = Integer.parseInt(CIDentry.nextToken(), 16);
                                this.CMAP[i] = String.valueOf((char)entry);
                            } else {
                                this.CMAP[i] = String.valueOf((char)entry);
                                ++entry;
                            }
                            ++i;
                        }
                    }
                    if (line.indexOf("begincidrange") == -1) continue;
                    inDefinition = true;
                }
            }
        }
        if (CIDstream != null) {
            try {
                CIDstream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("2.Problem reading encoding for CID font " + this.fontID + ' ' + encodingType + " Check CID.jar installed");
            }
        }
        return obj;
    }

    public final String getStandardGlyphValue(int char_int) {
        String unicode_char = this.getUnicodeMapping(char_int);
        if (unicode_char != null) {
            return unicode_char;
        }
        String return_value = "";
        int font_encoding = this.getFontEncoding(true);
        String mapped_char = this.getMappedChar(char_int, true);
        if (mapped_char != null) {
            String char_mapping = StandardFonts.getUnicodeName(String.valueOf(this.fontEnc) + mapped_char);
            if (char_mapping != null) {
                return_value = char_mapping;
            } else {
                char_mapping = StandardFonts.getUnicodeName(mapped_char);
                if (char_mapping != null) {
                    return_value = char_mapping;
                } else if (mapped_char.length() == 1) {
                    return_value = mapped_char;
                } else if (mapped_char.length() > 1) {
                    boolean isHex;
                    char c = mapped_char.charAt(0);
                    char c2 = mapped_char.charAt(1);
                    if (c == 'B' | c == 'C' | c == 'c' | c == 'G') {
                        mapped_char = mapped_char.substring(1);
                        try {
                            int val = this.isHex ? Integer.valueOf(mapped_char, 16) : Integer.parseInt(mapped_char);
                            return_value = String.valueOf((char)val);
                        }
                        catch (Exception e) {
                            return_value = "";
                        }
                    } else {
                        return_value = "";
                    }
                    boolean bl = isHex = (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F');
                    if (return_value.length() == 0 && this.fontTypes == 3 && mapped_char.length() == 2 && isHex) {
                        try {
                            return_value = String.valueOf((char)Integer.parseInt(mapped_char, 16));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (return_value.length() == 0 && this.fontTypes == 3) {
                        return_value = String.valueOf((char)char_int);
                    }
                } else {
                    return_value = "";
                }
            }
        } else if (font_encoding > -1) {
            return_value = StandardFonts.getEncodedChar(font_encoding, char_int);
        }
        return return_value;
    }

    public final Font getJavaFont(int size) {
        String font_family_name;
        int style = 0;
        boolean isJavaFontInstalled = false;
        String weight = null;
        Object mappedName = null;
        String testFont = font_family_name = this.glyphs.fontName;
        if (font_family_name != null) {
            testFont = font_family_name.toLowerCase();
        }
        if (testFont.equals("arialmt")) {
            font_family_name = testFont = "arial";
        } else if (testFont.equals("arial-boldmt")) {
            font_family_name = testFont = "arial Bold";
        }
        if (mappedName != null) {
            font_family_name = mappedName;
            testFont = font_family_name.toLowerCase();
        }
        if (PdfJavaGlyphs.fontList != null) {
            int count = PdfJavaGlyphs.fontList.length;
            int i = 0;
            while (i < count) {
                System.out.println(String.valueOf(PdfJavaGlyphs.fontList[i]) + "<>" + testFont);
                if (PdfJavaGlyphs.fontList[i].indexOf(testFont) != -1) {
                    isJavaFontInstalled = true;
                    font_family_name = PdfJavaGlyphs.fontList[i];
                    i = count;
                }
                ++i;
            }
        }
        if (!isJavaFontInstalled && weight == null) {
            String test = font_family_name.toLowerCase();
            if (test.indexOf("heavy") != -1) {
                style = 1;
            } else if (test.indexOf("bold") != -1) {
                style = 1;
            } else if (test.indexOf("roman") != -1) {
                style = 0;
            }
            if (test.indexOf("italic") != -1) {
                style += 2;
            } else if (test.indexOf("oblique") != -1) {
                style += 2;
            }
        }
        if (isJavaFontInstalled) {
            return new Font(font_family_name, style, size);
        }
        System.out.println("No match with " + this.glyphs.getBaseFontName() + ' ' + ' ' + testFont + ' ' + weight + ' ' + style);
        System.exit(1);
        return null;
    }

    public final void setDefaultDisplayFont(String fontName) {
        this.glyphs.defaultFont = fontName;
    }

    public final Font getJavaFontX(int size) {
        return new Font(this.glyphs.font_family_name, this.glyphs.style, size);
    }

    protected final void readGenericFontMetadata(Map values) {
        String baseFontName;
        String fontBounding;
        LogWriter.writeMethod("{readGenericFontMetadata " + this.fontID + '}', 0);
        String fontMatrix = (String)values.get("FontMatrix");
        if (fontMatrix != null) {
            StringTokenizer tokens = new StringTokenizer(fontMatrix, "[] ");
            int i = 0;
            while (i < 6) {
                this.FontMatrix[i] = Float.parseFloat(tokens.nextToken());
                ++i;
            }
        }
        if ((fontBounding = (String)values.get("FontBBox")) != null) {
            this.FontBBox = PdfArray.convertToFloatArray(fontBounding);
        }
        if ((baseFontName = this.currentPdfFile.getValue((String)values.get("BaseFont"))) == null) {
            baseFontName = this.currentPdfFile.getValue((String)values.get("FontName"));
        }
        baseFontName = baseFontName == null ? this.fontID : baseFontName.substring(1);
        if (this.cleanupFonts || PdfStreamDecoder.runningStoryPad) {
            baseFontName = this.cleanupFontName(baseFontName);
        }
        this.glyphs.fontName = baseFontName;
        int index = baseFontName.indexOf(43);
        if (index == 6) {
            this.glyphs.fontName = baseFontName.substring(index + 1);
        }
        this.glyphs.setBaseFontName(baseFontName);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final void setBaseFontName(String fontName) {
        this.glyphs.setBaseFontName(fontName);
    }

    public final void setFontName(String fontName) {
        this.glyphs.fontName = fontName;
    }

    public final float getCurrentFontSpaceWidth() {
        int space_value = this.spaceChar;
        float width = space_value != -1 ? this.getWidth(space_value) : this.possibleSpaceWidth;
        if (width == -1.0f) {
            width = 0.2f;
        }
        return width;
    }

    protected final int getFontEncoding(boolean notNull) {
        int result = this.fontEnc;
        if (result == -1 && notNull) {
            result = 1;
        }
        return result;
    }

    public final float getWidth(int charInt) {
        float width = -1.0f;
        if (this.widthTable != null && charInt != -1) {
            width = this.widthTable[charInt];
        }
        if (width == -1.0f) {
            if (this.isCIDFont) {
                width = this.defaultWidth;
            } else {
                Float value;
                String charName = this.getMappedChar(charInt, false);
                if (charName != null && charName.equals(".notdef")) {
                    charName = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
                }
                width = (value = StandardFonts.getStandardWidth(this.glyphs.fontName, charName)) != null ? value.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f);
            }
        }
        return width;
    }

    public Map createCIDFont(Map values, Map descFontValues) throws PdfFontException {
        Object fontDescriptorRef;
        Object CIDtoGIDvalue;
        String defaultWidth;
        String rawWidths;
        Object toUnicode;
        Map fontDescriptor = null;
        Map obj = null;
        this.cachedValue = new String[65536];
        String encoding = (String)values.get("Encoding");
        if (encoding != null) {
            obj = this.handleCIDEncoding(encoding);
        }
        if ((toUnicode = values.get("ToUnicode")) != null) {
            if (toUnicode instanceof String) {
                String ref = (String)toUnicode;
                if (ref.indexOf(" R") != -1) {
                    this.readUnicode(this.currentPdfFile.readStream(ref, true), this.fontID);
                }
            } else {
                this.readUnicode((byte[])((Map)toUnicode).get("DecodedStream"), this.fontID);
            }
        }
        if ((rawWidths = this.currentPdfFile.getValue((String)descFontValues.get("W"))) != null) {
            this.setCIDFontWidths(rawWidths);
        }
        if ((defaultWidth = this.currentPdfFile.getValue((String)descFontValues.get("DW"))) != null) {
            this.setCIDFontDefaultWidth(defaultWidth);
        }
        if ((CIDtoGIDvalue = descFontValues.get("CIDToGIDMap")) != null) {
            if (CIDtoGIDvalue instanceof String) {
                String CIDtoGIDMap = (String)CIDtoGIDvalue;
                if (CIDtoGIDMap.endsWith(" R")) {
                    byte[] CIDMaps = this.currentPdfFile.readStream(CIDtoGIDMap, true);
                    int j = 0;
                    int[] CIDToGIDMap = new int[CIDMaps.length / 2];
                    int i = 0;
                    while (i < CIDMaps.length) {
                        int val;
                        CIDToGIDMap[j] = val = ((CIDMaps[i] & 0xFF) << 8) + (CIDMaps[i + 1] & 0xFF);
                        ++j;
                        i += 2;
                    }
                    this.glyphs.setGIDtoCID(CIDToGIDMap);
                } else if (CIDtoGIDMap.equals("/Identity")) {
                    this.handleCIDEncoding("Identity-");
                } else {
                    LogWriter.writeLog("not yet supported in demo.");
                    System.err.println("not yet supported in demo.");
                }
            } else {
                LogWriter.writeLog("not yet supported in demo.");
                System.err.println("not yet supported in demo.");
            }
        }
        Object Info = descFontValues.get("CIDSystemInfo");
        Map CIDSystemInfo = new Hashtable();
        CIDSystemInfo = Info instanceof Map ? (Map)Info : this.currentPdfFile.readObject((String)Info, false, null);
        String ordering = (String)CIDSystemInfo.get("Ordering");
        if (ordering != null) {
            if (ordering.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
                this.TTstreamisCID = false;
            } else if (ordering.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + ordering);
            } else if (ordering.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + ordering);
            }
            if (this.substituteFontName != null) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + ordering);
            }
        }
        if ((fontDescriptorRef = descFontValues.get("FontDescriptor")) != null) {
            fontDescriptor = null;
            if (fontDescriptorRef instanceof String) {
                String ref = (String)fontDescriptorRef;
                if (ref.length() > 1) {
                    fontDescriptor = this.currentPdfFile.readObject(ref, false, null);
                }
            } else {
                fontDescriptor = (Map)fontDescriptorRef;
            }
            if (fontDescriptor != null) {
                this.readGenericFontMetadata(fontDescriptor);
            }
        }
        return fontDescriptor;
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(Map values) throws Exception {
        LogWriter.writeMethod("{readWidths}" + values, 0);
        String firstChar = this.currentPdfFile.getValue((String)values.get("FirstChar"));
        int firstCharNumber = 1;
        if (firstChar != null) {
            firstCharNumber = ToInteger.getInteger(firstChar);
        }
        String lastChar = this.currentPdfFile.getValue((String)values.get("LastChar"));
        float shortestWidth = 0.0f;
        String width_value = this.currentPdfFile.getValue((String)values.get("Widths"));
        if (width_value != null) {
            this.widthTable = new float[this.maxCharCount];
            int ii = 0;
            while (ii < this.maxCharCount) {
                this.widthTable[ii] = -1.0f;
                ++ii;
            }
            String rawWidths = width_value.substring(1, width_value.length() - 1).trim();
            StringTokenizer widthValues = new StringTokenizer(rawWidths);
            int lastCharNumber = ToInteger.getInteger(lastChar);
            float ratio = (float)(1.0 / this.FontMatrix[0]);
            if (ratio < 0.0f) {
                ratio = -ratio;
            }
            int i = firstCharNumber;
            while (i < lastCharNumber + 1) {
                float widthValue;
                if (!widthValues.hasMoreTokens()) {
                    widthValue = 0.0f;
                } else {
                    widthValue = this.fontTypes == 3 ? Float.parseFloat(widthValues.nextToken()) / ratio : Float.parseFloat(widthValues.nextToken()) * 0.001f;
                    this.widthTable[i] = widthValue;
                    if (widthValue > 0.0f) {
                        shortestWidth += widthValue;
                    }
                }
                ++i;
            }
        }
    }

    public Map createFont(Map values, String fontID, boolean renderPage, Map descFontValues, ObjectStore objectStore) throws Exception {
        Object encValue;
        Object toUnicode;
        LogWriter.writeMethod("{readNonCIDFont}" + values + "{render=" + renderPage, 0);
        if (PdfJavaGlyphs.fontList == null & renderPage) {
            PdfJavaGlyphs.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int count = PdfJavaGlyphs.fontList.length;
            int i = 0;
            while (i < count) {
                PdfJavaGlyphs.fontList[i] = PdfJavaGlyphs.fontList[i].toLowerCase();
                ++i;
            }
        }
        this.fontID = fontID;
        this.renderPage = renderPage;
        this.readGenericFontMetadata(values);
        String fontType = (String)values.get("Subtype");
        if (fontType == null) {
            fontType = "";
        }
        if ((toUnicode = values.get("ToUnicode")) != null) {
            if (toUnicode instanceof String) {
                this.readUnicode(this.currentPdfFile.readStream((String)toUnicode, true), fontID);
            } else {
                this.readUnicode((byte[])((Map)toUnicode).get("DecodedStream"), fontID);
            }
        }
        String firstChar = (String)values.get("FirstChar");
        int firstCharNumber = 1;
        if (firstChar != null) {
            firstCharNumber = ToInteger.getInteger(firstChar);
        }
        String lastChar = (String)values.get("LastChar");
        float shortestWidth = 0.0f;
        int count = 0;
        String width_value = this.currentPdfFile.getValue((String)values.get("Widths"));
        if (width_value != null) {
            this.widthTable = new float[this.maxCharCount];
            int ii = 0;
            while (ii < this.maxCharCount) {
                this.widthTable[ii] = -1.0f;
                ++ii;
            }
            String rawWidths = width_value.substring(1, width_value.length() - 1).trim();
            StringTokenizer widthValues = new StringTokenizer(rawWidths);
            int lastCharNumber = ToInteger.getInteger(lastChar) + 1;
            float ratio = (float)(1.0 / this.FontMatrix[0]);
            ratio = -ratio;
            int i = firstCharNumber;
            while (i < lastCharNumber) {
                float widthValue = !widthValues.hasMoreTokens() ? 0.0f : (this.fontTypes == 3 ? Float.parseFloat(widthValues.nextToken()) / ratio : Float.parseFloat(widthValues.nextToken()) * 0.001f);
                this.widthTable[i] = widthValue;
                if (widthValue > 0.0f) {
                    shortestWidth += widthValue;
                    ++count;
                }
                ++i;
            }
        }
        if ((encValue = values.get("Encoding")) != null) {
            if (encValue instanceof String) {
                this.handleFontEncoding((String)encValue, null, fontType);
            } else {
                this.handleFontEncoding("", (Map)encValue, fontType);
            }
        } else {
            this.handleNoEncoding(0);
        }
        if (count > 0) {
            this.possibleSpaceWidth = shortestWidth / (float)(2 * count);
        }
        Map fontDescriptor = null;
        Object rawFont = values.get("FontDescriptor");
        if (rawFont instanceof String) {
            String fontDescriptorRef = (String)rawFont;
            if (fontDescriptorRef != null && fontDescriptorRef.length() > 1) {
                fontDescriptor = this.currentPdfFile.readObject(fontDescriptorRef, false, null);
            }
        } else {
            fontDescriptor = (Map)rawFont;
        }
        if (fontDescriptor != null) {
            int flags = 0;
            String value = (String)fontDescriptor.get("Flags");
            if (value != null) {
                flags = Integer.parseInt(value);
            }
            this.fontFlag = flags;
            this.glyphs.remapFont = false;
            int flag = this.fontFlag;
            if ((flag & 4) == 4) {
                this.glyphs.remapFont = true;
            }
            if ((value = this.currentPdfFile.getValue((String)fontDescriptor.get("MissingWidth"))) != null) {
                this.missingWidth = Float.parseFloat(value);
            }
        }
        return fontDescriptor;
    }

    private int handleNoEncoding(int encValue) {
        String font = this.getBaseFontName();
        if (font.equals("ZapfDingbats") || font.equals("ZaDb")) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            encValue = 5;
        } else if (font.equals("Symbol")) {
            this.putFontEncoding(4);
            encValue = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return encValue;
    }

    private final void handleFontEncoding(String ref, Map values, String fontType) {
        this.hasFontEncoding = true;
        int encoding = this.getFontEncoding(false);
        String encName = "";
        int encValue = encoding;
        if (encValue == -1) {
            encValue = fontType.equals("/TrueType") ? 0 : 1;
        }
        if (ref.indexOf(32) != -1 | values != null) {
            String ref2;
            String baseEncoding;
            if (values == null) {
                values = this.currentPdfFile.readObject(ref, false, null);
            }
            if ((baseEncoding = this.currentPdfFile.getValue((String)values.get("BaseEncoding"))) == null && (ref2 = (String)values.get("rawValue")) != null) {
                baseEncoding = ref2;
            }
            String diffs = this.currentPdfFile.getValue((String)values.get("Differences"));
            if (baseEncoding != null) {
                if (baseEncoding.startsWith("/")) {
                    baseEncoding = baseEncoding.substring(1);
                }
                encName = baseEncoding;
                this.hasEncoding = true;
            } else {
                encValue = this.handleNoEncoding(encValue);
            }
            if (diffs != null) {
                this.glyphs.setIsSubsetted(true);
                diffs = Strip.removeArrayDeleminators(diffs);
                int pointer = 0;
                String ignoreValues = " \r\n";
                StringTokenizer eachValue = new StringTokenizer(diffs, " /\r\n", true);
                while (eachValue.hasMoreTokens()) {
                    String value = eachValue.nextToken();
                    if (ignoreValues.indexOf(value) != -1) continue;
                    if (value.equals("/")) {
                        value = eachValue.nextToken();
                        while (ignoreValues.indexOf(value) != -1) {
                            value = eachValue.nextToken();
                        }
                        if ((value = StandardFonts.convertNumberToGlyph(value)).startsWith("space")) {
                            this.spaceChar = pointer;
                        }
                        this.putMappedChar(pointer, value);
                        ++pointer;
                        char c = value.charAt(0);
                        if (!(c == 'B' | c == 'c' | c == 'C' | c == 'G')) continue;
                        int i = 1;
                        int l = value.length();
                        while (!this.isHex && i < l) {
                            this.isHex = Character.isLetter(value.charAt(i++));
                        }
                        continue;
                    }
                    if (!Character.isDigit(value.charAt(0))) continue;
                    pointer = Integer.parseInt(value);
                }
            }
        } else {
            encName = ref;
        }
        if (encName.indexOf("MacRomanEncoding") != -1) {
            encValue = 0;
        } else if (encName.indexOf("WinAnsiEncoding") != -1) {
            encValue = 2;
        } else if (encName.indexOf("MacExpertEncoding") != -1) {
            encValue = 3;
        } else if (encName.indexOf("STD") == -1 & encValue == -1) {
            LogWriter.writeLog("Encoding type " + encName + " not implemented");
        }
        if (encValue > -1) {
            this.putFontEncoding(encValue);
        }
    }

    protected final void putMappedChar(int charInt, String mappedChar) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (this.diffTable[charInt] == null) {
            this.diffTable[charInt] = mappedChar;
        }
    }

    public double getType3Ydisplacement(int rawInt) {
        return 0.0;
    }

    public final String getMappedChar(int charInt, boolean remap) {
        String result = null;
        if (this.diffTable != null) {
            result = this.diffTable[charInt];
        }
        if (remap && result != null && result.equals(".notdef")) {
            result = " ";
        }
        if (result == null && charInt < 335) {
            result = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
        }
        if (result == null && charInt > 40 && this.getFontEncoding(true) == 2) {
            result = "bullet";
        }
        if (this.isFontEmbedded && result == null) {
            if (this.diffs != null) {
                result = this.diffs[charInt];
            }
            if (result == null && charInt < 335) {
                result = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return result;
    }

    public final String getEmbeddedChar(int charInt) {
        String embeddedResult = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                embeddedResult = this.diffs[charInt];
            }
            if (embeddedResult == null && charInt < 256) {
                embeddedResult = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return embeddedResult;
    }

    protected final void readUnicode(byte[] data, String font_ID) {
        int inDefinition = 0;
        BufferedReader unicode_mapping_stream = null;
        ByteArrayInputStream bis = null;
        this.unicodeMappings = new String[this.maxCharCount];
        try {
            bis = new ByteArrayInputStream(data);
            unicode_mapping_stream = new BufferedReader(new InputStreamReader(bis));
            String lastLine = null;
            if (unicode_mapping_stream != null) {
                while (true) {
                    String line;
                    if (lastLine == null) {
                        line = unicode_mapping_stream.readLine();
                    } else {
                        line = lastLine;
                        lastLine = null;
                    }
                    if (line != null) {
                        int i;
                        int entry;
                        String rawEntry;
                        int begin;
                        if (line.indexOf("endbf") != -1) {
                            inDefinition = 0;
                        }
                        if (inDefinition == 1) {
                            StringTokenizer unicode_entry = new StringTokenizer(line, " <>[]");
                            if (unicode_entry.countTokens() > 1) {
                                begin = Integer.parseInt(unicode_entry.nextToken(), 16);
                                rawEntry = unicode_entry.nextToken();
                                String value = "";
                                if (rawEntry.length() < 4) {
                                    entry = Integer.parseInt(unicode_entry.nextToken(), 16);
                                    value = String.valueOf((char)entry);
                                } else {
                                    i = 0;
                                    while (i < rawEntry.length()) {
                                        entry = Integer.parseInt(rawEntry.substring(i, i + 4), 16);
                                        value = String.valueOf(value) + String.valueOf((char)entry);
                                        i += 4;
                                    }
                                }
                                this.unicodeMappings[begin] = value;
                            }
                        } else if (inDefinition == 2 && line.length() > 0) {
                            StringTokenizer unicode_entry = new StringTokenizer(line, " <>[]");
                            begin = Integer.parseInt(unicode_entry.nextToken(), 16);
                            int end = Integer.parseInt(unicode_entry.nextToken(), 16);
                            rawEntry = "";
                            while (unicode_entry.hasMoreTokens()) {
                                rawEntry = String.valueOf(rawEntry) + unicode_entry.nextToken();
                            }
                            int offset = 0;
                            i = begin;
                            while (i < end + 1) {
                                String value = "";
                                int count = rawEntry.length();
                                int ii = 0;
                                while (ii < count) {
                                    entry = Integer.parseInt(rawEntry.substring(ii, ii + 4), 16);
                                    if (i + 4 > count) {
                                        entry += offset;
                                    }
                                    value = String.valueOf(value) + String.valueOf((char)entry);
                                    ii += 4;
                                }
                                this.unicodeMappings[i] = value;
                                ++offset;
                                ++i;
                            }
                        }
                        if (line.indexOf("beginbfchar") != -1) {
                            inDefinition = 1;
                            int ptr = line.indexOf(60);
                            if (ptr == -1) continue;
                            lastLine = line.substring(ptr);
                            continue;
                        }
                        if (line.indexOf("beginbfrange") == -1) continue;
                        inDefinition = 2;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception setting up text object " + e);
        }
        if (unicode_mapping_stream != null) {
            try {
                bis.close();
                unicode_mapping_stream.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception setting up text object " + e1);
            }
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int rawInt) {
        if (this.CMAP == null) {
            return false;
        }
        return this.CMAP[rawInt] != null;
    }

    public float getGlyphWidth(String charGlyph, int rawInt, String displayValue) {
        if (this.fontTypes == 2) {
            return this.glyphs.getTTWidth(charGlyph, rawInt, displayValue, false);
        }
        return 0.0f;
    }

    public void setSubtype(int fontType) {
        this.fontTypes = fontType;
    }

    public void setSubstituted(boolean value) {
        this.isFontSubstituted = value;
    }

    public PdfJavaGlyphs getGlyphData() {
        return this.glyphs;
    }

    public Font setFont(String font, int textSize) {
        return this.glyphs.setFont(font, textSize);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        this.glyphs.setValuesForGlyph(rawInt, charGlyph, displayValue, embeddedChar);
    }

    String cleanupFontName(String baseFontName) {
        int length = baseFontName.length();
        StringBuffer cleanedName = new StringBuffer(length);
        int aa = 0;
        while (aa < length) {
            char c = baseFontName.charAt(aa);
            if (c != ' ' && c != '-') {
                cleanedName.append(c);
            }
            ++aa;
        }
        return cleanedName.toString();
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }
}

