/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.extractheadlines.DateConfiguration;
import org.jpedal.examples.text.extractheadlines.SectionConfiguration;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.utils.Strip;

public class ExtractDate
extends ExtractTextInRectangle {
    private static final boolean debug = false;
    DateConfiguration configDate;
    String[] dateTokens = null;
    private int[] date_x1;
    private int[] date_x2;
    private int[] date_y1;
    private int[] date_y2;
    private String day;
    private String date;
    private String month;
    private String year;
    SectionConfiguration sectionConfig;
    String[] sectionTokens = null;
    boolean isDate = false;
    private int[] section_x1;
    private int[] section_x2;
    private int[] section_y1;
    private int[] section_y2;
    private String section = null;
    private String folio = null;

    public String getFolio() {
        return this.folio;
    }

    public String getSection() {
        return this.section;
    }

    public String getDay() {
        return this.day;
    }

    public String getDate() {
        return this.date;
    }

    public String getMonth() {
        return this.month;
    }

    public String getYear() {
        return this.year;
    }

    private void initSection(String configDir) {
        this.sectionConfig = new SectionConfiguration(configDir);
        this.section = this.sectionConfig.getValue("default_section");
        int tagCount = Integer.parseInt(this.sectionConfig.getValue("xmlCount"));
        this.sectionTokens = new String[tagCount];
        int j = 0;
        while (j < tagCount) {
            this.sectionTokens[j] = this.sectionConfig.getValue("xmlTag_" + j);
            if (showMessages) {
                System.out.println(this.sectionTokens[j]);
            }
            ++j;
        }
        tagCount = Integer.parseInt(this.sectionConfig.getValue("locationCount"));
        this.section_x1 = new int[tagCount];
        this.section_x2 = new int[tagCount];
        this.section_y1 = new int[tagCount];
        this.section_y2 = new int[tagCount];
        String key = "locTag";
        String[] coords = new String[]{"x1", "y1", "x2", "y2"};
        int i = 0;
        while (i < tagCount) {
            int coord = 0;
            while (coord < 4) {
                String currentKey = String.valueOf(key) + '_' + i + '_' + coords[coord];
                String value = this.sectionConfig.getValue(currentKey);
                int numberValue = Integer.parseInt(value);
                switch (coord) {
                    case 0: {
                        this.section_x1[i] = numberValue;
                        break;
                    }
                    case 1: {
                        this.section_y1[i] = numberValue;
                        break;
                    }
                    case 2: {
                        this.section_x2[i] = numberValue;
                        break;
                    }
                    case 3: {
                        this.section_y2[i] = numberValue;
                    }
                }
                ++coord;
            }
            ++i;
        }
    }

    private String extractSection(String extractedText) {
        String section;
        block11: {
            section = null;
            if (showMessages) {
                System.out.println(extractedText);
            }
            if (extractedText != null) break block11;
            return null;
        }
        try {
            HashMap<String, String> sections = new HashMap<String, String>();
            int sectionTokenCount = this.sectionTokens.length;
            int i = 0;
            while (i < sectionTokenCount) {
                sections.put(this.sectionTokens[i], "x");
                ++i;
            }
            Object pageNumber = null;
            section = null;
            String currentToken = null;
            StringTokenizer tokens = new StringTokenizer(extractedText, "<>");
            while (tokens.hasMoreTokens()) {
                if (section == null || pageNumber == null) {
                    currentToken = tokens.nextToken();
                    if (sections.get(currentToken) == null) continue;
                    String font = currentToken;
                    currentToken = tokens.nextToken();
                    boolean isNumber = false;
                    if (isNumber || currentToken.length() <= 2) continue;
                    StringBuffer sectionName = new StringBuffer();
                    while (tokens.hasMoreTokens() && !currentToken.equals("/font")) {
                        if (currentToken.indexOf("SpaceC") != -1) {
                            sectionName.append(' ');
                        } else {
                            sectionName.append(currentToken);
                        }
                        currentToken = tokens.nextToken();
                    }
                    section = sectionName.toString().trim();
                    if (!font.equals("font face=\"TimesClassicDisplay\" style=\"font-size:16pt\"")) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return section;
    }

    private String extractDate(String extractedText) {
        String date;
        block10: {
            date = "";
            if (showMessages) {
                System.out.println(extractedText);
            }
            if (extractedText != null) break block10;
            return null;
        }
        try {
            HashMap<String, String> dates = new HashMap<String, String>();
            int dateTokenCount = this.dateTokens.length;
            int i = 0;
            while (i < dateTokenCount) {
                dates.put(this.dateTokens[i], "x");
                ++i;
            }
            Object pageNumber = null;
            String currentToken = null;
            StringTokenizer tokens = new StringTokenizer(extractedText, "<>");
            while (tokens.hasMoreTokens()) {
                if (date == null || pageNumber == null) {
                    currentToken = tokens.nextToken();
                    if (dates.get(currentToken) == null) continue;
                    String font = currentToken;
                    currentToken = tokens.nextToken();
                    boolean isNumber = false;
                    if (isNumber || currentToken.length() <= 2) continue;
                    StringBuffer dateName = new StringBuffer();
                    while (tokens.hasMoreTokens() && !currentToken.equals("/font")) {
                        if (currentToken.indexOf("SpaceC") != -1) {
                            dateName.append(' ');
                        } else {
                            dateName.append(currentToken);
                        }
                        currentToken = tokens.nextToken();
                    }
                    date = String.valueOf(date) + ' ' + dateName.toString().trim();
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return date;
    }

    public ExtractDate(String file_name, String configDir, PdfData pdf_data) {
        boolean hasDay = file_name.indexOf("TIM") != -1;
        try {
            showMessages = false;
            this.initDate(configDir);
            this.initSection(configDir);
            this.extractValues(pdf_data, 1, hasDay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDate(String configDir) {
        this.configDate = new DateConfiguration(configDir);
        this.date = this.configDate.getValue("default_date");
        int tagCount = Integer.parseInt(this.configDate.getValue("xmlCount"));
        this.dateTokens = new String[tagCount];
        int j = 0;
        while (j < tagCount) {
            this.dateTokens[j] = this.configDate.getValue("xmlTag_" + j);
            if (showMessages) {
                System.out.println(this.dateTokens[j]);
            }
            ++j;
        }
        tagCount = Integer.parseInt(this.configDate.getValue("locationCount"));
        this.date_x1 = new int[tagCount];
        this.date_x2 = new int[tagCount];
        this.date_y1 = new int[tagCount];
        this.date_y2 = new int[tagCount];
        String key = "locTag";
        String[] coords = new String[]{"x1", "y1", "x2", "y2"};
        int i = 0;
        while (i < tagCount) {
            int coord = 0;
            while (coord < 4) {
                String currentKey = String.valueOf(key) + '_' + i + '_' + coords[coord];
                String value = this.configDate.getValue(currentKey);
                int numberValue = Integer.parseInt(value);
                switch (coord) {
                    case 0: {
                        this.date_x1[i] = numberValue;
                        break;
                    }
                    case 1: {
                        this.date_y1[i] = numberValue;
                        break;
                    }
                    case 2: {
                        this.date_x2[i] = numberValue;
                        break;
                    }
                    case 3: {
                        this.date_y2[i] = numberValue;
                    }
                }
                ++coord;
            }
            ++i;
        }
    }

    private void extractValues(PdfData pdfdata, int page, boolean hasDay) {
        int y2;
        int y1;
        int x2;
        int x1;
        PdfGroupingAlgorithms currentGrouping = new PdfGroupingAlgorithms(pdfdata);
        this.date = null;
        int possSetsCoordinates = this.date_x2.length;
        int coordSet = 0;
        while (coordSet < possSetsCoordinates) {
            x1 = this.date_x1[coordSet];
            x2 = this.date_x2[coordSet];
            y1 = this.date_y1[coordSet];
            y2 = this.date_y2[coordSet];
            try {
                this.text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                if (showMessages) {
                    System.out.println("Using (" + x1 + ',' + y1 + ") (" + x2 + ',' + y2 + ") text=" + this.text);
                }
                if (this.text != null) {
                    StringTokenizer st;
                    int count;
                    String rawDate = this.extractDate(this.text);
                    if (showMessages) {
                        System.out.println("Date=" + rawDate + '<');
                    }
                    if (rawDate != null && !rawDate.equals(this.configDate.getValue("default_date")) && ((count = (st = new StringTokenizer(rawDate, ", ")).countTokens()) >= 3 || hasDay && count >= 4)) {
                        if (hasDay) {
                            this.day = st.nextToken();
                        }
                        this.month = st.nextToken();
                        this.date = st.nextToken();
                        this.year = st.nextToken();
                        if (!(this.isString(this.month) && this.isNumber(this.date) && this.isNumber(this.year))) {
                            this.month = null;
                            rawDate = null;
                            this.date = null;
                            this.year = null;
                        }
                    }
                    if (this.month != null && rawDate != null && this.year != null) {
                        coordSet = possSetsCoordinates;
                    }
                }
            }
            catch (Exception ee) {
                System.out.println(ee);
                this.month = null;
                this.date = null;
                this.year = null;
            }
            ++coordSet;
        }
        int possSetSectionCoordinates = this.section_x2.length;
        String section = null;
        int coordSet2 = 0;
        while (coordSet2 < possSetSectionCoordinates) {
            x1 = this.section_x1[coordSet2];
            x2 = this.section_x2[coordSet2];
            y1 = this.section_y1[coordSet2];
            y2 = this.section_y2[coordSet2];
            if (showMessages) {
                System.out.println("Using (" + x1 + ',' + y1 + ") (" + x2 + ',' + y2 + ')');
            }
            try {
                this.text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                if (this.text != null) {
                    this.folio = Strip.stripXML(this.text).toString();
                    section = this.extractSection(this.text);
                    if (section != null) {
                        coordSet2 = possSetSectionCoordinates;
                        if (showMessages) {
                            System.out.println("section=" + section);
                        }
                        this.section = section;
                    }
                }
            }
            catch (PdfException e) {
                this.text = null;
                System.err.println("Exception " + e.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                e.printStackTrace();
            }
            ++coordSet2;
        }
    }

    private boolean isString(String chars) {
        boolean isString = true;
        int count = chars.length();
        int ii = 0;
        while (ii < count) {
            char c = chars.charAt(ii);
            if (!Character.isLetter(c)) {
                isString = false;
                ii = count;
            }
            ++ii;
        }
        return isString;
    }

    private boolean isNumber(String chars) {
        boolean isNumber = true;
        int count = chars.length();
        int ii = 0;
        while (ii < count) {
            char c = chars.charAt(ii);
            if (!Character.isDigit(c)) {
                isNumber = false;
                ii = count;
            }
            ++ii;
        }
        return isNumber;
    }
}

