/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class FindTextInRectangle {
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private String outputDir = "";
    private static String textToFind = "INVOICE";
    private static String testFile = "/home/markee/workspace/jpedalDEV/TestInvoice.pdf";

    public FindTextInRectangle() {
    }

    public FindTextInRectangle(String file_name) {
        File output_path;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (!(output_path = new File(this.outputDir)).exists()) {
            output_path.mkdirs();
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    System.out.println(String.valueOf(file_name) + files[i]);
                    this.decodeFile(String.valueOf(file_name) + files[i]);
                }
                ++i;
            }
        }
    }

    private void decodeFile(String file_name) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        }
        this.outputDir = String.valueOf(this.user_dir) + "text" + this.separator + name + this.separator;
        File page_path = new File(String.valueOf(this.outputDir) + this.separator);
        if (!page_path.exists()) {
            page_path.mkdirs();
        }
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            System.out.println("Opening file :" + file_name);
            this.decodePdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        } else {
            int start = 1;
            int end = this.decodePdf.getPageCount();
            System.out.println("3.31b05STD");
            System.out.println("Looking for word =" + textToFind + '<');
            try {
                int page = start;
                while (page < end + 1) {
                    System.out.println("=========================");
                    System.out.println("Page " + page);
                    System.out.println("=========================");
                    this.decodePdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = this.decodePdf.getGroupingObject();
                    if (currentGrouping != null) {
                        PdfPageData currentPageData = this.decodePdf.getPdfPageData();
                        int x1 = currentPageData.getMediaBoxX(page);
                        int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                        int y2 = currentPageData.getMediaBoxY(page);
                        int y1 = currentPageData.getMediaBoxHeight(page) + y2;
                        System.out.println("Scanning for text (" + textToFind + ") rectangle (" + x1 + ',' + y1 + ' ' + x2 + ',' + y2 + ')');
                        float[] co_ords = null;
                        try {
                            co_ords = currentGrouping.findTextInRectangle(x1, y1, x2, y2, page, textToFind, true, false);
                        }
                        catch (PdfException e) {
                            this.decodePdf.closePdfFile();
                            System.err.println("Exception " + e.getMessage());
                            e.printStackTrace();
                        }
                        if (co_ords == null) {
                            System.out.println("Text not found");
                        } else {
                            System.out.println("Text found at " + co_ords[0] + " , " + co_ords[1]);
                        }
                    }
                    this.decodePdf.flushObjectValues(false);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
            }
            this.decodePdf.flushObjectValues(true);
            System.out.println("Text read");
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to find  text in page");
        String file_name = testFile;
        if (args.length != 2) {
            System.out.println("Please pass \"fileName\" \"text\" as 2 paramters on command line");
            System.out.println("You will need to use quotes if they contain spaces");
        } else {
            file_name = args[0];
            textToFind = args[1];
            System.out.println("File :" + file_name + " looking for " + textToFind);
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        }
        FindTextInRectangle text1 = new FindTextInRectangle(file_name);
    }
}

