/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtractTextTableFromZones {
    private String user_dir = System.getProperty("user.dir");
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    public static boolean showMessages = false;
    private String outputDir = "";
    private static int defX1 = -1;
    private static int defX2;
    private static int defY1;
    private static int defY2;
    private boolean isCSV = true;
    private static String testFile;
    private static String xml_testFile;

    static {
        testFile = "C:/Tables/test.pdf";
        xml_testFile = "C:/Tables/test.xml";
    }

    public ExtractTextTableFromZones() {
    }

    public ExtractTextTableFromZones(String file_name) {
        File output_path;
        String xmlFlag = System.getProperty("xml");
        if (xmlFlag != null) {
            this.isCSV = false;
        }
        if (file_name == null) {
            file_name = testFile;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (!(output_path = new File(this.outputDir)).exists()) {
            output_path.mkdirs();
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (showMessages) {
                    System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                }
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(String.valueOf(file_name) + files[i]);
                    }
                    this.decodeFile(String.valueOf(file_name) + files[i]);
                }
                ++i;
            }
        }
    }

    public ExtractTextTableFromZones(String pdf, String xml, String output) {
        File output_path;
        this.outputDir = output;
        String xmlFlag = System.getProperty("xml");
        if (xmlFlag != null) {
            this.isCSV = false;
        }
        if (pdf == null) {
            pdf = testFile;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (!(output_path = new File(this.outputDir)).exists()) {
            output_path.mkdirs();
        }
        if (pdf.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(pdf, xml, this.outputDir);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!pdf.endsWith(this.separator)) {
                pdf = String.valueOf(pdf) + this.separator;
            }
            try {
                inputFiles = new File(pdf);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(pdf) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (showMessages) {
                    System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                }
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(String.valueOf(pdf) + files[i]);
                    }
                    this.decodeFile(String.valueOf(pdf) + files[i], xml, this.outputDir);
                }
                ++i;
            }
        }
    }

    private void decodeFile(String file_name) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        }
        this.outputDir = String.valueOf(this.user_dir) + "tables" + this.separator + name + this.separator;
        File page_path = new File(String.valueOf(this.outputDir) + this.separator);
        if (!page_path.exists()) {
            page_path.mkdirs();
        }
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            if (showMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decodePdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            System.out.println("Text extraction not allowed");
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        } else {
            int start = 1;
            int end = this.decodePdf.getPageCount();
            try {
                int page = start;
                while (page < end + 1) {
                    int y1;
                    int y2;
                    int x2;
                    int x1;
                    this.decodePdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = this.decodePdf.getGroupingObject();
                    PdfPageData currentPageData = this.decodePdf.getPdfPageData();
                    if (defX1 == -1) {
                        x1 = currentPageData.getMediaBoxX(page);
                        x2 = currentPageData.getMediaBoxWidth(page) + x1;
                        y2 = currentPageData.getMediaBoxY(page);
                        y1 = currentPageData.getMediaBoxHeight(page) + y2;
                    } else {
                        x1 = defX1;
                        y1 = defY1;
                        x2 = defX2;
                        y2 = defY2;
                    }
                    if (showMessages) {
                        System.out.println("Extracting text from rectangle as table(" + x1 + ',' + y1 + ' ' + x2 + ',' + y2 + ')');
                    }
                    String ending = ".xml";
                    if (this.isCSV) {
                        if (showMessages) {
                            System.out.println("Table will be in CSV format");
                        }
                        ending = ".csv";
                    } else if (showMessages) {
                        System.out.println("Table will be in xml format");
                    }
                    Map tableContent = null;
                    String tableText = null;
                    try {
                        tableContent = currentGrouping.extractTextAsTable(x1, y1, x2, y2, page, this.isCSV, false, false, false, 0, false);
                        tableText = (String)tableContent.get("content");
                    }
                    catch (PdfException e) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + e.getMessage() + " with table extraction");
                    }
                    if (tableText == null) {
                        if (showMessages) {
                            System.out.println("No text found");
                        }
                    } else {
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.outputDir) + page + ending), "UTF-8");
                        if (showMessages) {
                            System.out.println("Writing to " + this.outputDir + page + ending);
                        }
                        if (!this.isCSV) {
                            output_stream.write("<xml><BODY>\n\n");
                        }
                        output_stream.write(tableText);
                        if (!this.isCSV) {
                            output_stream.write("\n</body></xml>");
                        }
                        output_stream.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read as table");
            }
        }
        this.decodePdf.closePdfFile();
    }

    private void decodeFile(String pdf, String xml, String output) {
        int itemSelectedCount = 0;
        int[] itemSelectedPage = null;
        int[] values = new int[5];
        File file = new File(xml);
        if (file != null && file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(file);
                NodeList nodes = doc.getElementsByTagName("TablePositions");
                Element currentElement = (Element)nodes.item(0);
                NodeList catNodes = currentElement.getChildNodes();
                ArrayList<Node> catValues = new ArrayList<Node>();
                int items = catNodes.getLength();
                int i = 0;
                while (i < items) {
                    Node next = catNodes.item(i);
                    if (next instanceof Element) {
                        catValues.add(next);
                    }
                    ++i;
                }
                int size = catValues.size();
                int i2 = 0;
                Element next = (Element)catValues.get(i2);
                String key = next.getNodeName();
                String value = next.getAttribute("value");
                if (key.endsWith("Count")) {
                    itemSelectedCount = Integer.parseInt(value);
                    itemSelectedPage = new int[itemSelectedCount];
                }
                itemSelectedPage = new int[itemSelectedCount];
                Vector_Int itemSelectedX1 = new Vector_Int(itemSelectedCount);
                Vector_Int itemSelectedY1 = new Vector_Int(itemSelectedCount);
                Vector_Int itemSelectedWidth = new Vector_Int(itemSelectedCount);
                Vector_Int itemSelectedHeight = new Vector_Int(itemSelectedCount);
                int pages = 0;
                i2 = 0;
                while (i2 < size) {
                    next = (Element)catValues.get(i2);
                    key = next.getNodeName();
                    value = next.getAttribute("value");
                    if (key.endsWith("page")) {
                        itemSelectedPage[pages] = Integer.parseInt(value);
                        ++pages;
                    }
                    if (key.endsWith("x1")) {
                        itemSelectedX1.addElement(Integer.parseInt(value));
                    }
                    if (key.endsWith("y1")) {
                        itemSelectedY1.addElement(Integer.parseInt(value));
                    }
                    if (key.endsWith("x2")) {
                        itemSelectedWidth.addElement(Integer.parseInt(value));
                    }
                    if (key.endsWith("y2")) {
                        itemSelectedHeight.addElement(Integer.parseInt(value));
                    }
                    ++i2;
                }
                int[][] openValues = new int[itemSelectedCount][5];
                i2 = 0;
                int[] x1Array = itemSelectedX1.get();
                int[] x2Array = itemSelectedWidth.get();
                int[] y1Array = itemSelectedY1.get();
                int[] y2Array = itemSelectedHeight.get();
                int pageValue = 0;
                if (showMessages) {
                    System.out.println("\nOpening file :" + pdf);
                }
                while (i2 < itemSelectedCount) {
                    openValues[i2][0] = itemSelectedPage[i2];
                    openValues[i2][1] = x1Array[i2];
                    openValues[i2][2] = x2Array[i2];
                    openValues[i2][3] = y1Array[i2];
                    openValues[i2][4] = y2Array[i2];
                    values = openValues[i2];
                    ++i2;
                    String name = "demo";
                    int pointer = pdf.lastIndexOf(this.separator);
                    if (pointer != -1) {
                        name = pdf.substring(pointer + 1, pdf.length() - 4);
                    }
                    this.outputDir = output.length() == 0 || output == null ? String.valueOf(this.user_dir) + "tables" + this.separator + name + this.separator : String.valueOf(output) + this.separator + "tables" + this.separator + name + this.separator;
                    File page_path = new File(String.valueOf(this.outputDir) + this.separator);
                    if (!page_path.exists()) {
                        page_path.mkdirs();
                    }
                    try {
                        this.decodePdf = new PdfDecoder(false);
                        this.decodePdf.setExtractionMode(1);
                        this.decodePdf.init(true);
                        this.decodePdf.openPdfFile(pdf);
                    }
                    catch (Exception e) {
                        System.err.println("Exception " + e + " in pdf code");
                    }
                    if (!this.decodePdf.isExtractionAllowed()) {
                        System.out.println("Text extraction not allowed");
                        continue;
                    }
                    if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
                        System.out.println("Encrypted settings");
                        System.out.println("Please look at SimpleViewer for code sample to handle such files");
                        System.out.println("Or get support/consultancy");
                        continue;
                    }
                    try {
                        int k = 0;
                        while (k < 5) {
                            int y2;
                            int y1;
                            int x2;
                            int x1;
                            int page = itemSelectedPage[pageValue];
                            ++pageValue;
                            this.decodePdf.decodePage(page);
                            PdfGroupingAlgorithms currentGrouping = this.decodePdf.getGroupingObject();
                            if (defX1 == -1) {
                                x1 = values[++k];
                                x2 = values[++k];
                                y1 = values[++k];
                                y2 = values[++k];
                            } else {
                                x1 = defX1;
                                y1 = defY1;
                                x2 = defX2;
                                y2 = defY2;
                            }
                            if (showMessages) {
                                System.out.println("\nExtracting text from Page " + page + " in rectangle(" + x1 + ',' + y1 + ' ' + x2 + ',' + y2 + ')');
                            }
                            String ending = ".xml";
                            if (this.isCSV) {
                                if (showMessages) {
                                    System.out.println("Table will be in CSV format");
                                }
                                ending = ".csv";
                            } else if (showMessages) {
                                System.out.println("Table will be in xml format");
                            }
                            Map tableContent = null;
                            String tableText = null;
                            try {
                                tableContent = currentGrouping.extractTextAsTable(x1, y1, x2, y2, page, this.isCSV, false, false, false, 0, false);
                                tableText = (String)tableContent.get("content");
                            }
                            catch (PdfException e) {
                                this.decodePdf.closePdfFile();
                                System.err.println("Exception " + e.getMessage() + " with table extraction");
                            }
                            if (tableText == null) {
                                if (showMessages) {
                                    System.out.println("No text found");
                                }
                            } else {
                                OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.outputDir) + pageValue + ending), "UTF-8");
                                if (showMessages) {
                                    System.out.println("Writing to " + this.outputDir + pageValue + ending);
                                }
                                if (!this.isCSV) {
                                    output_stream.write("<xml><BODY>\n\n");
                                }
                                output_stream.write(tableText);
                                if (!this.isCSV) {
                                    output_stream.write("\n</body></xml>");
                                }
                                output_stream.close();
                            }
                            this.decodePdf.flushObjectValues(false);
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + e.getMessage());
                        e.printStackTrace();
                    }
                    this.decodePdf.flushObjectValues(true);
                    if (!showMessages) continue;
                    System.out.println("Text read as table");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.decodePdf.closePdfFile();
        } else {
            System.out.println("File Not Found.");
        }
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to extract text objects as CSV or xml tables");
        String file_name = testFile;
        String xml_file_name = xml_testFile;
        String output = "";
        if (args.length == 1) {
            file_name = args[0];
            System.out.println("File :" + file_name);
        } else if (args.length == 3) {
            file_name = args[0];
            System.out.println("PDF File :" + file_name);
            xml_file_name = args[1];
            System.out.println("XML File :" + xml_file_name);
            output = args[2];
            System.out.println("Output Folder :" + output);
        } else if (args.length == 5) {
            file_name = args[0];
            System.out.println("File :" + file_name);
            System.out.println("User coordinates supplied");
            defX1 = Integer.parseInt(args[1]);
            defY1 = Integer.parseInt(args[2]);
            defX2 = Integer.parseInt(args[3]);
            defY2 = Integer.parseInt(args[4]);
        } else {
            System.out.println("Please call with either ");
            System.out.println("FileName");
            System.out.println("or");
            System.out.println("FileName x1 y1 x2 y2");
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        }
        if (args.length == 1) {
            new ExtractTextTableFromZones(file_name);
        }
        if (args.length == 3) {
            File xml_file = new File(xml_file_name);
            if (!xml_file.exists()) {
                System.out.println("File " + file_name + " not found");
            }
            ExtractTextTableFromZones extractTextTableFromZones = new ExtractTextTableFromZones(file_name, xml_file_name, output);
        }
    }
}

