/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.tablezoning;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.text.ExtractTextTableFromZones;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.TimeNow;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableZoner
extends SimpleViewer {
    private Vector_Int itemSelectedX1 = new Vector_Int(10);
    private Vector_Int itemSelectedY1 = new Vector_Int(10);
    private Vector_Int itemSelectedWidth = new Vector_Int(10);
    private Vector_Int itemSelectedHeight = new Vector_Int(10);
    private Vector_Int pageUsed = new Vector_Int(10);
    private Vector_String imagesStored = new Vector_String(10);
    Vector_Object thumbnailsStored = new Vector_Object(10);
    private Map imagesUsed = new HashMap();
    private Vector_String textStored = new Vector_String(10);
    private Vector_String xmlStored = new Vector_String(10);
    private int itemSelectedCount = 1;
    private boolean showExtractedItems;
    GUIButton showItemsExtracted = new SwingButton();
    GUIButton saveItemsExtracted = new SwingButton();
    private static final String type = "TIFF";
    private final JRadioButton xmlButton = new JRadioButton("Xml");
    private final JRadioButton dataButton = new JRadioButton("Data");
    public boolean showSaveFunction = false;
    private String xml_file = "";
    private String pdf_file = "";
    private boolean xmlSaveRequired = false;
    private boolean xmlFileChanged = false;
    private static String OutputDir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "tables";
    public int[] values = new int[5];
    public String[] key = new String[]{"page", "x1", "x2", "y1", "y2"};
    public DocumentBuilderFactory dbf;
    public DocumentBuilder db;
    public Document doc;
    public Element root;
    public Element count;
    public int coords = 0;

    public TableZoner() {
        JAIHelper.useJAI(true);
        JAIHelper.confirmJAIOnClasspath();
        this.commonValues.setContentExtractor(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " setting look and feel");
        }
        TableZoner current = new TableZoner();
        current.setupViewer();
    }

    public void setupViewer() {
        try {
            this.setupOutput();
            this.init(null);
            this.setupExtractorGUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception on initialisation");
        }
    }

    private void setupExtractorGUI() {
        this.currentGUI.first = new SwingButton();
        this.currentGUI.fback = new SwingButton();
        this.currentGUI.back = new SwingButton();
        this.currentGUI.forward = new SwingButton();
        this.currentGUI.fforward = new SwingButton();
        this.currentGUI.end = new SwingButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.xmlButton);
        group.add(this.dataButton);
        this.xmlButton.setEnabled(false);
        this.dataButton.setSelected(true);
        this.currentGUI.getTopButtonBar().add(this.xmlButton);
        this.currentGUI.getTopButtonBar().add(this.dataButton);
        ((AbstractButton)((Object)this.currentGUI.first)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fback)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.back)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.forward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fforward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.end)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.currentGUI.setViewerTitle(null);
        if (!this.thumbnails.isShownOnscreen()) {
            this.currentGUI.setPDFOutlineVisible(false);
        }
        this.mouseHandler.setupExtractor();
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.currentGUI.initStatus();
        this.createSwingMenu(false);
        this.createExtractorButtons(this.currentGUI.getTopButtonBar());
        this.currentGUI.addCursor();
    }

    private void createExtractorButtons(JToolBar currentBar1) {
        this.openButton(currentBar1);
        currentBar1.add(Box.createHorizontalGlue());
        SwingButton snapToGridButton = new SwingButton();
        snapToGridButton.init("/org/jpedal/examples/contentextractor/snapgrid.gif", -1, "Click to snap onto outlines");
        currentBar1.add(snapToGridButton);
        ((AbstractButton)snapToGridButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableZoner.this.mouseHandler.updateRectangle();
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        SwingButton snapshotButton = new SwingButton();
        snapshotButton.init("/org/jpedal/examples/simpleviewer/res/snapshot.gif", -1, "Click to extract selected rectangle");
        currentBar1.add(snapshotButton);
        ((AbstractButton)snapshotButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TableZoner.this.commonValues.getSelectedFile() != null && !TableZoner.this.commonValues.isProcessing() && TableZoner.this.currentGUI.getRectangle() != null) {
                    TableZoner.this.extractContent();
                    if (TableZoner.this.currentGUI.isPDFOutlineVisible()) {
                        TableZoner.this.createThumbnails();
                    }
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        currentBar1.add(Box.createHorizontalGlue());
        String tooltip = "Show extracted items";
        if (this.showExtractedItems) {
            tooltip = "Hide extracted items";
        }
        this.showItemsExtracted.init("/org/jpedal/examples/contentextractor/list.gif", -1, tooltip);
        this.showItemsExtracted.setVisible(false);
        currentBar1.add((AbstractButton)((Object)this.showItemsExtracted));
        ((AbstractButton)((Object)this.showItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean current = !TableZoner.this.currentGUI.isPDFOutlineVisible();
                TableZoner.this.currentGUI.setPDFOutlineVisible(current);
                TableZoner.this.showExtractedItems = !TableZoner.this.showExtractedItems;
                if (current) {
                    TableZoner.this.createThumbnails();
                } else {
                    TableZoner.this.showExtractedItems = false;
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        this.saveItemsExtracted.init("/org/jpedal/examples/simpleviewer/res/save.gif", -1, "Save extracted items");
        this.saveItemsExtracted.setVisible(false);
        currentBar1.add((AbstractButton)((Object)this.saveItemsExtracted));
        ((AbstractButton)((Object)this.saveItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean saved = TableZoner.this.saveThumbnails();
                TableZoner.this.decode_pdf.setHighlightedAreas(null);
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
    }

    private boolean saveThumbnails() {
        boolean wasSaved = false;
        if (this.xml_file.length() == 0 && this.dataButton.isSelected() || this.xmlFileChanged) {
            this.xmlSaveRequired = true;
        }
        if (!this.dataButton.isSelected() || this.xmlSaveRequired) {
            JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
            fc.setFileSelectionMode(0);
            String[] xml = new String[]{"xml"};
            fc.addChoosableFileFilter(new FileFilterer(xml, "Xml (*.xml)"));
            int returnVal = fc.showSaveDialog(fc);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String newTarget = file.getAbsolutePath();
                int result = 0;
                if (file.exists()) {
                    result = this.currentGUI.showConfirmDialog("Are you sure you wish to replace this file?", "Confirm Overwrite", 1);
                }
                if (result == 0) {
                    if (!file.getAbsoluteFile().toString().endsWith(".xml")) {
                        file = new File(String.valueOf(file.getAbsoluteFile().toString()) + ".xml");
                    }
                    try {
                        file.createNewFile();
                        String target = this.commonValues.getTarget();
                        String separator = this.commonValues.getSeparator();
                        if (target != null) {
                            File temp_files = new File(target);
                            String[] file_list = temp_files.list();
                            if (file_list != null) {
                                int ii = 0;
                                while (ii < file_list.length) {
                                    File delete_file = new File(String.valueOf(target) + separator + file_list[ii]);
                                    ObjectStore.copy(String.valueOf(target) + separator + "TablesExtracted.xml", file.getAbsolutePath());
                                    delete_file.deleteOnExit();
                                    delete_file.delete();
                                    ++ii;
                                }
                            }
                            this.xml_file = file.getAbsolutePath();
                            wasSaved = true;
                            this.xmlFileChanged = false;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.xmlSaveRequired) {
                this.xmlSaveRequired = false;
                this.saveThumbnails();
            }
        } else {
            ExtractTextTableFromZones zones = new ExtractTextTableFromZones();
            if (this.xml_file.length() != 0) {
                JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
                fc.setFileSelectionMode(1);
                int returnVal = fc.showSaveDialog(fc);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    OutputDir = file.getAbsolutePath();
                }
                String[] args = new String[]{this.pdf_file, this.xml_file, OutputDir};
                ExtractTextTableFromZones.main(args);
                JOptionPane.showMessageDialog(new JFrame(), "All Tables Extracted to :: " + OutputDir);
            } else {
                this.xmlSaveRequired = true;
                this.saveThumbnails();
            }
        }
        return wasSaved;
    }

    private void openButton(JToolBar currentBar1) {
        SwingButton open = new SwingButton();
        open.init("/org/jpedal/examples/simpleviewer/res/open.gif", -1, Messages.getMessage("PdfViewerFileMenuTooltip.open"));
        currentBar1.add(open);
        ((AbstractButton)open).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TableZoner.this.dataButton.isSelected()) {
                    TableZoner.this.xmlButton.enable();
                    TableZoner.this.commonValues.setProcessing(false);
                    boolean dataWillBeOverwritten = true;
                    if (TableZoner.this.itemSelectedCount == 1) {
                        dataWillBeOverwritten = false;
                    } else {
                        int choice = TableZoner.this.currentGUI.showConfirmDialog("ARE YOU SURE you wish to lose the currently selected items?", "Extracted Content WILL be overwritten", 0);
                        if (choice == 0) {
                            dataWillBeOverwritten = false;
                        }
                    }
                    if (!dataWillBeOverwritten) {
                        TableZoner.this.resetToEmpty(false);
                        TableZoner.this.currentGUI.setPDFOutlineVisible(false);
                        TableZoner.this.currentGUI.zoom(false);
                        TableZoner.this.currentCommands.selectFile();
                        TableZoner.this.xmlButton.setEnabled(true);
                        TableZoner.this.xmlButton.setSelected(true);
                        TableZoner.this.pdf_file = TableZoner.this.commonValues.getSelectedFile();
                    }
                } else {
                    boolean tableData = false;
                    int[] itemSelectedPage = new int[1];
                    JFileChooser chooser = new JFileChooser(TableZoner.this.commonValues.getInputDir());
                    if (TableZoner.this.commonValues.getSelectedFile() != null) {
                        chooser.setSelectedFile(new File(TableZoner.this.commonValues.getSelectedFile()));
                    }
                    chooser.setFileSelectionMode(0);
                    String[] xml = new String[]{"xml"};
                    chooser.addChoosableFileFilter(new FileFilterer(xml, "Xml (*.xml)"));
                    chooser.showOpenDialog(TableZoner.this.currentGUI.getFrame());
                    File file = chooser.getSelectedFile();
                    if (file != null && file.exists()) {
                        TableZoner.this.setupOutput();
                        String target = TableZoner.this.commonValues.getTarget();
                        if (target == null) {
                            try {
                                File tmp = File.createTempFile("jpedal", "ads");
                                File dir = new File(String.valueOf(tmp.getAbsolutePath()) + "-files");
                                dir.mkdirs();
                                dir.deleteOnExit();
                                target = dir.getAbsolutePath();
                                TableZoner.this.commonValues.setTarget(target);
                                tmp.delete();
                            }
                            catch (Exception ex) {
                                LogWriter.writeLog("[PDF] Error deleting file");
                            }
                        }
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            Document doc = factory.newDocumentBuilder().parse(file);
                            NodeList Allnodes = doc.getChildNodes();
                            NodeList nodes = doc.getElementsByTagName("TablePositions");
                            Element currentElement = (Element)nodes.item(0);
                            if (currentElement != null) {
                                NodeList catNodes = currentElement.getChildNodes();
                                List catValues = TableZoner.this.getChildValues(catNodes);
                                int size = catValues.size();
                                TableZoner.this.itemSelectedCount = 0;
                                TableZoner.this.itemSelectedX1.clear();
                                TableZoner.this.itemSelectedY1.clear();
                                TableZoner.this.itemSelectedWidth.clear();
                                TableZoner.this.itemSelectedHeight.clear();
                                int i = 0;
                                Element next = (Element)catValues.get(i);
                                String key = next.getNodeName();
                                String value = next.getAttribute("value");
                                if (key.endsWith("Count")) {
                                    TableZoner.this.itemSelectedCount = Integer.parseInt(value);
                                    itemSelectedPage = new int[TableZoner.this.itemSelectedCount];
                                }
                                int pages = 0;
                                i = 0;
                                while (i < size) {
                                    next = (Element)catValues.get(i);
                                    key = next.getNodeName();
                                    value = next.getAttribute("value");
                                    if (key.endsWith("page")) {
                                        itemSelectedPage[pages] = Integer.parseInt(value);
                                        ++pages;
                                    }
                                    if (key.endsWith("x1")) {
                                        TableZoner.this.itemSelectedX1.addElement(Integer.parseInt(value));
                                    }
                                    if (key.endsWith("y1")) {
                                        TableZoner.this.itemSelectedY1.addElement(Integer.parseInt(value));
                                    }
                                    if (key.endsWith("x2")) {
                                        TableZoner.this.itemSelectedWidth.addElement(Integer.parseInt(value));
                                    }
                                    if (key.endsWith("y2")) {
                                        TableZoner.this.itemSelectedHeight.addElement(Integer.parseInt(value));
                                    }
                                    ++i;
                                }
                                int[][] openValues = new int[TableZoner.this.itemSelectedCount][5];
                                i = 0;
                                boolean j = false;
                                int[] x1 = TableZoner.this.itemSelectedX1.get();
                                int[] x2 = TableZoner.this.itemSelectedWidth.get();
                                int[] y1 = TableZoner.this.itemSelectedY1.get();
                                int[] y2 = TableZoner.this.itemSelectedHeight.get();
                                while (i < TableZoner.this.itemSelectedCount) {
                                    openValues[i][0] = itemSelectedPage[i];
                                    openValues[i][1] = x1[i];
                                    openValues[i][2] = x2[i];
                                    openValues[i][3] = y1[i];
                                    openValues[i][4] = y2[i];
                                    TableZoner.this.values = openValues[i];
                                    BufferedImage snapShot = TableZoner.this.extractSelectedScreenAsImage();
                                    if (TableZoner.this.commonValues.getTarget() != null) {
                                        if (snapShot != null) {
                                            String name = "page_" + TableZoner.this.commonValues.getCurrentPage() + "_id_" + i + TableZoner.type;
                                            String fileLocation = String.valueOf(TableZoner.this.commonValues.getTarget()) + System.getProperty("separator") + name;
                                            JAI.create((String)"filestore", (RenderedImage)snapShot, (Object)fileLocation, (Object)TableZoner.type);
                                            TableZoner.this.imagesStored.addElement(fileLocation);
                                            TableZoner.this.imagesUsed.put(name, "x");
                                        } else {
                                            TableZoner.this.imagesStored.addElement(null);
                                            TableZoner.this.thumbnailsStored.addElement(null);
                                        }
                                    } else {
                                        TableZoner.this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
                                    }
                                    TableZoner.this.writeXML(target);
                                    ++i;
                                }
                                tableData = true;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (tableData) {
                            int i = 0;
                            int currentPage = 0;
                            currentPage = TableZoner.this.commonValues.getCurrentPage();
                            while (i < TableZoner.this.itemSelectedCount) {
                                TableZoner.this.commonValues.setCurrentPage(itemSelectedPage[i]);
                                int page = TableZoner.this.commonValues.getCurrentPage();
                                if (page == 0) {
                                    page = 1;
                                }
                                TableZoner.this.pageUsed.addElement(page);
                                ++i;
                            }
                            TableZoner.this.commonValues.setCurrentPage(currentPage);
                            TableZoner.this.showItemsExtracted.setVisible(true);
                            TableZoner.this.saveItemsExtracted.setVisible(true);
                            TableZoner tableZoner = TableZoner.this;
                            tableZoner.itemSelectedCount = tableZoner.itemSelectedCount + 1;
                            TableZoner.this.createOnscreenOutlines();
                        } else {
                            JOptionPane jop = new JOptionPane();
                            JOptionPane.showMessageDialog(new JFrame(), "This file does not contain Table Position Data.");
                        }
                        TableZoner.this.xml_file = file.getAbsolutePath();
                    } else {
                        TableZoner.this.decode_pdf.repaint();
                        TableZoner.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                    }
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
    }

    protected List getChildValues(NodeList catNodes) {
        ArrayList<Node> catValues = new ArrayList<Node>();
        int items = catNodes.getLength();
        int i = 0;
        while (i < items) {
            Node next = catNodes.item(i);
            if (next instanceof Element) {
                catValues.add(next);
            }
            ++i;
        }
        return catValues;
    }

    private void resetToEmpty(boolean saveFirst) {
        int choice;
        if (saveFirst && this.itemSelectedCount > 1 && (choice = this.currentGUI.showConfirmDialog("Do you wish to save it first?", "Extracted Content WILL be overwritten", 0)) == 0) {
            while (!this.saveThumbnails()) {
            }
        }
        this.showExtractedItems = false;
        this.showItemsExtracted.setVisible(false);
        this.saveItemsExtracted.setVisible(false);
        this.itemSelectedX1 = new Vector_Int(10);
        this.itemSelectedY1 = new Vector_Int(10);
        this.itemSelectedWidth = new Vector_Int(10);
        this.itemSelectedHeight = new Vector_Int(10);
        this.itemSelectedCount = 1;
        this.pageUsed = new Vector_Int(10);
        this.imagesStored = new Vector_String(10);
        this.imagesUsed = new HashMap();
        this.thumbnailsStored = new Vector_Object(10);
        this.textStored = new Vector_String(10);
        this.xmlStored = new Vector_String(10);
        this.currentCommands.flush();
        this.decode_pdf.removeHiglightedObject();
        this.decode_pdf.setHighlightedZones(0, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.decode_pdf.updateCursorBoxOnScreen(null, null);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        this.currentGUI.setSplitDividerLocation(0);
        this.decode_pdf.repaint();
    }

    private void extractContent() {
        BufferedImage snapShot = null;
        String xmlText = null;
        try {
            PdfGroupingAlgorithms currentGrouping = this.decode_pdf.getGroupingObject();
            int t_x1 = this.commonValues.m_x1;
            int t_x2 = this.commonValues.m_x2;
            int t_y1 = this.commonValues.m_y1;
            int t_y2 = this.commonValues.m_y2;
            if (t_y1 < t_y2) {
                t_y2 = this.commonValues.m_y1;
                t_y1 = this.commonValues.m_y2;
            }
            if (t_x1 > t_x2) {
                t_x2 = this.commonValues.m_x1;
                t_x1 = this.commonValues.m_x2;
            }
            xmlText = currentGrouping.extractTextInRectangle(t_x1 - 3, t_y1 + 3, t_x2 + 6, t_y2 - 6, this.commonValues.getCurrentPage(), false, true);
        }
        catch (PdfException e) {
            e.printStackTrace();
        }
        snapShot = this.extractSelectedScreenAsImage();
        this.popupDisplay(snapShot, xmlText, this.itemSelectedCount, true, false);
    }

    private void popupDisplay(final BufferedImage snapShot, String xmlText, final int id, final boolean calculateLocations, boolean isResave) {
        boolean isXML = true;
        PdfGroupingAlgorithms currentGrouping = null;
        try {
            currentGrouping = this.decode_pdf.getGroupingObject();
        }
        catch (PdfException e3) {
            e3.printStackTrace();
        }
        Map content = null;
        int useCSV = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerXHTML.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0);
        try {
            content = useCSV != 0 ? currentGrouping.extractTextAsTable(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2, this.commonValues.m_y2, this.commonValues.getCurrentPage(), true, false, false, false, 0, false) : currentGrouping.extractTextAsTable(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2, this.commonValues.m_y2, this.commonValues.getCurrentPage(), false, true, true, false, 1, false);
        }
        catch (PdfException e2) {
            e2.printStackTrace();
        }
        xmlText = (String)content.get("content");
        JTabbedPane display = new JTabbedPane();
        final JTextPane textPane = new JTextPane();
        final JTextPane xmlPane = new JTextPane();
        if (xmlText != null) {
            JScrollPane scroll = new JScrollPane();
            try {
                JTextPane text_pane = new JTextPane();
                scroll = this.currentGUI.createPane(text_pane, xmlText, true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(400, 400));
            final JDialog displayFrame = new JDialog((Frame)this.currentGUI.getFrame(), true);
            if (this.commonValues.getModeOfOperation() != 1) {
                JFrame frame = this.currentGUI.getFrame();
                displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
            }
            displayFrame.setSize(450, 450);
            displayFrame.setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
            displayFrame.getContentPane().setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)scroll, "Center");
            JPanel buttonBar = new JPanel();
            buttonBar.setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)buttonBar, "South");
            String message = "Extracted Content - would you like to accept?";
            if (isResave) {
                message = "Would you like to save any changes you have made to the current item?";
            }
            JButton yes = new JButton(Messages.getMessage("PdfMessage.Yes"));
            yes.setFont(new Font("SansSerif", 0, 12));
            buttonBar.add((Component)yes, "West");
            yes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String extractedtext = "";
                    String finalxmlText = "";
                    extractedtext = textPane.getText();
                    finalxmlText = xmlPane.getText();
                    TableZoner.this.values[0] = TableZoner.this.commonValues.getCurrentPage();
                    TableZoner.this.values[1] = ((TableZoner)TableZoner.this).commonValues.m_x1;
                    TableZoner.this.values[2] = ((TableZoner)TableZoner.this).commonValues.m_x2;
                    TableZoner.this.values[3] = ((TableZoner)TableZoner.this).commonValues.m_y1;
                    TableZoner.this.values[4] = ((TableZoner)TableZoner.this).commonValues.m_y2;
                    if (calculateLocations) {
                        TableZoner.this.textStored.addElement(extractedtext);
                        TableZoner.this.xmlStored.addElement(finalxmlText);
                    } else {
                        TableZoner.this.textStored.setElementAt(extractedtext, id - 1);
                        TableZoner.this.xmlStored.setElementAt(finalxmlText, id - 1);
                    }
                    TableZoner.this.saveExtractedContent(snapShot, finalxmlText, id, calculateLocations);
                    if (TableZoner.this.itemSelectedCount == 1) {
                        TableZoner.this.showItemsExtracted.setVisible(true);
                        TableZoner.this.saveItemsExtracted.setVisible(true);
                    }
                    if (calculateLocations) {
                        TableZoner tableZoner = TableZoner.this;
                        tableZoner.itemSelectedCount = tableZoner.itemSelectedCount + 1;
                        TableZoner.this.itemSelectedX1.addElement(((TableZoner)TableZoner.this).commonValues.m_x1);
                        TableZoner.this.itemSelectedWidth.addElement(((TableZoner)TableZoner.this).commonValues.m_x2);
                        TableZoner.this.itemSelectedY1.addElement(((TableZoner)TableZoner.this).commonValues.m_y1);
                        TableZoner.this.itemSelectedHeight.addElement(((TableZoner)TableZoner.this).commonValues.m_y2);
                    }
                    if (calculateLocations) {
                        TableZoner.this.createOnscreenOutlines();
                    }
                    TableZoner.this.xmlFileChanged = true;
                    displayFrame.dispose();
                }
            });
            JButton no = new JButton(Messages.getMessage("PdfMessage.No"));
            no.setFont(new Font("SansSerif", 0, 12));
            buttonBar.add((Component)no, "East");
            no.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    displayFrame.dispose();
                }
            });
            displayFrame.setVisible(true);
        }
    }

    private void createOnscreenOutlines() {
        int[] x1 = this.itemSelectedX1.get();
        int[] y1 = this.itemSelectedY1.get();
        int[] x2 = this.itemSelectedWidth.get();
        int[] y2 = this.itemSelectedHeight.get();
        int[] order = new int[this.itemSelectedCount];
        boolean[] highlightedZonesSelected = new boolean[this.itemSelectedCount];
        int[] processedByRegularExpression = new int[this.itemSelectedCount];
        Rectangle2D[] outlineZone = new Rectangle2D[this.itemSelectedCount];
        Shape[] fragmentShapes = new Shape[this.itemSelectedCount];
        Color[] fragmentColorCoding = new Color[this.itemSelectedCount];
        int[] plotNumberX = new int[this.itemSelectedCount];
        int[] plotNumberY = new int[this.itemSelectedCount];
        int i = 0;
        while (i < this.itemSelectedCount) {
            order[i] = i;
            highlightedZonesSelected[i] = true;
            outlineZone[i] = new Rectangle(x1[i], y2[i], x2[i] - x1[i], y1[i] - y2[i]);
            plotNumberX[i] = (int)((outlineZone[i].getBounds().getMinX() + outlineZone[i].getBounds().getMaxX()) / 2.0);
            plotNumberY[i] = (int)((outlineZone[i].getBounds().getMinY() + outlineZone[i].getBounds().getMaxY()) / 2.0) - 12;
            if (this.pageUsed.elementAt(i) == this.commonValues.getCurrentPage()) {
                fragmentShapes[i] = outlineZone[i];
            }
            fragmentColorCoding[i] = Color.BLUE;
            ++i;
        }
        this.currentGUI.setRectangle(null);
        this.decode_pdf.setHighlightedZones(1, plotNumberX, plotNumberY, fragmentShapes, null, null, null, null, outlineZone, highlightedZonesSelected, null, fragmentColorCoding, order, processedByRegularExpression);
        this.decode_pdf.repaint();
    }

    private void saveExtractedContent(BufferedImage snapShot, String xml, int id, boolean isSave) {
        String target = this.commonValues.getTarget();
        String separator = this.commonValues.getSeparator();
        if (target == null) {
            try {
                File tmp = File.createTempFile("jpedal", "ads");
                File dir = new File(String.valueOf(tmp.getAbsolutePath()) + "-files");
                dir.mkdirs();
                dir.deleteOnExit();
                target = dir.getAbsolutePath();
                this.commonValues.setTarget(target);
                tmp.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (target != null) {
            if (isSave) {
                if (snapShot != null) {
                    String name = "page_" + this.commonValues.getCurrentPage() + "_id" + id + '.' + type;
                    String fileLocation = String.valueOf(target) + separator + name;
                    JAI.create((String)"filestore", (RenderedImage)snapShot, (Object)fileLocation, (Object)type);
                    this.imagesStored.addElement(fileLocation);
                    this.imagesUsed.put(name, "x");
                    this.thumbnailsStored.addElement(snapShot);
                } else {
                    this.imagesStored.addElement(null);
                    this.thumbnailsStored.addElement(null);
                }
            }
        } else {
            this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
        }
        int page = this.commonValues.getCurrentPage();
        if (!isSave) {
            page = this.pageUsed.elementAt(id - 1);
        } else {
            this.pageUsed.addElement(page);
        }
        try {
            this.writeXML(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentGUI.showMessageDialog("Problem saving xml");
        }
    }

    public void setupOutput() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
            this.doc = this.db.newDocument();
            Comment creation = this.doc.createComment("Created " + TimeNow.getShortTimeNow());
            Comment version = this.doc.createComment("Extracted via JPedal");
            Comment source = this.doc.createComment("SourceFile " + this.decode_pdf.getObjectStore().getCurrentFilename());
            this.doc.appendChild(creation);
            this.doc.appendChild(version);
            this.doc.appendChild(source);
            this.root = this.doc.createElement("TablePositions");
            this.doc.appendChild(this.root);
            this.count = this.doc.createElement("Count");
            this.count.setAttribute("value", String.valueOf(this.itemSelectedCount));
            this.root.appendChild(this.count);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void writeXML(String target) throws Exception {
        try {
            int i = 0;
            this.count.setAttribute("value", String.valueOf(this.itemSelectedCount));
            while (i < this.values.length) {
                Element currentElement = this.doc.createElement("loc_" + this.coords + '_' + this.key[i]);
                currentElement.setAttribute("value", String.valueOf(this.values[i]));
                Node textNode = this.doc.importNode(currentElement, true);
                this.root.appendChild(textNode);
                ++i;
            }
            ++this.coords;
            InputStream stylesheet = this.decode_pdf.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            transformer.transform(new DOMSource(this.doc), new StreamResult(String.valueOf(target) + this.commonValues.getSeparator() + "TablesExtracted.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedImage extractSelectedScreenAsImage() {
        int t_x1 = this.commonValues.m_x1;
        int t_x2 = this.commonValues.m_x2;
        int t_y1 = this.commonValues.m_y1;
        int t_y2 = this.commonValues.m_y2;
        if (t_y1 < t_y2) {
            t_y2 = this.commonValues.m_y1;
            t_y1 = this.commonValues.m_y2;
        }
        if (t_x1 > t_x2) {
            t_x2 = this.commonValues.m_x1;
            t_x1 = this.commonValues.m_x2;
        }
        return this.decode_pdf.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, 100.0f);
    }

    private void createThumbnails() {
        this.currentGUI.initThumbnails(this.itemSelectedCount, this.pageUsed);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        Object[] buttons = this.thumbnails.getButtons();
        int i = 0;
        while (i < this.itemSelectedCount - 1) {
            JButton eachThumb = (JButton)buttons[i];
            eachThumb.addActionListener(new ButtonPopup(i));
            ++i;
        }
    }

    public class ButtonPopup
    implements ActionListener {
        int id;
        JButton[] buttons;

        public ButtonPopup(int i) {
            this.id = i;
        }

        public void actionPerformed(ActionEvent arg0) {
            TableZoner.this.thumbnails.resetHighlightedThumbnail(this.id);
            TableZoner.this.thumbnails.refreshDisplay();
            BufferedImage img = JAI.create((String)"fileload", (Object)TableZoner.this.imagesStored.elementAt(this.id)).getAsBufferedImage();
            TableZoner.this.popupDisplay(img, TableZoner.this.xmlStored.elementAt(this.id), this.id + 1, false, true);
        }
    }
}

