/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Printer {
    private static int printingThreads = 0;
    int rangeStart = 1;
    int rangeEnd = 1;
    int subset = 8;
    JComboBox scaling = null;
    boolean wasCancelled = false;
    boolean messageShown = false;
    boolean pagesReversed = false;
    Timer updatePrinterProgress = null;
    private ProgressMonitor status = null;
    private String dots = ".";

    public void printPDF(final PdfDecoder decode_pdf, final GUIFactory currentGUI) {
        ++printingThreads;
        Thread worker = new Thread(){

            public void run() {
                boolean printFile = false;
                try {
                    PrinterJob printJob = PrinterJob.getPrinterJob();
                    PageFormat pf = printJob.defaultPage();
                    if (PdfDecoder.debugPrint) {
                        System.out.println("------------------------");
                        System.out.println("Default Page format used=" + pf);
                        System.out.println("Orientation=" + pf.getOrientation());
                        System.out.println("Width=" + pf.getWidth() + " imageableW=" + pf.getImageableWidth());
                        System.out.println("Height=" + pf.getHeight() + " imageableH=" + pf.getImageableHeight());
                        System.out.println("------------------------");
                    }
                    Paper paper = new Paper();
                    paper.setSize(595.0, 842.0);
                    paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
                    pf.setPaper(paper);
                    printJob.setPageable(decode_pdf);
                    HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                    aset.add(new PageRanges(1, decode_pdf.getPageCount()));
                    decode_pdf.setPageFormat(pf);
                    printFile = printJob.printDialog(aset);
                    PageRanges r = (PageRanges)aset.get(PageRanges.class);
                    if (r != null && printFile) {
                        decode_pdf.setPagePrintRange(r);
                        int[][] values = r.getMembers();
                        int[] pages = values[0];
                        int p1 = pages[0];
                        int p2 = pages[1];
                        if (p2 == Integer.MAX_VALUE) {
                            p2 = decode_pdf.getPageCount();
                        }
                        if (p1 < p2) {
                            Printer.this.rangeStart = p1;
                            Printer.this.rangeEnd = p2;
                        } else {
                            Printer.this.rangeStart = p2;
                            Printer.this.rangeEnd = p1;
                        }
                    }
                    Printer.this.status = new ProgressMonitor(currentGUI.getFrame(), "", "", 1, 100);
                    Printer.this.updatePrinterProgress = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            int currentPage = decode_pdf.getCurrentPrintPage();
                            if (currentPage > 0) {
                                Printer.this.updatePrinterProgess(decode_pdf, currentPage);
                            }
                            if (currentPage == -1) {
                                (this).Printer.this.updatePrinterProgress.stop();
                                Printer.this.status.close();
                            }
                        }
                    });
                    Printer.this.updatePrinterProgress.setRepeats(true);
                    Printer.this.updatePrinterProgress.start();
                    if (printFile) {
                        printJob.print();
                    }
                }
                catch (PrinterException ee) {
                    ee.printStackTrace();
                    LogWriter.writeLog("Exception " + ee + " printing");
                    currentGUI.showMessageDialog(String.valueOf(ee.getMessage()) + ' ' + ee + ' ' + ' ' + ee.getCause());
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception " + e + " printing");
                    e.printStackTrace();
                    currentGUI.showMessageDialog("Exception " + e);
                }
                catch (Error err) {
                    err.printStackTrace();
                    LogWriter.writeLog("Error " + err + " printing");
                    currentGUI.showMessageDialog("Error " + err);
                }
                if (Printer.this.updatePrinterProgress != null) {
                    Printer.this.updatePrinterProgress.stop();
                    Printer.this.status.close();
                }
                if (!printFile && !decode_pdf.isPageSuccessful()) {
                    String errorMessage = String.valueOf(Messages.getMessage("PdfViewerError.ProblemsEncountered")) + decode_pdf.getPageFailureMessage() + '\n';
                    if (decode_pdf.getPageFailureMessage().toLowerCase().indexOf("memory") != -1) {
                        errorMessage = String.valueOf(errorMessage) + Messages.getMessage("PdfViewerError.RerunJava") + Messages.getMessage("PdfViewerError.RerunJava1") + Messages.getMessage("PdfViewerError.RerunJava2");
                    }
                    currentGUI.showMessageDialog(errorMessage);
                }
                printingThreads = printingThreads - 1;
                decode_pdf.invalidate();
                decode_pdf.updateUI();
                decode_pdf.repaint();
                if (printFile && !Printer.this.wasCancelled) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintingFinished"));
                    decode_pdf.resetCurrentPrintPage();
                }
            }

            private String[] getAvailablePrinters() {
                PrintService[] service = PrinterJob.lookupPrintServices();
                int noOfPrinters = service.length;
                String[] serviceNames = new String[noOfPrinters];
                int i = 0;
                while (i < noOfPrinters) {
                    serviceNames[i] = service[i].getName();
                    ++i;
                }
                return serviceNames;
            }
        };
        worker.start();
    }

    private void updatePrinterProgess(PdfDecoder decode_pdf, int currentPage) {
        boolean isBackwards;
        int noOfPagesPrinting = this.rangeEnd - this.rangeStart + 1;
        int currentPrintingPage = currentPage - this.rangeStart;
        int actualCount = noOfPagesPrinting;
        int actualPage = currentPrintingPage;
        int actualPercentage = (int)((float)actualPage / (float)actualCount * 100.0f);
        if (this.status.isCanceled()) {
            decode_pdf.stopPrinting();
            this.updatePrinterProgress.stop();
            this.status.close();
            this.wasCancelled = true;
            --printingThreads;
            if (!this.messageShown) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewerPrint.PrintingCanceled"));
                this.messageShown = true;
            }
            return;
        }
        this.dots = String.valueOf(this.dots) + '.';
        if (this.dots.length() > 8) {
            this.dots = ".";
        }
        boolean bl = isBackwards = currentPrintingPage <= 0;
        if (this.rangeStart == this.rangeEnd) {
            isBackwards = false;
        }
        if (isBackwards) {
            noOfPagesPrinting = this.rangeStart - this.rangeEnd + 1;
        }
        int percentage = (int)((float)currentPrintingPage / (float)noOfPagesPrinting * 100.0f);
        if (!isBackwards && percentage < 1) {
            percentage = 1;
        }
        if (isBackwards) {
            percentage = -percentage;
            currentPrintingPage = -currentPrintingPage;
        }
        if (this.pagesReversed) {
            percentage = 100 - percentage;
        }
        this.status.setProgress(percentage);
        String message = "";
        if (this.subset == 16) {
            actualCount = actualCount / 2 + 1;
            actualPage /= 2;
        } else if (this.subset == 32) {
            actualCount = actualCount / 2 + 1;
            actualPage /= 2;
        }
        if (actualCount == 1) {
            actualPercentage = 50;
            actualPage = 1;
            this.status.setProgress(actualPercentage);
        }
        message = String.valueOf(actualPage) + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + actualCount + ": " + actualPercentage + '%' + ' ' + this.dots;
        if (this.pagesReversed) {
            message = String.valueOf(actualCount - actualPage) + " " + Messages.getMessage("PdfViewerPrint.Of") + ' ' + actualCount + ": " + percentage + '%' + ' ' + this.dots;
            this.status.setNote(String.valueOf(Messages.getMessage("PdfViewerPrint.ReversedPrinting")) + ' ' + message);
        } else if (isBackwards) {
            this.status.setNote(String.valueOf(Messages.getMessage("PdfViewerPrint.ReversedPrinting")) + ' ' + message);
        } else {
            this.status.setNote(String.valueOf(Messages.getMessage("PdfViewerPrint.Printing")) + ' ' + message);
        }
    }

    public boolean isPrinting() {
        return printingThreads > 0;
    }

    private void setPrinter(PrinterJob printJob, String chosenPrinter) throws PrinterException, PdfException {
        PrintService[] service = PrinterJob.lookupPrintServices();
        boolean matchFound = false;
        int count = service.length;
        int i = 0;
        while (i < count) {
            if (service[i].getName().equals(chosenPrinter)) {
                printJob.setPrintService(service[i]);
                i = count;
                matchFound = true;
            }
            ++i;
        }
        if (!matchFound) {
            throw new PdfException("Unknown printer " + chosenPrinter);
        }
    }
}

