/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwingOutline
extends JScrollPane
implements GUIOutline {
    private boolean ignoreAlteredBookmark = false;
    private HashMap pageLookupTable = new HashMap();
    private Map pointLookupTable = new HashMap();
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;

    public SwingOutline() {
        this.getViewport().add(new JLabel("No outline"));
    }

    public void reset(Node rootNode) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        if (rootNode != null) {
            this.readChildNodes(rootNode, this.top);
        }
        this.tree = new JTree(this.top);
        if (rootNode != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void walk(TreeModel model, Object o, int currentPage) {
        int cc = model.getChildCount(o);
        int i = 0;
        while (i < cc) {
            Object child = model.getChild(o, i);
            if (model.isLeaf(child)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)child;
                String title = (String)node.getUserObject();
                String page = (String)this.pageLookupTable.get(title);
                if (page.length() > 0) {
                    try {
                        if (Integer.parseInt(page) == currentPage) {
                            this.ignoreAlteredBookmark = true;
                            this.tree.setSelectionPath(new TreePath(node.getPath()));
                            this.ignoreAlteredBookmark = false;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("bad page number: " + page);
                        this.ignoreAlteredBookmark = false;
                    }
                }
            } else {
                this.walk(model, child, currentPage);
            }
            ++i;
        }
    }

    private void traverse(int currentPage) {
        TreeModel model = this.tree.getModel();
        if (model != null) {
            this.walk(model, model.getRoot(), currentPage);
        }
    }

    private void createLookupTable(TreeModel model, Object o, int currentPage) {
        int cc = model.getChildCount(o);
        int i = 0;
        while (i < cc) {
            Object child = model.getChild(o, i);
            if (model.isLeaf(child)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)child;
                String title = (String)node.getUserObject();
                String page = (String)this.pageLookupTable.get(title);
                try {
                    if (Integer.parseInt(page) == currentPage) {
                        this.tree.setSelectionPath(new TreePath(node.getPath()));
                    }
                }
                catch (NumberFormatException nfe) {
                    System.out.println("bad page number: " + page);
                }
            } else {
                this.walk(model, child, currentPage);
            }
            ++i;
        }
    }

    private void expandAll() {
        int row = 0;
        while (row < this.tree.getRowCount()) {
            this.tree.expandRow(row);
            ++row;
        }
    }

    public void readChildNodes(Node rootNode, DefaultMutableTreeNode topNode) {
        if (topNode == null) {
            topNode = this.top;
        }
        NodeList children = rootNode.getChildNodes();
        int childCount = children.getLength();
        int i = 0;
        while (i < childCount) {
            Node child = children.item(i);
            Element currentElement = (Element)child;
            String title = currentElement.getAttribute("title");
            String page = currentElement.getAttribute("page");
            String rawDest = currentElement.getAttribute("Dest");
            this.pageLookupTable.put(title, page);
            if (rawDest != null && rawDest.indexOf("/XYZ") != -1) {
                String y;
                StringTokenizer values = new StringTokenizer(rawDest = rawDest.substring(rawDest.indexOf("/XYZ") + 4), "[] ");
                String x = values.nextToken();
                if (x.equals("null")) {
                    x = "0";
                }
                if ((y = values.nextToken()).equals("null")) {
                    y = "0";
                }
                this.pointLookupTable.put(title, new Point((int)Float.parseFloat(x), (int)Float.parseFloat(y)));
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(title);
            topNode.add(childNode);
            if (child.hasChildNodes()) {
                this.readChildNodes(child, childNode);
            }
            ++i;
        }
    }

    public boolean isIgnoreAlteredBookmark() {
        return this.ignoreAlteredBookmark;
    }

    public String getPage(String title) {
        return (String)this.pageLookupTable.get(title);
    }

    public void selectBookmark() {
    }

    public Point getPoint(String title) {
        return (Point)this.pointLookupTable.get(title);
    }

    public Object getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

