/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.Messages;

public class GUI {
    public GUIButton first;
    public GUIButton fback;
    public GUIButton back;
    public GUIButton forward;
    public GUIButton fforward;
    public GUIButton end;
    public GUIButton singleButton;
    public GUIButton continuousButton;
    public GUIButton continuousFacingButton;
    public GUIButton facingButton;
    private final String[] annotTypes = new String[]{"Other", "Text", "FileAttachment"};
    private final Color[] annotColors = new Color[]{Color.RED, Color.BLUE, Color.BLUE};
    private int dpi = 96;
    protected PdfDecoder decode_pdf;
    protected static final int thumbLocation = 200;
    protected static final int minimumScreenWidth = 700;
    protected HashMap pagesDecoded = new HashMap();
    protected GUIButton snapshotButton;
    private Rectangle currentRectangle = null;
    public int cropX;
    public int cropW;
    public int cropH;
    protected int mediaX;
    protected int mediaY;
    public int mediaW;
    public int cropY;
    public int mediaH;
    protected boolean hasOutlinesDrawn = false;
    protected GUIOutline tree = new SwingOutline();
    private boolean allowScrolling = true;
    private int pageLayout = 57;
    protected int divLocation = 170;
    protected boolean showOutlines = true;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static final int inset = 25;
    protected int rotation = 0;
    protected final String[] rotationValues = new String[]{"0", "90", "180", "270"};
    protected GUICombo rotationBox;
    protected GUICombo scalingBox;
    protected static final int defaultSelection = 0;
    protected String titleMessage = null;
    protected Values commonValues;
    protected GUIThumbnailPanel thumbnails;
    protected PropertiesFile properties;

    public void setPreferences(int dpi, int search, int border, boolean scroll, int pageMode) {
        PdfDecoder.CURRENT_BORDER_STYLE = border;
        this.properties.setValue("borderType", String.valueOf(border));
        this.allowScrolling = scroll;
        this.properties.setValue("autoScroll", String.valueOf(scroll));
        this.dpi = dpi;
        this.properties.setValue("DPI", String.valueOf(dpi));
        this.pageLayout = pageMode;
        this.properties.setValue("pageMode", String.valueOf(pageMode));
        this.decode_pdf.repaint();
        if (!this.properties.getValue("searchWindowType").equals(String.valueOf(search))) {
            JOptionPane.showMessageDialog(null, Messages.getMessage("PageLayoutViewMenu.ResetSearch"));
        }
        this.properties.setValue("searchWindowType", String.valueOf(search));
    }

    public float convertToCorrectedScaling(float rawScaling) {
        return rawScaling * (float)(this.dpi / 72);
    }

    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    public String[] getAnnotTypes() {
        return this.annotTypes;
    }

    public void setNoPagesDecoded() {
        this.pagesDecoded.clear();
    }

    public void setScalingToDefault() {
        this.scaling = PdfDecoder.isRunningOnWindows ? 1.53f : 1.0f;
        this.scalingBox.setSelectedIndex(0);
    }

    public void setRectangle(Rectangle newRect) {
        this.currentRectangle = newRect;
    }

    public Rectangle getRectangle() {
        return this.currentRectangle;
    }

    public void setAutoScrolling(boolean allowScrolling) {
        this.allowScrolling = allowScrolling;
    }

    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setScaling(float s) {
        this.scaling = s;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public int getPDFDisplayInset() {
        return 25;
    }

    public void createUniqueAnnotationIcons() {
        int p = this.commonValues.getCurrentPage();
        PdfAnnots annotsData = this.decode_pdf.getPdfAnnotsData(null);
        int size = 16;
        if (annotsData != null) {
            int max = annotsData.getAnnotCount();
            int j = 0;
            while (j < this.annotTypes.length) {
                int iconsForPage = 0;
                int i = 0;
                while (i < max) {
                    if (annotsData.getAnnotSubType(i).equals(this.annotTypes[j])) {
                        ++iconsForPage;
                    }
                    ++i;
                }
                Image[] annotIcons = new Image[iconsForPage];
                int i2 = 0;
                while (i2 < iconsForPage) {
                    annotIcons[i2] = new BufferedImage(16, 16, 2);
                    Graphics2D g2 = (Graphics2D)annotIcons[i2].getGraphics();
                    g2.setColor(this.annotColors[j]);
                    g2.fill(new Rectangle(0, 0, 16, 16));
                    g2.setColor(Color.BLACK);
                    g2.draw(new Rectangle(0, 0, 15, 15));
                    g2.setColor(Color.white);
                    g2.drawString(String.valueOf(i2 + 1) + " ", 2, 12);
                    ++i2;
                }
                if (iconsForPage > 0) {
                    this.decode_pdf.addUserIconsForAnnotations(p, this.annotTypes[j], annotIcons);
                }
                ++j;
            }
        }
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }
}

