/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.DefaultTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.Preferences;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseHandler;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class SimpleViewer {
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected final PdfDecoder decode_pdf = new PdfDecoder(true);
    protected GUIThumbnailPanel thumbnails = new SwingThumbnailPanel(this.commonValues, this.decode_pdf);
    private PropertiesFile properties = new PropertiesFile();
    public SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
    private GUISearchWindow searchFrame = new SwingSearchWindow(this.commonValues, this.currentGUI, this.decode_pdf);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
    protected GUIMouseHandler mouseHandler = new SwingMouseHandler(this.decode_pdf, this.currentGUI, this.commonValues, this.currentCommands);
    protected String[] scalingValues;
    final Preferences p = new Preferences();

    public void setupViewer(String defaultFile) {
        this.setupViewer();
        this.openDefaultFile(defaultFile);
    }

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    private void openDefaultFile(String defaultFile) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(String.valueOf(defaultFile) + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(String.valueOf(defaultFile) + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(defaultFile);
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                String page = System.getProperty("org.jpedal.page");
                String bookmark = System.getProperty("org.jpedal.bookmark");
                if (page != null) {
                    try {
                        int pageNum = Integer.parseInt(page);
                        if (pageNum < 1) {
                            pageNum = -1;
                            System.err.println(String.valueOf(page) + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(String.valueOf(page) + " must be 1 or larger. Opening on page 1");
                        }
                        if (pageNum != -1) {
                            this.openFile(testExists, pageNum);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(String.valueOf(page) + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(String.valueOf(page) + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (bookmark != null) {
                    this.openFile(testExists, bookmark);
                } else {
                    this.currentCommands.openFile(defaultFile);
                }
            }
        }
    }

    public SimpleViewer() {
        PdfDecoder.showErrorMessages = true;
    }

    public SimpleViewer(int modeOfOperation) {
        PdfDecoder.showErrorMessages = true;
        this.commonValues.setModeOfOperation(modeOfOperation);
    }

    public void setupViewer() {
        String setThumbnail;
        String DPI;
        String searchWindowStyle = this.properties.getValue("searchWindowType");
        if (searchWindowStyle != null) {
            int value = Integer.parseInt(searchWindowStyle);
            this.searchFrame.setStyle(value);
            this.p.setSearchStyleDefaultValue(value);
        }
        this.currentGUI.setSearchFrame(this.searchFrame);
        String borderStyle = this.properties.getValue("borderType");
        if (borderStyle != null) {
            int bValue = Integer.parseInt(borderStyle);
            this.decode_pdf.setBorderStyle(bValue);
            this.p.setBorderDefaultValue(bValue);
        }
        if ((DPI = this.properties.getValue("DPI")) != null) {
            int cValue = Integer.parseInt(DPI);
            this.currentGUI.setDpi(cValue);
            this.p.setDpiDefaultValue(DPI);
        }
        String autoScroll = this.properties.getValue("autoScroll");
        boolean autoS = false;
        if (autoScroll != null) {
            if (autoScroll.equals("true")) {
                autoS = true;
            }
            this.currentGUI.setAutoScrolling(autoS);
            this.p.setAutoScrollDefaultValue(autoS);
        }
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_TABBED_PANE) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        if ((setThumbnail = System.getProperty("org.jpedal.thumbnail")) != null) {
            if (setThumbnail.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (setThumbnail.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        this.init(null);
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.setupButtonsAndMenus();
        this.mouseHandler.setupMouse();
        this.decode_pdf.setMessageFrame(this.currentGUI.getFrame());
        boolean showFirstTimePopup = this.properties.getValue("showfirsttimepopup").equals("true");
        if (showFirstTimePopup) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        if (JAIHelper.isJAIused() && this.properties != null && this.properties.getValue("showddmessage").equals("true")) {
            JOptionPane.showMessageDialog(this.decode_pdf, String.valueOf(Messages.getMessage("PdfViewer.JAIWarning")) + Messages.getMessage("PdfViewer.JAIWarning1") + Messages.getMessage("PdfViewer.JAIWarning2") + Messages.getMessage("PdfViewer.JAIWarning3") + Messages.getMessage("PdfViewer.JAIWarning4"));
            this.properties.setValue("showddmessage", "false");
        }
        if (!this.commonValues.isContentExtractor()) {
            boolean showItextMessage = this.properties.getValue("showitextmessage").equals("true");
            if (!this.commonValues.isItextOnClasspath() && showItextMessage) {
                this.currentGUI.showItextPopup();
                this.properties.setValue("showitextmessage", "false");
            }
        }
        this.searchFrame.setStyle(SwingSearchWindow.SEARCH_EXTERNAL_WINDOW);
        String searchType = this.properties.getValue("searchWindowType");
        if (searchType != null && searchType.length() != 0) {
            int type = Integer.parseInt(searchType);
            this.searchFrame.setStyle(type);
        }
        DefaultTransferHandler dth = new DefaultTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
        this.decode_pdf.setTransferHandler(dth);
    }

    /*
     * Unable to fully structure code
     */
    protected void init(ResourceBundle bundle) {
        block9: {
            if (bundle == null) {
                try {
                    Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
                }
                catch (Exception e) {
                    System.out.println("Exception loading resource bundle");
                }
            } else {
                Messages.setBundle(bundle);
            }
            this.scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
            if (this.commonValues.isContentExtractor()) {
                this.decode_pdf.setDisplayView(1, 1);
            } else {
                this.decode_pdf.setDisplayView(1, 2);
            }
            this.decode_pdf.addExternalHandler(this.currentGUI, 4);
            this.decode_pdf.init(true);
            this.decode_pdf.createPageHostspots(this.currentGUI.getAnnotTypes(), "org/jpedal/examples/simpleviewer/annots/");
            this.decode_pdf.setExtractionMode(0, 72, 1.0f);
            try {
                this.decode_pdf.setDefaultDisplayFont("SansSerif");
                break block9;
            }
            catch (PdfFontException e) {
                System.out.println(e.getMessage());
                fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                System.out.println(Messages.getMessage("PdfViewerFontsFound.message"));
                System.out.println("=====================\n");
                count = fontList.length;
                i = 0;
                ** while (i < count)
            }
lbl-1000:
            // 1 sources

            {
                f = new Font(fontList[i], 1, 10);
                System.out.println(String.valueOf(fontList[i]) + " (" + Messages.getMessage("PdfViewerFontsPostscript.message") + '=' + f.getPSName() + ')');
                ++i;
                continue;
            }
lbl33:
            // 1 sources

            System.exit(1);
        }
        aliases1 = new String[]{"helvetica", "arial"};
        this.decode_pdf.setSubstitutedFontAliases("arial", aliases1);
        aliases2 = new String[]{"Helvetica-Bold"};
        this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", aliases2);
        aliases3 = new String[]{"Times-Bold", "Times-Roman"};
        this.decode_pdf.setSubstitutedFontAliases("timesbd", aliases3);
        PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
    }

    private void setupButtonsAndMenus() {
        this.createSwingMenu(true);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.createButtons();
        this.currentGUI.addCursor();
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR) {
            this.currentGUI.searchInMenu(this.searchFrame);
        }
        this.currentGUI.initStatus();
    }

    private void createButtons() {
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "/org/jpedal/examples/simpleviewer/res/open.gif", 10);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "/org/jpedal/examples/simpleviewer/res/print.gif", 6);
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_EXTERNAL_WINDOW) {
            this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "/org/jpedal/examples/simpleviewer/res/find.gif", 12);
        }
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "/org/jpedal/examples/simpleviewer/res/properties.gif", 9);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), "/org/jpedal/examples/simpleviewer/res/about.gif", 1);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "/org/jpedal/examples/simpleviewer/res/snapshotX.gif", 13);
    }

    protected void createSwingMenu(boolean includeAll) {
        JMenu fileMenuList = new JMenu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.currentGUI.addToMainMenu(fileMenuList);
        JMenu view = new JMenu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.currentGUI.addToMainMenu(view);
        JMenu goTo = new JMenu(Messages.getMessage("GoToViewMenuGoto.text"));
        view.add(goTo);
        this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        goTo.addSeparator();
        if (includeAll) {
            this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
            this.currentGUI.addMenuItem(goTo, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
            JMenu export = new JMenu(Messages.getMessage("PdfViewerExportMenu.text"));
            this.currentGUI.addToMainMenu(export);
            if (this.commonValues.isItextOnClasspath()) {
                JMenu pdf = new JMenu(Messages.getMessage("PdfViewerExportMenuPDF.text"));
                export.add(pdf);
                this.currentGUI.addMenuItem(pdf, Messages.getMessage("PdfViewerExportMenuOnePerPage.text"), "", 501);
                this.currentGUI.addMenuItem(pdf, Messages.getMessage("PdfViewerExportMenuNUp.text"), "", 510);
                JMenu pageTools = new JMenu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
                this.currentGUI.addToMainMenu(pageTools);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
                this.currentGUI.addMenuItem(pageTools, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
            }
            this.currentGUI.addMenuItem(export, "Bitmap", Messages.getMessage("PdfViewerExportMenuBitmap.text"), 2);
            JMenu content = new JMenu(Messages.getMessage("PdfViewerExportMenuContent.text"));
            export.add(content);
            this.currentGUI.addMenuItem(content, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
            this.currentGUI.addMenuItem(content, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
            JMenuItem preferences = new JMenuItem(Messages.getMessage("PageLayoutViewMenu.Preferences"));
            view.add(preferences);
            this.p.createPreferanceWindow(this.currentGUI);
            preferences.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    SimpleViewer.this.p.showPreferanceWindow();
                }
            });
            view.addSeparator();
        }
        this.currentGUI.addMenuItem(view, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 61);
        if (includeAll) {
            JMenu Open = new JMenu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
            fileMenuList.add(Open);
            this.currentGUI.addMenuItem(Open, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
            this.currentGUI.addMenuItem(Open, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
            fileMenuList.addSeparator();
        }
        if (includeAll) {
            this.currentGUI.addMenuItem(fileMenuList, "Find", "Search PDF file ..", 12);
        }
        if (includeAll) {
            this.currentGUI.addMenuItem(fileMenuList, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        }
        if (includeAll && this.commonValues.isItextOnClasspath()) {
            this.currentGUI.addMenuItem(fileMenuList, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        fileMenuList.addSeparator();
        this.currentGUI.addMenuItem(fileMenuList, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        fileMenuList.addSeparator();
        if (includeAll) {
            this.currentGUI.addMenuItem(fileMenuList, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
            fileMenuList.addSeparator();
        }
        if (includeAll) {
            this.currentCommands.recentDocumentsOption(fileMenuList);
        }
        fileMenuList.addSeparator();
        this.currentGUI.addMenuItem(fileMenuList, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        if (includeAll) {
            JMenu help = new JMenu(Messages.getMessage("PdfViewerHelpMenu.text"));
            this.currentGUI.addToMainMenu(help);
            this.currentGUI.addMenuItem(help, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
            this.currentGUI.addMenuItem(help, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " setting look and feel");
        }
        SimpleViewer current = new SimpleViewer();
        if (args.length > 0) {
            current.setupViewer(args[0]);
        } else {
            current.setupViewer();
        }
    }

    private void openFile(File file, String bookmark) {
        try {
            boolean fileCanBeOpened = this.currentCommands.openUpFile(file.getCanonicalPath());
            Node rootNode = this.decode_pdf.getOutlineAsXML().getFirstChild();
            String bookmarkPage = null;
            if (rootNode != null) {
                bookmarkPage = this.currentGUI.getBookmark(bookmark);
            }
            if (bookmarkPage == null) {
                throw new PdfException("Unknown bookmark " + bookmark);
            }
            int page = Integer.parseInt(bookmarkPage);
            this.commonValues.setCurrentPage(page);
            if (fileCanBeOpened) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            this.commonValues.setProcessing(false);
        }
    }

    private void openFile(File file, int page) {
        try {
            boolean fileCanBeOpened = this.currentCommands.openUpFile(file.getCanonicalPath());
            this.commonValues.setCurrentPage(page);
            if (fileCanBeOpened) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            this.commonValues.setProcessing(false);
        }
    }
}

