/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.jpaneldemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;

public class JPanelDemo
extends JFrame {
    private String viewerTitle = "Jpanel Demo";
    private PdfDecoder pdfDecoder;
    private String currentFile = null;
    private int currentPage = 1;
    private final JLabel pageCounter1 = new JLabel("Page ");
    private JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3 = new JLabel("of");

    public JPanelDemo(String name) {
        this.pdfDecoder = new PdfDecoder();
        this.currentFile = name;
        try {
            this.pdfDecoder.openPdfFile(this.currentFile);
            this.pdfDecoder.decodePage(this.currentPage);
            this.pdfDecoder.setPageParameters(1.0f, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializeViewer();
        this.pageCounter2.setText(String.valueOf(this.currentPage));
        this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
    }

    public JPanelDemo() {
        this.setTitle(this.viewerTitle);
        this.pdfDecoder = new PdfDecoder();
        this.initializeViewer();
    }

    private void selectFile() {
        JFileChooser open = new JFileChooser(".");
        open.setFileSelectionMode(0);
        String[] pdf = new String[]{"pdf"};
        open.addChoosableFileFilter(new FileFilterer(pdf, "Pdf (*.pdf)"));
        int resultOfFileSelect = -1;
        while (resultOfFileSelect == -1) {
            resultOfFileSelect = open.showOpenDialog(this);
            if (resultOfFileSelect == -1) {
                System.err.println("JFileChooser error");
            }
            if (resultOfFileSelect != 0) continue;
            this.currentFile = open.getSelectedFile().getAbsolutePath();
            this.currentPage = 1;
            try {
                this.pdfDecoder.closePdfFile();
                this.pdfDecoder.openPdfFile(this.currentFile);
                if (!this.checkEncryption()) {
                    resultOfFileSelect = 1;
                }
                this.pdfDecoder.decodePage(this.currentPage);
                this.pdfDecoder.setPageParameters(1.0f, 1);
                this.pdfDecoder.invalidate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pageCounter2.setText(String.valueOf(this.currentPage));
            this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
            this.setTitle(String.valueOf(this.viewerTitle) + " - " + this.currentFile);
            this.repaint();
        }
    }

    private boolean checkEncryption() {
        if (this.pdfDecoder.isEncrypted()) {
            while (!this.pdfDecoder.isFileViewable()) {
                String password = JOptionPane.showInputDialog(this, (Object)"Please enter password");
                if (password == null) continue;
                try {
                    this.pdfDecoder.setEncryptionPassword(password);
                }
                catch (PdfException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return true;
    }

    private void initializeViewer() {
        this.setDefaultCloseOperation(3);
        Container cPane = this.getContentPane();
        cPane.setLayout(new BorderLayout());
        JButton open = this.initOpenBut();
        Component[] itemsToAdd = this.initChangerPanel();
        JPanel topBar = new JPanel();
        topBar.setLayout(new FlowLayout(3, 0, 0));
        topBar.add(open);
        int i = 0;
        while (i < itemsToAdd.length) {
            topBar.add(itemsToAdd[i]);
            ++i;
        }
        cPane.add((Component)topBar, "North");
        JScrollPane display = this.initPDFDisplay();
        cPane.add((Component)display, "Center");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screen.width / 2, screen.height / 2);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JButton initOpenBut() {
        JButton open = new JButton();
        open.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/open.gif")));
        open.setText("Open");
        open.setToolTipText("Open a file");
        open.setBorderPainted(false);
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanelDemo.this.selectFile();
            }
        });
        return open;
    }

    private JScrollPane initPDFDisplay() {
        JScrollPane currentScroll = new JScrollPane();
        currentScroll.setHorizontalScrollBarPolicy(30);
        currentScroll.setVerticalScrollBarPolicy(20);
        currentScroll.setViewportView(this.pdfDecoder);
        return currentScroll;
    }

    private Component[] initChangerPanel() {
        Component[] list = new Component[11];
        JButton start = new JButton();
        start.setBorderPainted(false);
        URL startImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/start.gif");
        start.setIcon(new ImageIcon(startImage));
        start.setToolTipText("Rewind to page 1");
        list[0] = start;
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage != 1) {
                    JPanelDemo.this.currentPage = 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back to page 1");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton fback = new JButton();
        fback.setBorderPainted(false);
        URL fbackImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fback.gif");
        fback.setIcon(new ImageIcon(fbackImage));
        fback.setToolTipText("Rewind 10 pages");
        list[1] = fback;
        fback.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 10) {
                    JPanelDemo jPanelDemo = JPanelDemo.this;
                    jPanelDemo.currentPage = jPanelDemo.currentPage - 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 10 pages");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton back = new JButton();
        back.setBorderPainted(false);
        URL backImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/back.gif");
        back.setIcon(new ImageIcon(backImage));
        back.setToolTipText("Rewind one page");
        list[2] = back;
        back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 1) {
                    JPanelDemo jPanelDemo = JPanelDemo.this;
                    jPanelDemo.currentPage = jPanelDemo.currentPage - 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 1 page");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        this.pageCounter2.setEditable(true);
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                String value = JPanelDemo.this.pageCounter2.getText().trim();
                try {
                    int newPage = Integer.parseInt(value);
                    if (newPage > JPanelDemo.this.pdfDecoder.getPageCount() | newPage < 1) {
                        return;
                    }
                    JPanelDemo.this.currentPage = newPage;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e) {
                        System.err.println("page number entered");
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, String.valueOf('>') + value + "< is Not a valid Value.\nPlease enter a number between 1 and " + JPanelDemo.this.pdfDecoder.getPageCount());
                }
            }
        });
        list[3] = this.pageCounter1;
        list[4] = new JPanel();
        list[5] = this.pageCounter2;
        list[6] = new JPanel();
        list[7] = this.pageCounter3;
        JButton forward = new JButton();
        forward.setBorderPainted(false);
        URL fowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/forward.gif");
        forward.setIcon(new ImageIcon(fowardImage));
        forward.setToolTipText("forward 1 page");
        list[8] = forward;
        forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo jPanelDemo = JPanelDemo.this;
                    jPanelDemo.currentPage = jPanelDemo.currentPage + 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 1 page");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton fforward = new JButton();
        fforward.setBorderPainted(false);
        URL ffowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fforward.gif");
        fforward.setIcon(new ImageIcon(ffowardImage));
        fforward.setToolTipText("Fast forward 10 pages");
        list[9] = fforward;
        fforward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount() - 9) {
                    JPanelDemo jPanelDemo = JPanelDemo.this;
                    jPanelDemo.currentPage = jPanelDemo.currentPage + 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 10 pages");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton end = new JButton();
        end.setBorderPainted(false);
        URL endImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/end.gif");
        end.setIcon(new ImageIcon(endImage));
        end.setToolTipText("Fast forward to last page");
        list[10] = end;
        end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo.this.currentPage = JPanelDemo.this.pdfDecoder.getPageCount();
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward to last page");
                        e1.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        return list;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            JPanelDemo current = new JPanelDemo(args[0]);
        } else {
            JPanelDemo current = new JPanelDemo();
        }
    }
}

