/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.contentextractor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.TimeNow;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentExtractor
extends SimpleViewer {
    private Vector_Int itemSelectedX1 = new Vector_Int(10);
    private Vector_Int itemSelectedY1 = new Vector_Int(10);
    private Vector_Int itemSelectedWidth = new Vector_Int(10);
    private Vector_Int itemSelectedHeight = new Vector_Int(10);
    private Vector_Int pageUsed = new Vector_Int(10);
    private Vector_String imagesStored = new Vector_String(10);
    Vector_Object thumbnailsStored = new Vector_Object(10);
    private Map imagesUsed = new HashMap();
    private Vector_String textStored = new Vector_String(10);
    private Vector_String xmlStored = new Vector_String(10);
    private int itemSelectedCount = 1;
    private boolean showExtractedItems;
    GUIButton showItemsExtracted = new SwingButton();
    GUIButton saveItemsExtracted = new SwingButton();
    private static final String type = "TIFF";

    public ContentExtractor() {
        JAIHelper.useJAI(false);
        JAIHelper.confirmJAIOnClasspath();
        this.commonValues.setContentExtractor(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " setting look and feel");
        }
        ContentExtractor current = new ContentExtractor();
        current.setupViewer();
    }

    public void setupViewer() {
        try {
            this.init(null);
            this.setupExtractorGUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception on initialisation");
        }
    }

    private void setupExtractorGUI() {
        this.currentGUI.first = new SwingButton();
        this.currentGUI.fback = new SwingButton();
        this.currentGUI.back = new SwingButton();
        this.currentGUI.forward = new SwingButton();
        this.currentGUI.fforward = new SwingButton();
        this.currentGUI.end = new SwingButton();
        ((AbstractButton)((Object)this.currentGUI.first)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fback)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.back)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.forward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fforward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.end)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.currentGUI.setViewerTitle(null);
        if (!this.thumbnails.isShownOnscreen()) {
            this.currentGUI.setPDFOutlineVisible(false);
        }
        this.mouseHandler.setupExtractor();
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.currentGUI.initStatus();
        this.createSwingMenu(false);
        this.createExtractorButtons(this.currentGUI.getTopButtonBar());
        this.currentGUI.addCursor();
    }

    private void createExtractorButtons(JToolBar currentBar1) {
        this.openButton(currentBar1);
        currentBar1.add(Box.createHorizontalGlue());
        SwingButton snapToGridButton = new SwingButton();
        snapToGridButton.init("/org/jpedal/examples/contentextractor/snapgrid.gif", -1, "Click to snap onto outlines");
        currentBar1.add(snapToGridButton);
        ((AbstractButton)snapToGridButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.mouseHandler.updateRectangle();
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        SwingButton snapshotButton = new SwingButton();
        snapshotButton.init("/org/jpedal/examples/simpleviewer/res/snapshot.gif", -1, "Click to extract selected rectangle");
        currentBar1.add(snapshotButton);
        ((AbstractButton)snapshotButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ContentExtractor.this.commonValues.getSelectedFile() != null && !ContentExtractor.this.commonValues.isProcessing() && ContentExtractor.this.currentGUI.getRectangle() != null) {
                    ContentExtractor.this.extractContent();
                    if (ContentExtractor.this.currentGUI.isPDFOutlineVisible()) {
                        ContentExtractor.this.createThumbnails();
                    }
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        currentBar1.add(Box.createHorizontalGlue());
        String tooltip = "Show extracted items";
        if (this.showExtractedItems) {
            tooltip = "Hide extracted items";
        }
        this.showItemsExtracted.init("/org/jpedal/examples/contentextractor/list.gif", -1, tooltip);
        this.showItemsExtracted.setVisible(false);
        currentBar1.add((AbstractButton)((Object)this.showItemsExtracted));
        ((AbstractButton)((Object)this.showItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean current = !ContentExtractor.this.currentGUI.isPDFOutlineVisible();
                ContentExtractor.this.currentGUI.setPDFOutlineVisible(current);
                ContentExtractor.this.showExtractedItems = !ContentExtractor.this.showExtractedItems;
                if (current) {
                    ContentExtractor.this.createThumbnails();
                } else {
                    ContentExtractor.this.showExtractedItems = false;
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
        this.saveItemsExtracted.init("/org/jpedal/examples/simpleviewer/res/save.gif", -1, "Save extracted items");
        this.saveItemsExtracted.setVisible(false);
        currentBar1.add((AbstractButton)((Object)this.saveItemsExtracted));
        ((AbstractButton)((Object)this.saveItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean saved = ContentExtractor.this.saveThumbnails();
                if (saved) {
                    ContentExtractor.this.resetToEmpty(false);
                }
                ContentExtractor.this.decode_pdf.setHighlightedAreas(null);
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
    }

    private boolean saveThumbnails() {
        boolean wasSaved = false;
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(1);
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String newTarget = file.getAbsolutePath();
            if (file.exists()) {
                this.currentGUI.showMessageDialog("Directory already exists - please use another name");
            } else {
                file.mkdirs();
                String target = this.commonValues.getTarget();
                String separator = this.commonValues.getSeparator();
                if (target != null) {
                    File temp_files = new File(target);
                    String[] file_list = temp_files.list();
                    if (file_list != null) {
                        int ii = 0;
                        while (ii < file_list.length) {
                            if (!file_list[ii].endsWith(type) | this.imagesUsed.get(file_list[ii]) != null) {
                                File delete_file = new File(String.valueOf(target) + separator + file_list[ii]);
                                ObjectStore.copy(String.valueOf(target) + separator + file_list[ii], String.valueOf(newTarget) + separator + file_list[ii]);
                                delete_file.deleteOnExit();
                                delete_file.delete();
                            }
                            ++ii;
                        }
                    }
                    wasSaved = true;
                }
            }
        }
        if (wasSaved) {
            this.showExtractedItems = false;
        }
        return wasSaved;
    }

    private void openButton(JToolBar currentBar1) {
        SwingButton open = new SwingButton();
        open.init("/org/jpedal/examples/simpleviewer/res/open.gif", -1, Messages.getMessage("PdfViewerFileMenuTooltip.open"));
        currentBar1.add(open);
        ((AbstractButton)open).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContentExtractor.this.commonValues.setProcessing(false);
                boolean dataWillBeOverwritten = true;
                if (ContentExtractor.this.itemSelectedCount == 1) {
                    dataWillBeOverwritten = false;
                } else {
                    int choice = ContentExtractor.this.currentGUI.showConfirmDialog(" ARE YOU SURE you wish to lose the currently selected items?", "Extracted Content WILL be overwritten", 0);
                    if (choice == 0) {
                        dataWillBeOverwritten = false;
                    }
                }
                if (!dataWillBeOverwritten) {
                    ContentExtractor.this.resetToEmpty(false);
                    ContentExtractor.this.currentGUI.setPDFOutlineVisible(false);
                    ContentExtractor.this.currentGUI.zoom(false);
                    ContentExtractor.this.currentCommands.selectFile();
                }
            }
        });
        currentBar1.add(Box.createHorizontalGlue());
    }

    private void resetToEmpty(boolean saveFirst) {
        int choice;
        if (saveFirst && this.itemSelectedCount > 1 && (choice = this.currentGUI.showConfirmDialog("Do you wish to save it first?", "Extracted Content WILL be overwritten", 0)) == 0) {
            while (!this.saveThumbnails()) {
            }
        }
        this.showExtractedItems = false;
        this.showItemsExtracted.setVisible(false);
        this.saveItemsExtracted.setVisible(false);
        this.itemSelectedX1 = new Vector_Int(10);
        this.itemSelectedY1 = new Vector_Int(10);
        this.itemSelectedWidth = new Vector_Int(10);
        this.itemSelectedHeight = new Vector_Int(10);
        this.itemSelectedCount = 1;
        this.pageUsed = new Vector_Int(10);
        this.imagesStored = new Vector_String(10);
        this.imagesUsed = new HashMap();
        this.thumbnailsStored = new Vector_Object(10);
        this.textStored = new Vector_String(10);
        this.xmlStored = new Vector_String(10);
        this.currentCommands.flush();
        this.decode_pdf.removeHiglightedObject();
        this.decode_pdf.setHighlightedZones(0, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.decode_pdf.updateCursorBoxOnScreen(null, null);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        this.currentGUI.setSplitDividerLocation(0);
        this.decode_pdf.repaint();
    }

    private void extractContent() {
        BufferedImage snapShot = null;
        String xmlText = null;
        String text = null;
        try {
            PdfGroupingAlgorithms currentGrouping = this.decode_pdf.getGroupingObject();
            int t_x1 = this.commonValues.m_x1;
            int t_x2 = this.commonValues.m_x2;
            int t_y1 = this.commonValues.m_y1;
            int t_y2 = this.commonValues.m_y2;
            if (t_y1 < t_y2) {
                t_y2 = this.commonValues.m_y1;
                t_y1 = this.commonValues.m_y2;
            }
            if (t_x1 > t_x2) {
                t_x2 = this.commonValues.m_x1;
                t_x1 = this.commonValues.m_x2;
            }
            if ((xmlText = currentGrouping.extractTextInRectangle(t_x1 - 3, t_y1 + 3, t_x2 + 6, t_y2 - 6, this.commonValues.getCurrentPage(), false, true)) != null) {
                text = Strip.stripXML(xmlText).toString();
            }
        }
        catch (PdfException e) {
            e.printStackTrace();
        }
        snapShot = this.extractSelectedScreenAsImage();
        this.popupDisplay(snapShot, xmlText, text, this.itemSelectedCount, true, false);
    }

    private void popupDisplay(final BufferedImage snapShot, String xmlText, String text, final int id, final boolean calculateLocations, boolean isResave) {
        JTabbedPane display = new JTabbedPane();
        final JTextPane textPane = new JTextPane();
        final JTextPane xmlPane = new JTextPane();
        JPanel image_display = new JPanel();
        image_display.setLayout(new BorderLayout());
        if (snapShot == null) {
            return;
        }
        image_display.add((Component)new JLabel(new IconiseImage(snapShot)), "Center");
        JScrollPane imageScroll = new JScrollPane();
        imageScroll.setVerticalScrollBarPolicy(20);
        imageScroll.setHorizontalScrollBarPolicy(30);
        imageScroll.getVerticalScrollBar().setUnitIncrement(80);
        imageScroll.getHorizontalScrollBar().setUnitIncrement(80);
        imageScroll.getViewport().add(image_display);
        imageScroll.setPreferredSize(new Dimension(400, 400));
        display.addTab("Image", imageScroll);
        if (xmlText != null) {
            JScrollPane scroll = new JScrollPane();
            try {
                scroll = this.currentGUI.createPane(xmlPane, xmlText, true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(400, 400));
            display.addTab("XML", scroll);
        }
        if (text != null) {
            JScrollPane scroll1 = new JScrollPane();
            try {
                scroll1 = this.currentGUI.createPane(textPane, text, true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            scroll1.setHorizontalScrollBarPolicy(31);
            scroll1.setVerticalScrollBarPolicy(20);
            scroll1.setPreferredSize(new Dimension(400, 400));
            display.addTab("Text", scroll1);
        }
        String message = "Extracted Content - would you like to accept?";
        if (isResave) {
            message = "Would you like to save any changes you have made to the current item?";
        }
        final JDialog displayFrame = new JDialog((Frame)this.currentGUI.getFrame(), true);
        displayFrame.setLocationRelativeTo(null);
        displayFrame.setLocation(this.currentGUI.getFrame().getLocationOnScreen().x + 10, this.currentGUI.getFrame().getLocationOnScreen().y + 10);
        displayFrame.setSize(450, 450);
        displayFrame.setTitle(message);
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)display, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        JButton yes = new JButton(Messages.getMessage("PdfMessage.Yes"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String extractedtext = "";
                String finalxmlText = "";
                extractedtext = textPane.getText();
                finalxmlText = xmlPane.getText();
                if (calculateLocations) {
                    ContentExtractor.this.textStored.addElement(extractedtext);
                    ContentExtractor.this.xmlStored.addElement(finalxmlText);
                } else {
                    ContentExtractor.this.textStored.setElementAt(extractedtext, id - 1);
                    ContentExtractor.this.xmlStored.setElementAt(finalxmlText, id - 1);
                }
                ContentExtractor.this.saveExtractedContent(snapShot, finalxmlText, extractedtext, id, calculateLocations);
                if (ContentExtractor.this.itemSelectedCount == 1) {
                    ContentExtractor.this.showItemsExtracted.setVisible(true);
                    ContentExtractor.this.saveItemsExtracted.setVisible(true);
                }
                if (calculateLocations) {
                    ContentExtractor contentExtractor = ContentExtractor.this;
                    contentExtractor.itemSelectedCount = contentExtractor.itemSelectedCount + 1;
                    ContentExtractor.this.itemSelectedX1.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_x1);
                    ContentExtractor.this.itemSelectedY1.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_y1);
                    ContentExtractor.this.itemSelectedWidth.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_x2);
                    ContentExtractor.this.itemSelectedHeight.addElement(((ContentExtractor)ContentExtractor.this).commonValues.m_y2);
                }
                if (calculateLocations) {
                    ContentExtractor.this.createOnscreenOutlines();
                }
                displayFrame.dispose();
            }
        });
        JButton no = new JButton(Messages.getMessage("PdfMessage.No"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                displayFrame.dispose();
            }
        });
        displayFrame.setVisible(true);
    }

    private void createOnscreenOutlines() {
        int[] x1 = this.itemSelectedX1.get();
        int[] y1 = this.itemSelectedY1.get();
        int[] x2 = this.itemSelectedWidth.get();
        int[] y2 = this.itemSelectedHeight.get();
        int[] order = new int[this.itemSelectedCount];
        boolean[] highlightedZonesSelected = new boolean[this.itemSelectedCount];
        int[] processedByRegularExpression = new int[this.itemSelectedCount];
        Rectangle2D[] outlineZone = new Rectangle2D[this.itemSelectedCount];
        Shape[] fragmentShapes = new Shape[this.itemSelectedCount];
        Color[] fragmentColorCoding = new Color[this.itemSelectedCount];
        int[] plotNumberX = new int[this.itemSelectedCount];
        int[] plotNumberY = new int[this.itemSelectedCount];
        int i = 0;
        while (i < this.itemSelectedCount) {
            order[i] = i;
            highlightedZonesSelected[i] = true;
            outlineZone[i] = new Rectangle(x1[i], y2[i], x2[i] - x1[i], y1[i] - y2[i]);
            plotNumberX[i] = (int)((outlineZone[i].getBounds().getMinX() + outlineZone[i].getBounds().getMaxX()) / 2.0);
            plotNumberY[i] = (int)((outlineZone[i].getBounds().getMinY() + outlineZone[i].getBounds().getMaxY()) / 2.0) - 12;
            if (this.pageUsed.elementAt(i) == this.commonValues.getCurrentPage()) {
                fragmentShapes[i] = outlineZone[i];
            }
            fragmentColorCoding[i] = Color.BLUE;
            ++i;
        }
        this.currentGUI.setRectangle(null);
        this.decode_pdf.setHighlightedZones(1, plotNumberX, plotNumberY, fragmentShapes, null, null, null, null, outlineZone, highlightedZonesSelected, null, fragmentColorCoding, order, processedByRegularExpression);
        this.decode_pdf.repaint();
    }

    private void saveExtractedContent(BufferedImage snapShot, String xml, String text, int id, boolean isSave) {
        String target = this.commonValues.getTarget();
        String separator = this.commonValues.getSeparator();
        if (target == null) {
            try {
                File tmp = File.createTempFile("jpedal", "ads");
                File dir = new File(String.valueOf(tmp.getAbsolutePath()) + "-files");
                dir.mkdirs();
                dir.deleteOnExit();
                target = dir.getAbsolutePath();
                this.commonValues.setTarget(target);
                tmp.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (target != null) {
            if (isSave) {
                if (snapShot != null) {
                    String name = "page_" + this.commonValues.getCurrentPage() + "_id" + id + '.' + type;
                    String fileLocation = String.valueOf(target) + separator + name;
                    JAI.create((String)"filestore", (RenderedImage)snapShot, (Object)fileLocation, (Object)type);
                    this.thumbnailsStored.addElement(snapShot);
                    this.imagesStored.addElement(fileLocation);
                    this.imagesUsed.put(name, "x");
                } else {
                    this.imagesStored.addElement(null);
                    this.thumbnailsStored.addElement(null);
                }
            }
        } else {
            this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
        }
        int page = this.commonValues.getCurrentPage();
        if (!isSave) {
            page = this.pageUsed.elementAt(id - 1);
        } else {
            this.pageUsed.addElement(page);
        }
        try {
            this.writeText(text, target, id, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentGUI.showInputDialog("Problem saving text");
        }
        try {
            this.writeXML(xml, target, id, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentGUI.showMessageDialog("Problem saving xml");
        }
    }

    private void writeText(String text, String target, int id, int currentPage) throws Exception {
        OutputStreamWriter output_stream = new OutputStreamWriter(new FileOutputStream(String.valueOf(target) + this.commonValues.getSeparator() + "page_" + currentPage + "_id" + id + ".txt"));
        output_stream.write(text);
        output_stream.close();
    }

    public void writeXML(String xml, String target, int id, int currentPage) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("content");
            doc.appendChild(root);
            Comment creation = doc.createComment("Created " + TimeNow.getShortTimeNow());
            Comment version = doc.createComment("Extracted via JPedal");
            Comment source = doc.createComment("SourceFile " + this.decode_pdf.getObjectStore().getCurrentFilename());
            root.appendChild(creation);
            root.appendChild(version);
            root.appendChild(source);
            Element currentElement = this.addTextAsXML(xml, doc, root);
            Node textNode = doc.importNode(currentElement, true);
            root.appendChild(textNode);
            InputStream stylesheet = this.decode_pdf.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            transformer.transform(new DOMSource(doc), new StreamResult(String.valueOf(target) + this.commonValues.getSeparator() + "page_" + currentPage + "_id" + id + ".xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Element addTextAsXML(String textData, Document doc, Node root) throws FactoryConfigurationError {
        Element currentElement = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            out.write("<?xml version=\"1.0\"?><text>");
            int ll = textData.length();
            int i = 0;
            while (i < ll) {
                char c = textData.charAt(i);
                if (c == '&') {
                    boolean isTag = false;
                    int j = i + 1;
                    while (j < ll) {
                        char nextC = textData.charAt(i);
                        if (nextC == ';') {
                            j = ll;
                            isTag = true;
                        } else if (nextC == ' ' | nextC == '\n') {
                            j = ll;
                        }
                        ++j;
                    }
                    if (isTag) {
                        out.write(c);
                    } else {
                        out.write("&amp;");
                    }
                } else if (c > '\u0000') {
                    out.write(c);
                }
                ++i;
            }
            out.write("</text>");
            out.close();
            bos.close();
            ByteArrayInputStream bos2 = new ByteArrayInputStream(bos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document dataDoc = factory.newDocumentBuilder().parse(bos2);
            NodeList nodes = dataDoc.getElementsByTagName("text");
            currentElement = (Element)nodes.item(0);
            bos.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " in writing text \n" + textData);
        }
        return currentElement;
    }

    private BufferedImage extractSelectedScreenAsImage() {
        int t_x1 = this.commonValues.m_x1;
        int t_x2 = this.commonValues.m_x2;
        int t_y1 = this.commonValues.m_y1;
        int t_y2 = this.commonValues.m_y2;
        if (t_y1 < t_y2) {
            t_y2 = this.commonValues.m_y1;
            t_y1 = this.commonValues.m_y2;
        }
        if (t_x1 > t_x2) {
            t_x2 = this.commonValues.m_x1;
            t_x1 = this.commonValues.m_x2;
        }
        return this.decode_pdf.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, 100.0f);
    }

    private void createThumbnails() {
        this.currentGUI.initThumbnails(this.itemSelectedCount, this.pageUsed);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        Object[] buttons = this.thumbnails.getButtons();
        int i = 0;
        while (i < this.itemSelectedCount - 1) {
            JButton eachThumb = (JButton)buttons[i];
            eachThumb.addActionListener(new ButtonPopup(i));
            ++i;
        }
    }

    public class ButtonPopup
    implements ActionListener {
        int id;
        JButton[] buttons;

        public ButtonPopup(int i) {
            this.id = i;
        }

        public void actionPerformed(ActionEvent arg0) {
            ContentExtractor.this.thumbnails.resetHighlightedThumbnail(this.id);
            ContentExtractor.this.thumbnails.refreshDisplay();
            BufferedImage img = JAI.create((String)"fileload", (Object)ContentExtractor.this.imagesStored.elementAt(this.id)).getAsBufferedImage();
            ContentExtractor.this.popupDisplay(img, ContentExtractor.this.xmlStored.elementAt(this.id), ContentExtractor.this.textStored.elementAt(this.id), this.id + 1, false, true);
        }
    }
}

