/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.io.File;
import java.util.Iterator;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ExtractFormDataAsObject {
    private String outputDir = System.getProperty("user.dir");
    private int fileCount = 0;
    static boolean outputMessages = false;
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private static String test_file = "/PDFdata/files-jpedal/Testdokument PDF.pdf";

    public int getFileCount() {
        return this.fileCount;
    }

    public ExtractFormDataAsObject() {
    }

    public ExtractFormDataAsObject(String file_name) {
        File output_path;
        if (!this.outputDir.endsWith(this.separator)) {
            this.outputDir = String.valueOf(this.outputDir) + this.separator + "forms" + this.separator;
        }
        if (!(output_path = new File(this.outputDir)).exists()) {
            output_path.mkdirs();
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodePage("", file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(">>_" + file_name + files[i]);
                    }
                    this.decodePage(file_name, files[i]);
                }
                ++i;
            }
        }
    }

    private void decodePage(String dir, String name) {
        String file_name = String.valueOf(dir) + name;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (outputMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decodePdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception " + e + " in pdf code with " + file_name);
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            ++this.fileCount;
            Iterator components = null;
            try {
                components = this.decodePdf.getNamesForAllFields().iterator();
            }
            catch (PdfException e) {
                e.printStackTrace();
            }
            while (components != null && components.hasNext()) {
                String nextCompName = (String)components.next();
                if (outputMessages) {
                    System.out.println(nextCompName);
                }
                Object formData = this.decodePdf.getFormDataForField(nextCompName);
                System.out.println(String.valueOf(nextCompName) + ' ' + formData);
            }
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] args) {
        File pdf_file;
        if (outputMessages) {
            System.out.println("Simple demo to extract form data");
        }
        String file_name = test_file;
        if (args.length != 1) {
            if (outputMessages) {
                System.out.println("Default test file used");
            }
        } else {
            file_name = args[0];
            if (outputMessages) {
                System.out.println("File :" + file_name);
            }
        }
        if (!(pdf_file = new File(file_name)).exists() && outputMessages) {
            System.out.println("File " + file_name + " not found");
        }
        ExtractFormDataAsObject text2 = new ExtractFormDataAsObject(file_name);
    }

    public String getOutputDir() {
        return this.outputDir;
    }
}

