/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfFormData;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtractFormData {
    private String outputDir = System.getProperty("user.dir");
    private int fileCount = 0;
    static boolean outputMessages = false;
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private boolean saveToFile = true;
    private Document doc;
    private static String test_file = "/PDFdata/files-jpedal/Testdokument PDF.pdf";

    public int getFileCount() {
        return this.fileCount;
    }

    public ExtractFormData() {
    }

    public ExtractFormData(String file_name) {
        File output_path;
        if (!this.outputDir.endsWith(this.separator)) {
            this.outputDir = String.valueOf(this.outputDir) + this.separator + "forms" + this.separator;
        }
        if (!(output_path = new File(this.outputDir)).exists()) {
            output_path.mkdirs();
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodePage("", file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(">>_" + file_name + files[i]);
                    }
                    this.decodePage(file_name, files[i]);
                }
                ++i;
            }
        }
    }

    private void decodePage(String dir, String name) {
        String file_name = String.valueOf(dir) + name;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (outputMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decodePdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception " + e + " in pdf code with " + file_name);
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            ++this.fileCount;
            PdfFormData formData = this.decodePdf.getPdfFormData();
            if (outputMessages) {
                System.out.println(formData);
            }
            if (formData != null) {
                List formDoc = formData.getFormData();
                String outputName = name;
                int pointer = outputName.lastIndexOf(46);
                if (pointer > 0) {
                    outputName = outputName.substring(0, pointer);
                }
                if ((pointer = outputName.lastIndexOf(47)) > 0) {
                    outputName = outputName.substring(pointer + 1);
                }
                if ((pointer = outputName.lastIndexOf(92)) > 0) {
                    outputName = outputName.substring(pointer + 1);
                }
                String saveName = String.valueOf(this.outputDir) + outputName + ".xml";
                int itemCount = formDoc.size();
                DocumentBuilder db = null;
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    db = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                this.doc = db.newDocument();
                Element root = this.doc.createElement("Root");
                int i = 0;
                while (i < itemCount) {
                    Map value = (Map)formDoc.get(i);
                    Element e = this.doc.createElement("Object" + i);
                    this.extractKeyValues(value, e);
                    root.appendChild(e);
                    ++i;
                }
                this.doc.appendChild(root);
                InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
                    if (outputMessages) {
                        transformer.transform(new DOMSource(this.doc), new StreamResult(System.out));
                    }
                    if (this.saveToFile) {
                        StreamResult stream = new StreamResult(saveName);
                        transformer.transform(new DOMSource(this.doc), stream);
                        if (outputMessages) {
                            System.out.println("Saved to " + saveName);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.decodePdf.closePdfFile();
    }

    private void extractKeyValues(Map value, Node root) {
        if (value.containsKey("startStreamOnDisk")) {
            int start = (Integer)value.get("startStreamOnDisk");
            int end = (Integer)value.get("endStreamOnDisk");
            byte[] stream = this.decodePdf.getIO().readStreamFromPDF(start, end);
            value.put("Stream", stream);
            value.remove("startStreamOnDisk");
            value.remove("endStreamOnDisk");
        }
        Iterator keys = value.keySet().iterator();
        String currentKey = null;
        HashMap<String, String> ignoredKeys = new HashMap<String, String>();
        ignoredKeys.put("P", "x");
        ignoredKeys.put("Parent", "x");
        ignoredKeys.put("obj", "x");
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            if (ignoredKeys.containsKey(currentKey)) continue;
            Object nextValue = value.get(currentKey);
            try {
                Element currentElement = this.doc.createElement(currentKey);
                if (nextValue.toString().endsWith(" R")) {
                    nextValue = this.decodePdf.resolveFormReference((String)nextValue);
                }
                if (nextValue instanceof byte[]) {
                    nextValue = this.decodePdf.getIO().getTextString((byte[])nextValue);
                    currentElement.setAttribute("value", (String)nextValue);
                } else if (nextValue instanceof Map) {
                    Map section = (Map)nextValue;
                    if (currentKey.equals("Kids")) {
                        Iterator kidKeys = section.keySet().iterator();
                        while (kidKeys.hasNext()) {
                            HashMap kidSection = new HashMap();
                            Object nextKey = kidKeys.next();
                            Object kidValue = section.get(nextKey);
                            kidSection.put("Kid", kidValue);
                            this.extractKeyValues(kidSection, currentElement);
                        }
                    } else {
                        this.extractKeyValues(section, currentElement);
                    }
                } else {
                    String val = (String)nextValue;
                    currentElement.setAttribute("value", val);
                }
                root.appendChild(currentElement);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(currentKey) + " not valid as XML value");
            }
        }
    }

    public static void main(String[] args) {
        File pdf_file;
        if (outputMessages) {
            System.out.println("Simple demo to extract form data");
        }
        String file_name = test_file;
        if (args.length != 1) {
            if (outputMessages) {
                System.out.println("Default test file used");
            }
        } else {
            file_name = args[0];
            if (outputMessages) {
                System.out.println("File :" + file_name);
            }
        }
        if (!(pdf_file = new File(file_name)).exists() && outputMessages) {
            System.out.println("File " + file_name + " not found");
        }
        ExtractFormData text1 = new ExtractFormData(file_name);
    }

    public String getOutputDir() {
        return this.outputDir;
    }
}

