/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.io.File;
import org.jpedal.PdfDecoder;

public class ShowIfEmbeddedFontsUsed {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    private ShowIfEmbeddedFontsUsed() {
    }

    public ShowIfEmbeddedFontsUsed(String file_name) {
        String separator = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = String.valueOf(this.user_dir) + separator;
        }
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            System.out.println("Opening file :" + file_name);
            decode_pdf.openPdfFile(file_name);
            System.out.println("File contains embedded fonts=" + decode_pdf.PDFContainsEmbeddedFonts());
            decode_pdf.closePdfFile();
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to see if file contains embedded fonts");
        String file_name = test_file;
        if (args.length != 1) {
            System.out.println("Please pass the file name and any path (ie \"C:/sample.pdf\" ) as a command line value - use double quotes if it includes spaces");
        } else {
            file_name = args[0];
            System.out.println("File :" + file_name);
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        }
        ShowIfEmbeddedFontsUsed pageCount1 = new ShowIfEmbeddedFontsUsed(file_name);
    }
}

