/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    protected ColorMapping colorMapper;
    private float[] domain;
    protected int cmykMapping = -1;
    protected static final int NOCMYK = -1;
    protected static final int MYK = 1;
    protected static final int CMY = 1;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader currentPdfFile, String currentColorspace, Map colorValues) {
        this.value = 10;
        this.processColorToken(currentPdfFile, currentColorspace, colorValues);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void processColorToken(PdfObjectReader currentPdfFile, String currentColorspace, Map colorValues) {
        block37: {
            block34: {
                block35: {
                    block36: {
                        altColorSpaceName = "";
                        transformName = "";
                        altColorSpace /* !! */  = new Hashtable<K, V>();
                        tintTransform /* !! */  = new Hashtable<K, V>();
                        stream = null;
                        range = null;
                        compList = new StringBuffer();
                        this.domain = null;
                        sep_tokens = new StringTokenizer(currentColorspace, " ");
                        if (sep_tokens.countTokens() <= 3) break block34;
                        sepKeyWord = sep_tokens.nextToken();
                        if (sepKeyWord.equals("/Indexed")) {
                            sepKeyWord = sep_tokens.nextToken();
                        }
                        if (this.value == 10) {
                            this.pantoneName = sep_tokens.nextToken().substring(1);
                            this.componentCount = 1;
                        } else {
                            colorantWord = sep_tokens.nextToken();
                            this.componentCount = 0;
                            while (true) {
                                v0 = tagOnEnd = (colorantWord = sep_tokens.nextToken()).length() > 1 && colorantWord.endsWith("]") != false;
                                if (tagOnEnd) {
                                    ++this.componentCount;
                                    compList.append(colorantWord.substring(0, colorantWord.length() - 1));
                                } else if (colorantWord.length() > 1) {
                                    compList.append(colorantWord);
                                }
                                if (colorantWord.equals("]") || tagOnEnd) break;
                                ++this.componentCount;
                            }
                        }
                        altColorSpaceName = sep_tokens.nextToken();
                        if (altColorSpaceName.equals("[")) {
                            while (altColorSpaceName.indexOf(93) == -1) {
                                altColorSpaceName = String.valueOf(altColorSpaceName) + ' ' + sep_tokens.nextToken();
                            }
                        }
                        transformName = sep_tokens.nextToken();
                        if (!sep_tokens.hasMoreTokens()) break block35;
                        if (transformName.equals("0")) {
                            altColorSpaceName = String.valueOf(altColorSpaceName) + " 0 R";
                            altColorSpace /* !! */  = currentPdfFile.readObject(altColorSpaceName, false, null);
                            transformName = "";
                            sep_tokens.nextToken();
                        } else {
                            transformName = String.valueOf(transformName) + ' ';
                        }
                        if (this.value != 10) ** GOTO lbl56
                        while (sep_tokens.hasMoreTokens()) {
                            transformName = String.valueOf(transformName) + sep_tokens.nextToken() + ' ';
                        }
                        break block36;
lbl-1000:
                        // 1 sources

                        {
                            nextToken = sep_tokens.nextToken();
                            transformName = String.valueOf(transformName) + nextToken + ' ';
                            if (nextToken.equals("R") || nextToken.equals("<<")) break;
lbl56:
                            // 2 sources

                            ** while (sep_tokens.hasMoreTokens())
                        }
                    }
                    transformName = transformName.trim();
                    if (transformName.length() == 0) {
                        tintTransform /* !! */  = colorValues;
                    }
                    if (transformName.endsWith("R")) {
                        tintTransform /* !! */  = currentPdfFile.readObject(transformName, false, null);
                    }
                    if (altColorSpaceName.endsWith("R")) {
                        ColObj = currentPdfFile.readObject(altColorSpaceName, false, null);
                        altColorSpaceName = (String)ColObj.get("rawValue");
                    }
                }
                if (transformName.length() > 0) {
                    stream = currentPdfFile.readStream(transformName, true);
                }
                break block37;
            }
            this.pantoneName = currentColorspace.substring(11).trim();
            firstR = this.pantoneName.indexOf(82);
            if (this.pantoneName.startsWith("/")) {
                this.pantoneName = this.pantoneName.substring(1);
                altIndex = this.pantoneName.indexOf(47);
                if (altIndex != -1) {
                    altColorSpaceName = this.pantoneName.substring(altIndex).trim();
                    this.pantoneName = this.pantoneName.substring(0, altIndex).trim();
                }
            } else if (firstR != -1) {
                altColorSpaceName = this.pantoneName.substring(firstR + 1).trim();
                this.pantoneName = currentPdfFile.getValue(this.pantoneName.substring(0, firstR));
                if (altColorSpaceName.endsWith("R")) {
                    altColorSpaceName = currentPdfFile.getValue(altColorSpaceName);
                }
            }
            if (altColorSpaceName.length() == 0) {
                ii = colorValues.keySet().iterator();
                altColorSpaceName = "";
                while (ii.hasNext()) {
                    next = (String)ii.next();
                    if (next.equals("rawValue")) continue;
                    altColorSpaceName = String.valueOf(altColorSpaceName) + next;
                }
            }
            if (colorValues != null) {
                tintTransform /* !! */  = (Map)colorValues.get(altColorSpaceName);
            }
            if (tintTransform /* !! */  == null) {
                tintTransform /* !! */  = colorValues;
            }
        }
        if (compList.toString().equals("/Magenta/Yellow/Black")) {
            this.cmykMapping = 1;
            this.altCS = new DeviceCMYKColorSpace();
        } else if (compList.toString().equals("/Yellow/Black/Key")) {
            this.cmykMapping = 1;
            this.altCS = new DeviceCMYKColorSpace();
        } else {
            this.altCS = ColorspaceDecoder.getColorSpaceInstance(false, null, altColorSpaceName, altColorSpace /* !! */ , currentPdfFile);
        }
        if (this.pantoneName != null && this.pantoneName.indexOf(35) != -1) {
            newValue = new StringBuffer();
            nameLength = this.pantoneName.length();
            i = 0;
            while (i < nameLength) {
                c = this.pantoneName.charAt(i);
                if (c == '#') {
                    hexValue = this.pantoneName.substring(i + 1, i + 3);
                    newValue.append((char)Integer.parseInt(hexValue, 16));
                    i += 2;
                } else {
                    newValue.append(c);
                }
                ++i;
            }
            this.pantoneName = newValue.toString();
        }
        this.colorMapper = new ColorMapping(currentPdfFile, tintTransform /* !! */ , stream, range);
        this.domain = this.colorMapper.getDomain();
    }

    private void setColor(float value) {
        try {
            int elements = 1;
            if (this.domain != null) {
                elements = this.domain.length / 2;
            }
            float[] values = new float[elements];
            int j = 0;
            while (j < elements) {
                values[j] = value;
                ++j;
            }
            float[] operand = this.colorMapper.getOperandFloat(values);
            if ((this.altCS.getID() == 3 || this.altCS.getID() == 7) && this.colorMapper.getFunctionType() == 4) {
                int size = operand.length;
                float[] reversed = new float[size];
                int ii = 0;
                while (ii < size) {
                    reversed[size - ii - 1] = operand[ii];
                    ++ii;
                }
                operand = reversed;
            } else if (operand.length == 4) {
                float[] temp = operand;
                int jj = 1;
                while (jj < 4) {
                    if (operand[jj] != 0.0f) {
                        operand = temp;
                        break;
                    }
                    operand[jj] = operand[0];
                    ++jj;
                }
            }
            this.altCS.setColor(operand, operand.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor(float[] operand, int opCount) {
        this.setColor(operand[0]);
    }

    public void setColor(String[] operand, int opCount) {
        float[] f = new float[]{Float.parseFloat(operand[0])};
        this.setColor(f, 1);
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, String decodeArray) {
        BufferedImage image = null;
        ByteArrayInputStream in = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        try {
            in = new ByteArrayInputStream(data);
            iir = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster r = iir.readRaster(0, null);
            int w = r.getWidth();
            int h = r.getHeight();
            DataBufferByte rgb = (DataBufferByte)r.getDataBuffer();
            image = this.createImage(w, h, rgb.getData());
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        try {
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return image;
    }

    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image = null;
        try {
            image = this.createImage(w, h, data);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + ee);
        }
        return image;
    }

    private BufferedImage createImage(int w, int h, byte[] rgb) {
        int byteCount = rgb.length;
        float[] lookuptable = new float[256];
        int i = 0;
        while (i < 255) {
            lookuptable[i] = -1.0f;
            ++i;
        }
        i = 0;
        while (i < byteCount) {
            int value = rgb[i] & 0xFF;
            if (lookuptable[value] == -1.0f) {
                this.setColor((float)value / 255.0f);
                lookuptable[value] = ((Color)((Object)this.getColor())).getRed();
            }
            rgb[i] = (byte)lookuptable[value];
            ++i;
        }
        int[] bands = new int[1];
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        BufferedImage image = new BufferedImage(w, h, 10);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w, h, w, 1, bands, null);
        image.setData(raster);
        return image;
    }

    public byte[] convertIndexToRGB(byte[] data) {
        byte[] newdata = new byte[768];
        try {
            int outputReached = 0;
            float[] opValues = new float[1];
            Color currentCol = null;
            int byteCount = data.length;
            float[] values = new float[this.componentCount];
            int i = 0;
            while (i < byteCount) {
                if (this.componentCount == 1 && this.value == 10) {
                    opValues = new float[1];
                    opValues[1] = data[i] & 0xFF;
                    this.setColor(opValues, 1);
                    currentCol = (Color)((Object)this.getColor());
                } else {
                    int j = 0;
                    while (j < this.componentCount) {
                        values[j] = (float)(data[i + j] & 0xFF) / 255.0f;
                        ++j;
                    }
                    float[] operand = this.colorMapper.getOperandFloat(values);
                    if (this.altCS.getID() == 7) {
                        int size = operand.length;
                        float[] reversed = new float[size];
                        int ii = 0;
                        while (ii < size) {
                            reversed[size - ii - 1] = operand[ii];
                            ++ii;
                        }
                        operand = reversed;
                    }
                    this.altCS.setColor(operand, operand.length);
                    currentCol = (Color)((Object)this.altCS.getColor());
                }
                newdata[outputReached] = (byte)currentCol.getBlue();
                newdata[++outputReached] = (byte)currentCol.getGreen();
                newdata[++outputReached] = (byte)currentCol.getRed();
                ++outputReached;
                i += this.componentCount;
            }
        }
        catch (Exception ee) {
            System.out.println(ee);
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return newdata;
    }

    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

