/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.jpedal.color.PdfPaint;
import org.jpedal.render.DynamicVectorRenderer;

public class PdfTexturePaint
extends TexturePaint
implements PdfPaint {
    BufferedImage img;
    DynamicVectorRenderer glyphDisplay = null;
    TexturePaint rotatedPaint;
    private boolean isRotated = false;
    private float[][] matrix;
    private float YStep;
    private float dx;
    private float dy;
    private AffineTransform imageScale;
    private float XStep;
    private float xx;
    private float yy;
    private boolean isUpsideDown;

    public PdfTexturePaint(BufferedImage txtr, Rectangle2D anchor, boolean isRotated, DynamicVectorRenderer glyphDisplay) {
        super(txtr, anchor);
        this.isRotated = isRotated;
        if (isRotated) {
            this.glyphDisplay = glyphDisplay;
        } else {
            this.img = txtr;
        }
    }

    public PdfTexturePaint(BufferedImage txtr, Rectangle2D anchor) {
        super(txtr, anchor);
        this.img = txtr;
    }

    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        if (this.isRotated) {
            float startX = 0.0f;
            float startY = 0.0f;
            int w = (int)ub.getWidth();
            int h = (int)ub.getHeight();
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D g2 = image.createGraphics();
            AffineTransform defaultAf2 = g2.getTransform();
            int yCount = 0;
            float offX = 0.0f;
            float offY = 0.0f;
            float rotatedWidth = this.XStep * this.matrix[0][0] - this.YStep * this.matrix[1][0];
            float rotatedHeight = -(this.YStep * this.matrix[1][1]) - this.XStep * this.matrix[0][1];
            float shapeW = ub.getBounds().width;
            float shapeH = ub.getBounds().height;
            int shapeCountH = (int)(shapeH / rotatedHeight);
            if (shapeCountH > 1) {
                offX = shapeW - rotatedHeight * (float)shapeCountH;
                offY = 5.0f - (shapeH - rotatedWidth * (float)shapeCountH);
            } else if (rotatedHeight > shapeW) {
                offX = rotatedHeight - shapeW;
                offY = shapeH - rotatedWidth;
            } else {
                offX = shapeH - rotatedHeight;
                offY = shapeW - rotatedWidth;
            }
            float y = 0.0f;
            y = 0.0f;
            while (y < (float)h + this.YStep + this.dy) {
                startY = -this.yy - this.yy;
                ++yCount;
                float x = -this.dx;
                while (x < (float)w + this.XStep + this.dx) {
                    g2.translate(offX + x + startX, offY + y + startY);
                    this.glyphDisplay.paint(g2, null, this.imageScale, null, false, false);
                    g2.setTransform(defaultAf2);
                    startY += this.yy;
                    x += this.dx;
                }
                startX -= this.xx;
                y += this.dy;
            }
            Rectangle rect = ub.getBounds();
            this.rotatedPaint = new TexturePaint(image, new Rectangle(rect.x, rect.y, rect.width, rect.height));
            return this.rotatedPaint.createContext(cm, db, ub, xform, hints);
        }
        return super.createContext(cm, db, ub, xform, hints);
    }

    public void setScaling(double cropX, double cropH, float scaling) {
    }

    public boolean isPattern() {
        return false;
    }

    public void setPattern(int dummy) {
    }

    public int getRGB() {
        return 0;
    }

    public void setValues(float[][] matrix, float XStep, float YStep, float dx, float dy, AffineTransform imageScale, boolean isUpsideDown) {
        this.matrix = matrix;
        this.XStep = XStep;
        this.YStep = YStep;
        this.dx = dx;
        this.dy = dy;
        this.imageScale = imageScale;
        this.isUpsideDown = isUpsideDown;
        if (matrix[0][0] != 0.0f && matrix[1][1] != 0.0f) {
            this.xx = XStep * matrix[0][1];
            this.yy = YStep * matrix[1][0];
        }
    }
}

