/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class LabColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private float lastL = -1.0f;
    private float lastA = 65536.0f;
    private float lastBstar;
    private Hashtable cache = new Hashtable();
    private static final float C1 = 0.12841855f;
    private static final float C2 = 0.13793103f;
    private static final float C3 = 0.20689656f;
    private static final float C4 = 0.39215687f;
    private static final float C5 = 128.0f;

    public LabColorSpace(String whitepoint, String blackpoint, String range) {
        this.value = 6;
        this.setCIEValues(whitepoint, blackpoint, range, null, null);
    }

    public byte[] convertIndexToRGB(byte[] index) {
        int size = index.length;
        int i = 0;
        while (i < size) {
            float cl = (float)(index[i] & 0xFF) * 0.39215687f;
            float ca = (float)(index[i + 1] & 0xFF) - 128.0f;
            float cb = (float)(index[i + 2] & 0xFF) - 128.0f;
            this.convertToRGB(cl, ca, cb);
            index[i] = (byte)this.r;
            index[i + 1] = (byte)this.g;
            index[i + 2] = (byte)this.b;
            i += 3;
        }
        return index;
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, String decodeArray) {
        BufferedImage image = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(data);
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
            Raster currentRaster = decoder.decodeAsRaster();
            int width = currentRaster.getWidth();
            int height = currentRaster.getHeight();
            int imgSize = width * height;
            byte[] iData = ((DataBufferByte)currentRaster.getDataBuffer()).getData();
            int i = 0;
            while (i < imgSize * 3) {
                float cl = (float)(iData[i] & 0xFF) * 0.39215687f;
                float ca = (float)(iData[i + 1] & 0xFF) - 128.0f;
                float cb = (float)(iData[i + 2] & 0xFF) - 128.0f;
                this.convertToRGB(cl, ca, cb);
                iData[i] = (byte)this.r;
                iData[i + 1] = (byte)this.g;
                iData[i + 2] = (byte)this.b;
                i += 3;
            }
            DataBufferByte db = new DataBufferByte(iData, iData.length);
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] bands = nArray;
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
            image.setData(raster);
            in.close();
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    public BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image = null;
        int imgSize = width * height;
        try {
            int i = 0;
            while (i < imgSize * 3) {
                float cl = (float)(data[i] & 0xFF) * 0.39215687f;
                float ca = (float)(data[i + 1] & 0xFF) - 128.0f;
                float cb = (float)(data[i + 2] & 0xFF) - 128.0f;
                this.convertToRGB(cl, ca, cb);
                data[i] = (byte)this.r;
                data[i + 1] = (byte)this.g;
                data[i + 2] = (byte)this.b;
                i += 3;
            }
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] bands = nArray;
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
            image.setData(raster);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    private void convertToRGB(float l, float a, float bstar) {
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 100.0f) {
            l = 100.0f;
        }
        if (a < this.R[0]) {
            a = this.R[0];
        } else if (a > this.R[1]) {
            a = this.R[1];
        }
        if (bstar < this.R[2]) {
            bstar = this.R[2];
        } else if (bstar > this.R[3]) {
            bstar = this.R[3];
        }
        if (this.lastL != l || this.lastA != a || this.lastBstar != bstar) {
            int indexL = (int)l;
            int indexA = (int)(a - this.R[0]);
            int indexB = (int)(bstar - this.R[2]);
            Integer key = new Integer((indexL << 16) + (indexA << 8) + indexB);
            Object value = this.cache.get(key);
            if (value != null) {
                int raw = (Integer)value;
                this.r = raw >> 16 & 0xFF;
                this.g = raw >> 8 & 0xFF;
                this.b = raw & 0xFF;
            } else {
                double val1 = ((double)l + 16.0) / 116.0;
                double[] vals = new double[]{val1 + (double)a / 500.0, val1, val1 - (double)bstar / 200.0};
                float[] out = new float[3];
                int j = 0;
                while (j < 3) {
                    out[j] = vals[j] >= 0.2068965584039688 ? (float)((double)this.W[j] * vals[j] * vals[j] * vals[j]) : (float)((double)(this.W[j] * 0.12841855f) * (vals[j] - 0.13793103396892548));
                    ++j;
                }
                out = this.cs.toRGB(out);
                this.r = (int)(out[0] * 255.0f);
                this.g = (int)(out[1] * 255.0f);
                this.b = (int)(out[2] * 255.0f);
                if (this.r < 0) {
                    this.r = 0;
                }
                if (this.g < 0) {
                    this.g = 0;
                }
                if (this.b < 0) {
                    this.b = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                int raw = (this.r << 16) + (this.g << 8) + this.b;
                this.cache.put(key, new Integer(raw));
            }
            this.lastL = l;
            this.lastA = a;
            this.lastBstar = bstar;
        }
    }

    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        int ii = 0;
        while (ii < items) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
            ++ii;
        }
        this.setColor(colValues, items);
    }

    public final void setColor(float[] operand, int length) {
        float l = operand[2];
        float a = operand[1];
        float Bstar = operand[0];
        this.convertToRGB(l, a, Bstar);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }
}

