/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfArray;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class GenericColorSpace
implements Cloneable,
Serializable {
    protected String intent = null;
    protected Map patternValues = null;
    protected int size = 0;
    protected float c = -1.0f;
    protected float y = -1.0f;
    protected float m = -1.0f;
    protected float k = -1.0f;
    protected float[] W;
    protected float[] G;
    protected float[] Ma;
    protected float[] B;
    protected float[] R;
    protected static ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    protected int value = 2;
    private static ColorConvertOp CSToRGB;
    protected ColorSpace cs;
    protected PdfPaint currentColor = new PdfColor(0, 0, 0);
    protected static ColorModel rgbModel;
    private static ICC_Profile ICCProfile;
    protected boolean failed = false;
    protected String alternative = "";
    protected byte[] IndexedColorMap = null;
    public String pantoneName = null;
    protected int componentCount = 3;
    protected GraphicsState gs;
    protected int pageHeight;

    static {
        CSToRGB = null;
        rgbModel = null;
        ICCProfile = null;
        if (ICCProfile != null) {
            System.out.println("setup " + ICCProfile);
            rgbCS = new ICC_ColorSpace(ICCProfile);
        } else {
            rgbCS = ColorSpace.getInstance(1000);
        }
    }

    private static void initCMYKColorspace() throws PdfException {
        try {
            if (ICCProfile == null) {
                rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            } else {
                int compCount = rgbCS.getNumComponents();
                int[] values = new int[compCount];
                int i = 0;
                while (i < compCount) {
                    values[i] = 8;
                    ++i;
                }
                rgbModel = new ComponentColorModel(rgbCS, values, false, false, 1, 0);
            }
            ICC_Profile p = ICC_Profile.getInstance(GenericColorSpace.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            ICC_ColorSpace cmykCS = new ICC_ColorSpace(p);
            CSToRGB = new ColorConvertOp(cmykCS, rgbCS, ColorSpaces.hints);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e.getMessage() + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public boolean isInvalid() {
        return this.failed;
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    public GenericColorSpace() {
        this.cs = rgbCS;
    }

    protected void setAlternative(String alt) {
        this.alternative = alt;
    }

    public final Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return o;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] data, int w, int h, String decodeArray) {
        ImageInputStream iin;
        ImageReader iir;
        ByteArrayInputStream in;
        BufferedImage image;
        block25: {
            boolean isProcessed = false;
            image = null;
            in = null;
            iir = null;
            iin = null;
            try {
                WritableRaster rgbRaster;
                block24: {
                    if (CSToRGB == null) {
                        GenericColorSpace.initCMYKColorspace();
                    }
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    in = new ByteArrayInputStream(data);
                    int cmykType = this.getJPEGTransform(data);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext()) {
                        ImageReader o = iterator.next();
                        iir = o;
                        if (iir.canReadRaster()) break;
                    }
                    ImageIO.setUseCache(false);
                    iin = ImageIO.createImageInputStream(in);
                    iir.setInput(iin, true);
                    Raster ras = iir.readRaster(0, null);
                    if (decodeArray != null) {
                        if ((decodeArray = Strip.removeArrayDeleminators(decodeArray).trim()).indexOf("1 0 1 0 1 0 1 0") != -1 || decodeArray.startsWith("1.0 0.0")) {
                            DataBuffer buf = ras.getDataBuffer();
                            int count = buf.getSize();
                            int ii = 0;
                            while (ii < count) {
                                buf.setElem(ii, 255 - buf.getElem(ii));
                                ++ii;
                            }
                        } else if (decodeArray.indexOf("0 1 0 1 0 1 0 1") == -1 && decodeArray.indexOf("0.0 1.0 0.0 1.0 0.0 1.0 0.0 1.0") == -1) {
                            decodeArray.length();
                        }
                    }
                    if (this.cs.getNumComponents() == 4) {
                        isProcessed = true;
                        try {
                            if (cmykType == 2) {
                                String iccFlag = System.getProperty("org.jpedal.useICC");
                                image = iccFlag != null && iccFlag.toLowerCase().equals("true") ? ColorSpaceConvertor.iccConvertCMYKImageToRGB(((DataBufferByte)ras.getDataBuffer()).getData(), w, h, false) : ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(ras.getDataBuffer(), w, h, false);
                                break block24;
                            }
                            rgbRaster = rgbModel.createCompatibleWritableRaster(w, h);
                            CSToRGB.filter(ras, rgbRaster);
                            image = new BufferedImage(w, h, 1);
                            image.setData(rgbRaster);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (cmykType != 0) {
                        image = iir.read(0);
                        isProcessed = true;
                    }
                }
                if (!isProcessed) {
                    in = new ByteArrayInputStream(data);
                    JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                    Raster currentRaster = decoder.decodeAsRaster();
                    int colorType = decoder.getJPEGDecodeParam().getEncodedColorID();
                    int width = currentRaster.getWidth();
                    int height = currentRaster.getHeight();
                    if (colorType == 4) {
                        rgbRaster = rgbModel.createCompatibleWritableRaster(width, height);
                        CSToRGB.filter(currentRaster, rgbRaster);
                        image = new BufferedImage(width, height, 1);
                        image.setData(rgbRaster);
                    } else {
                        LogWriter.writeLog("COLOR_ID_YCbCrA image");
                        in = new ByteArrayInputStream(data);
                        decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                        image = decoder.decodeAsBufferedImage();
                        image = ColorSpaceConvertor.convertToRGB(image);
                    }
                }
            }
            catch (Exception ee) {
                image = null;
                ee.printStackTrace();
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            }
            catch (Error err) {
                if (iir != null) {
                    iir.dispose();
                }
                if (iin == null) break block25;
                try {
                    iin.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return image;
    }

    protected final int getJPEGTransform(byte[] data) {
        int xform = 0;
        int i = 0;
        int imax = data.length - 2;
        block0: while (i < imax) {
            int type = data[i + 1] & 0xFF;
            i += 2;
            if (type == 1 || 208 <= type && type <= 218) continue;
            if (type == 218) {
                i = i + ((data[i] & 0xFF) << 8) + (data[i + 1] & 0xFF);
                while (true) {
                    if (i < imax) {
                        if ((data[i] & 0xFF) != 255 || data[i + 1] == 0) {
                            ++i;
                            continue;
                        }
                    }
                    int rst = data[i + 1] & 0xFF;
                    if (208 > rst || rst > 215) continue block0;
                    i += 2;
                }
            }
            if (type == 238 && data[i + 2] == 65 && data[i + 3] == 100 && data[i + 4] == 111 && data[i + 5] == 98 && data[i + 6] == 101) {
                xform = data[i + 13] & 0xFF;
                break;
            }
            i = i + ((data[i] & 0xFF) << 8) + (data[i + 1] & 0xFF);
        }
        return xform;
    }

    public void setIndex(byte[] IndexedColorMap, int size) {
        this.IndexedColorMap = IndexedColorMap;
        this.size = size;
    }

    public void setIndex(String CMap, String name, int count) {
        StringBuffer rawValues = new StringBuffer();
        this.size = count;
        if (CMap.startsWith("(\\")) {
            StringTokenizer octal_values = new StringTokenizer(CMap, "(\\)");
            while (octal_values.hasMoreTokens()) {
                int next_value = Integer.parseInt(octal_values.nextToken(), 8);
                String hex_value = Integer.toHexString(next_value);
                if (hex_value.length() < 2) {
                    rawValues.append('0');
                }
                rawValues.append(hex_value);
            }
        } else if (!CMap.startsWith("(")) {
            if (CMap.startsWith("<")) {
                CMap = CMap.substring(1, CMap.length() - 1).trim();
            }
            rawValues = new StringBuffer(CMap);
        }
        int total_components = 1;
        if (name.indexOf("RGB") != -1 | name.indexOf("ICC") != -1) {
            total_components = 3;
        } else if (name.indexOf("CMYK") != -1) {
            total_components = 4;
        }
        this.IndexedColorMap = new byte[(count + 1) * total_components];
        rawValues = Strip.stripAllSpaces(rawValues);
        int entries = 0;
        while (entries < count + 1) {
            int comp = 0;
            while (comp < total_components) {
                int p = entries * total_components * 2 + comp * 2;
                int col_value = Integer.parseInt(rawValues.substring(p, p + 2), 16);
                this.IndexedColorMap[entries * total_components + comp] = (byte)col_value;
                ++comp;
            }
            ++entries;
        }
    }

    protected int getIndexedColorComponent(int count) {
        int value = 255;
        if (this.IndexedColorMap != null && (value = this.IndexedColorMap[count]) < 0) {
            value += 256;
        }
        return value;
    }

    public byte[] getIndexedMap() {
        return this.IndexedColorMap;
    }

    public void setColor(String[] value, int operandCount) {
    }

    public void setColor(float[] value, int operandCount) {
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, String decodeArray) {
        BufferedImage image = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(data);
            if (PdfDecoder.use13jPEGConversion) {
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)bis);
                image = decoder.decodeAsBufferedImage();
                decoder = null;
            } else {
                ImageIO.setUseCache(false);
                image = ImageIO.read(bis);
            }
            if (image != null) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Problem reading JPEG: " + ee);
            ee.printStackTrace();
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] data) throws PdfException {
        BufferedImage image = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(data);
            ImageReader iir = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            try {
                iir.setInput(iin, true);
                image = iir.read(0);
                iir.dispose();
                iin.close();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            image = ColorSpaceConvertor.convertToRGB(image);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Problem reading JPEG 2000: " + ee);
            throw new PdfException("Exception with JPEG2000 image - please ensure imageio.jar (from JAI library) on classpath");
        }
        catch (Error ee2) {
            image = null;
            ee2.printStackTrace();
            LogWriter.writeLog("Problem reading JPEG 2000: " + ee2);
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (from JAI library) on classpath");
        }
        return image;
    }

    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] bands = nArray;
        DataBufferByte db = new DataBufferByte(data, data.length);
        BufferedImage image = new BufferedImage(w, h, 1);
        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    public BufferedImage BufferedImageToRGBImage(BufferedImage image) {
        return image;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(String whitepoint, String blackpoint, String range, String matrix, String gamma) {
        this.cs = ColorSpace.getInstance(1001);
        float[] R = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] B = new float[]{0.0f, 0.0f, 0.0f};
        float[] G = new float[]{1.0f, 1.0f, 1.0f};
        float[] Ma = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        if (whitepoint != null) {
            W = PdfArray.convertToFloatArray(whitepoint);
        }
        if (blackpoint != null) {
            B = PdfArray.convertToFloatArray(blackpoint);
        }
        if (range != null) {
            R = PdfArray.convertToFloatArray(range);
        }
        if (matrix != null) {
            Ma = PdfArray.convertToFloatArray(matrix);
        }
        if (gamma != null) {
            G = PdfArray.convertToFloatArray(gamma);
        }
        this.G = G;
        this.Ma = Ma;
        this.W = W;
        this.B = B;
        this.R = R;
    }

    protected final byte[] convert4Index(byte[] data) {
        return this.convertIndex(data, 4);
    }

    protected final byte[] convertIndex(byte[] data, int compCount) {
        try {
            int width = data.length / compCount;
            int height = 1;
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands4 = nArray;
            int[] nArray2 = new int[3];
            nArray2[1] = 1;
            nArray2[2] = 2;
            int[] bands3 = nArray2;
            int[] bands = compCount == 4 ? bands4 : bands3;
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * compCount, compCount, bands, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
            }
            CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, height);
            CSToRGB.filter(raster, rgbRaster);
            int size = width * height * 3;
            data = new byte[size];
            DataBuffer convertedData = rgbRaster.getDataBuffer();
            int ii = 0;
            while (ii < size) {
                data[ii] = (byte)convertedData.getElem(ii);
                ++ii;
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return data;
    }

    public byte[] convertIndexToRGB(byte[] index) {
        return index;
    }

    public String getXMLColorToken() {
        String colorToken = "";
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color col = (Color)((Object)this.currentColor);
                float c = (float)(255 - col.getRed()) / 255.0f;
                float m = (float)(255 - col.getGreen()) / 255.0f;
                float y = (float)(255 - col.getBlue()) / 255.0f;
                float k = c;
                if (k < m) {
                    k = m;
                }
                if (k < y) {
                    k = y;
                }
                colorToken = this.pantoneName == null ? "<color C='" + c + "' M='" + m + "' Y='" + y + "' K='" + k + "' >" : "<color C='" + c + "' M='" + m + "' Y='" + y + "' K='" + k + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                colorToken = "<color type='shading'>";
            }
        } else {
            colorToken = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return colorToken;
    }

    public void setPattern(Map currentPatternValues, int pageHeight) {
        this.patternValues = currentPatternValues;
        this.pageHeight = pageHeight;
    }

    public void setColor(PdfPaint col) {
        this.currentColor = col;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState currentGraphicsState) {
        this.gs = currentGraphicsState;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }
}

