/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class DeviceNColorSpace
extends SeparationColorSpace {
    public DeviceNColorSpace() {
    }

    public DeviceNColorSpace(PdfObjectReader currentPdfFile, String currentColorspace, Map colorValues) {
        this.value = 11;
        this.processColorToken(currentPdfFile, currentColorspace, colorValues);
    }

    public void setColor(String[] operand, int opCount) {
        float[] values = new float[opCount];
        int j = 0;
        while (j < opCount) {
            values[j] = Float.parseFloat(operand[j]);
            ++j;
        }
        this.setColor(values, opCount);
    }

    public void setColor(float[] raw, int opCount) {
        if (this.cmykMapping == 1 && opCount == 3) {
            float[] newOp = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            System.arraycopy(raw, 0, newOp, 0, 3);
            this.altCS.setColor(newOp, newOp.length);
        } else {
            try {
                float[] operand = this.colorMapper.getOperandFloat(raw);
                if (this.altCS instanceof DeviceCMYKColorSpace) {
                    float[] reversedOps = new float[operand.length];
                    int jj = 0;
                    while (jj < operand.length) {
                        reversedOps[jj] = operand[operand.length - jj - 1];
                        ++jj;
                    }
                    operand = reversedOps;
                }
                this.altCS.setColor(operand, operand.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image = null;
        try {
            image = this.createImage(w, h, data);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't convert DeviceN colorspace data: " + ee);
        }
        return image;
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, String decodeArray) {
        BufferedImage image = null;
        ByteArrayInputStream in = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        try {
            in = new ByteArrayInputStream(data);
            iir = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster r = iir.readRaster(0, null);
            int w = r.getWidth();
            int h = r.getHeight();
            DataBufferByte rgb = (DataBufferByte)r.getDataBuffer();
            image = this.createImage(w, h, rgb.getData());
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            ee.printStackTrace();
        }
        try {
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return image;
    }

    private BufferedImage createImage(int w, int h, byte[] rawData) {
        byte[] rgb = new byte[w * h * 3];
        int byteCount = rawData.length / this.componentCount;
        float[] values = new float[this.componentCount];
        int j = 0;
        int j2 = 0;
        int i = 0;
        while (i < byteCount) {
            if (j >= rawData.length) break;
            float value = 0.0f;
            int comp = 0;
            while (comp < this.componentCount) {
                values[this.componentCount - comp - 1] = value = (float)(rawData[j] & 0xFF) / 255.0f;
                ++j;
                ++comp;
            }
            this.setColor(values, this.componentCount);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j2] = (byte)(foreground >> 16 & 0xFF);
            rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j2 + 2] = (byte)(foreground & 0xFF);
            j2 += 3;
            ++i;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] bands = nArray;
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        BufferedImage image = new BufferedImage(w, h, 1);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w, h, w * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }
}

