/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    private static ColorSpace CMYK = null;

    private void initColorspace() {
        try {
            InputStream stream;
            String profile = System.getProperty("org.jpedal.profile");
            if (profile == null) {
                stream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    stream = new FileInputStream(profile);
                }
                catch (Exception ee) {
                    throw new PdfException("PdfException attempting to use user profile " + profile + " Message=" + ee);
                }
            }
            ICC_Profile p = ICC_Profile.getInstance(stream);
            CMYK = new ICC_ColorSpace(p);
            stream.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e);
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.value = 3;
    }

    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        int ii = 0;
        while (ii < items) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
            ++ii;
        }
        this.setColor(colValues, items);
    }

    public final void setColor(float[] operand, int length) {
        boolean newVersion = true;
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (length > 3) {
            this.c = operand[3];
            this.m = operand[2];
            this.y = operand[1];
            this.k = operand[0];
        } else {
            if (length > 3) {
                this.c = operand[3];
            }
            if (length > 2) {
                this.m = operand[2];
            }
            if (length > 1) {
                this.y = operand[1];
            }
            if (length > 0) {
                this.k = operand[0];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            if (!newVersion) {
                float b;
                float g;
                float r = this.c + this.k;
                if (r > 1.0f) {
                    r = 1.0f;
                }
                if ((g = this.m + this.k) > 1.0f) {
                    g = 1.0f;
                }
                if ((b = this.y + this.k) > 1.0f) {
                    b = 1.0f;
                }
                this.currentColor = new PdfColor((int)(255.0f * (1.0f - r)), (int)(255.0f * (1.0f - g)), (int)(255.0f * (1.0f - b)));
            } else if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] cmykValues = new float[]{this.c, this.m, this.y, this.k};
                float[] rgb = CMYK.toRGB(cmykValues);
                int jj = 0;
                while (jj < 3) {
                    if ((double)rgb[jj] > 0.99) {
                        rgb[jj] = 1.0f;
                    } else if ((double)rgb[jj] < 0.01) {
                        rgb[jj] = 0.0f;
                    }
                    ++jj;
                }
                this.currentColor = new PdfColor(rgb[0], rgb[1], rgb[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    public final BufferedImage JPEGToRGBImage(byte[] data, int w, int h, String decodeArray) {
        return this.nonRGBJPEGToRGBImage(data, w, h, decodeArray);
    }

    public final byte[] convertIndexToRGB(byte[] index) {
        return this.convert4Index(index);
    }
}

