/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class CalRGBColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4569336292751894930L;
    private int r;
    private int g;
    private int b;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(String whitepoint, String blackpoint, String matrix, String gamma) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(whitepoint, blackpoint, null, matrix, gamma);
        this.value = 5;
    }

    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image = null;
        DataBufferByte db = new DataBufferByte(data, data.length);
        int size = width * height;
        try {
            int i = 0;
            while (i < size * 3) {
                float cl = data[i] & 0xFF;
                float ca = data[i + 1] & 0xFF;
                float cb = data[i + 2] & 0xFF;
                this.convertToRGB(cl, ca, cb);
                ((DataBuffer)db).setElem(i, this.r);
                ((DataBuffer)db).setElem(i + 1, this.g);
                ((DataBuffer)db).setElem(i + 2, this.b);
                i += 3;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] bands = nArray;
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
            image.setData(raster);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        int ii = 0;
        while (ii < items) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
            ++ii;
        }
        this.setColor(colValues, items);
    }

    public final void setColor(float[] number_values, int items) {
        float[] A = new float[]{1.0f, 1.0f, 1.0f};
        if (items == 3) {
            int i = 0;
            while (i < items) {
                A[i] = number_values[2 - i];
                if (A[i] > 1.0f) {
                    return;
                }
                ++i;
            }
        }
        this.convertToRGB(A[0], A[1], A[2]);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    private final void convertToRGB(float C, float I, float E) {
        if (this.lastC != C || this.lastI != I || this.lastE != E) {
            this.r = (int)(C * 255.0f);
            this.g = (int)(I * 255.0f);
            this.b = (int)(E * 255.0f);
            this.lastC = C;
            this.lastI = I;
            this.lastE = E;
        }
    }

    public BufferedImage JPEGToRGBImageXXX(byte[] data, int w, int h, String decodeArray) {
        BufferedImage image = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(data);
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
            Raster currentRaster = decoder.decodeAsRaster();
            int width = currentRaster.getWidth();
            int height = currentRaster.getHeight();
            int imgSize = width * height;
            DataBuffer db = currentRaster.getDataBuffer();
            int i = 0;
            while (i < imgSize * 3) {
                float cl = db.getElemFloat(i) / 255.0f;
                float ca = db.getElemFloat(i + 1) / 255.0f;
                float cb = db.getElemFloat(i + 2) / 255.0f;
                this.convertToRGB(cl, ca, cb);
                db.setElem(i, this.r);
                db.setElem(i + 1, this.g);
                db.setElem(i + 2, this.b);
                i += 3;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] bands = nArray;
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
            image.setData(raster);
            in.close();
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
        }
        return image;
    }

    public final byte[] convertIndexToRGB(byte[] index) {
        return index;
    }
}

