/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class AbstractTag
extends AbstractComponent
implements DynamicPropertied,
RawId {
    protected String _tagnm;
    private Map _props;
    private static final EventInfo[] _evts = new EventInfo[]{new EventInfo("onClick", "z.lfclk", false), new EventInfo("onChange", "z.onChange", true)};

    protected AbstractTag(String tagname) {
        if (tagname == null || tagname.length() == 0) {
            throw new IllegalArgumentException("A tag name is required");
        }
        this._tagnm = tagname;
    }

    protected AbstractTag() {
    }

    public String getSclass() {
        return (String)this.getDynamicProperty("class");
    }

    public void setSclass(String sclass) {
        this.setDynamicProperty("class", sclass);
    }

    public String getStyle() {
        return (String)this.getDynamicProperty("style");
    }

    public void setStyle(String style) {
        this.setDynamicProperty("style", style);
    }

    public String getTag() {
        return this._tagnm;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute((String)name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name is required");
        }
        if (!this.hasDynamicProperty(name)) {
            throw new WrongValueException("Attribute not allowed: " + name + "\nSpecify the ZK namespace if you want to use special ZK attributes");
        }
        String sval = Objects.toString((Object)value);
        if ("style".equals(name)) {
            sval = this.filterStyle(sval);
        }
        this.setDynaProp(name, sval);
        this.smartUpdate(name, sval);
    }

    private String filterStyle(String style) {
        int j;
        if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0) {
            super.setVisible(!"none".equals(HTMLs.getSubstyleValue((String)style, (int)j)));
            return style;
        }
        if (!this.isVisible()) {
            int len;
            int n = len = style != null ? style.length() : 0;
            if (len == 0) {
                return "display:none;";
            }
            if (style.charAt(len - 1) != ';') {
                style = style + ';';
            }
            style = style + "display:none;";
        }
        return style;
    }

    private void setDynaProp(String name, String value) {
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap();
            }
            this._props.put(name, value);
        }
    }

    protected boolean shallHideId() {
        return false;
    }

    public boolean setVisible(boolean visible) {
        boolean old = super.setVisible(visible);
        if (old != visible) {
            String style = (String)this.getDynamicProperty("style");
            if (visible) {
                String val;
                int j;
                if (style != null && (j = HTMLs.getSubstyleIndex((String)style, (String)"display")) >= 0 && "none".equals(val = HTMLs.getSubstyleValue((String)style, (int)j))) {
                    String newstyle = style.substring(0, j);
                    int k = style.indexOf(59, j + 7);
                    if (k >= 0) {
                        newstyle = newstyle + style.substring(k + 1);
                    }
                    this.setDynaProp("style", newstyle);
                }
            } else if (style == null) {
                this.setDynaProp("style", "display:none;");
            } else {
                int j = HTMLs.getSubstyleIndex((String)style, (String)"display");
                if (j >= 0) {
                    String val = HTMLs.getSubstyleValue((String)style, (int)j);
                    if (!"none".equals(val)) {
                        String newstyle = style.substring(0, j) + "display:none;";
                        int k = style.indexOf(59, j + 7);
                        if (k >= 0) {
                            newstyle = newstyle + style.substring(k + 1);
                        }
                        this.setDynaProp("style", newstyle);
                    }
                } else {
                    int len = style.length();
                    String newstyle = len > 0 && style.charAt(len - 1) != ';' ? style + ';' : style;
                    this.setDynaProp("style", style + "display:none;");
                }
            }
        }
        return old;
    }

    public boolean addEventListener(String evtnm, EventListener listener) {
        int j = 0;
        while (true) {
            if (j >= _evts.length) {
                throw new UiException("Not supported event: " + evtnm);
            }
            if (_evts[j].name.equals(evtnm)) break;
            ++j;
        }
        EventInfo ei = _evts[j];
        boolean bAddType = ei.typed && !this.isTypeDeclared();
        boolean ret = super.addEventListener(evtnm, listener);
        if (ret) {
            this.smartUpdate(ei.attr, Events.isListened((Component)this, (String)evtnm, (boolean)true) ? "true" : null);
            if (bAddType && this.isTypeDeclared()) {
                this.smartUpdate("z.type", "zhtml.main.Raw");
                this.smartUpdate("z.init", true);
            }
        }
        return ret;
    }

    private boolean isTypeDeclared() {
        for (int j = 0; j < _evts.length; ++j) {
            if (!_evts[j].typed || !Events.isListened((Component)this, (String)_evts[j].name, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public void redraw(Writer out) throws IOException {
        if (this._tagnm == null) {
            throw new UiException("The tag name is not initialized yet");
        }
        out.write(60);
        out.write(this._tagnm);
        boolean typeDeclared = false;
        for (int j = 0; j < _evts.length; ++j) {
            if (!Events.isListened((Component)this, (String)_evts[j].name, (boolean)true)) continue;
            if (_evts[j].typed) {
                typeDeclared = true;
            }
            out.write(32);
            out.write(_evts[j].attr);
            out.write("=\"true\"");
        }
        if (typeDeclared) {
            out.write(" z.type=\"zhtml.main.Raw\"");
        }
        if (typeDeclared || !this.shallHideId() || !Components.isAutoId((String)this.getUuid())) {
            out.write(" id=\"");
            out.write(this.getUuid());
            out.write(34);
        }
        if (this._props != null) {
            Iterator it = this._props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String key = (String)me.getKey();
                String val = (String)me.getValue();
                out.write(32);
                out.write(key);
                out.write("=\"");
                out.write(XMLs.encodeAttribute((String)val));
                out.write(34);
            }
        }
        if (this.isChildable()) {
            boolean divGened = false;
            if ("body".equals(this._tagnm)) {
                if (this._props != null && this._props.containsKey("class")) {
                    out.write("><div class=\"zk\">\n");
                    divGened = true;
                } else {
                    out.write(" class=\"zk\">\n");
                }
            } else {
                out.write(62);
            }
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                ((Component)it.next()).redraw(out);
            }
            if (divGened) {
                out.write("\n</div>");
            }
            out.write("</");
            out.write(this._tagnm);
            out.write(62);
        } else {
            out.write("/>");
        }
    }

    public boolean isChildable() {
        return !HTMLs.isOrphanTag((String)this._tagnm);
    }

    public Object clone() {
        AbstractTag clone = (AbstractTag)((Object)super.clone());
        if (clone._props != null) {
            clone._props = new LinkedHashMap(clone._props);
        }
        return clone;
    }

    public String toString() {
        return "[" + this._tagnm + ' ' + super.toString() + ']';
    }

    private static class EventInfo {
        private final String name;
        private final String attr;
        private final boolean typed;

        private EventInfo(String name, String attr, boolean typed) {
            this.name = name;
            this.attr = attr;
            this.typed = typed;
        }
    }
}

