/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;

public class Text
extends AbstractComponent
implements RawId {
    private String _value = "";

    public Text() {
    }

    public Text(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.invalidate();
        }
    }

    private boolean isIdRequired() {
        Component p = this.getParent();
        return p == null || !this.isVisible() || !Components.isAutoId((String)this.getId()) || !Text.isRawLabel(p);
    }

    private static boolean isRawLabel(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    public void setParent(Component parent) {
        Component old;
        if (!this.isIdRequired() && (old = this.getParent()) != parent) {
            if (old != null) {
                old.invalidate();
            }
            if (parent != null) {
                parent.invalidate();
            }
        }
        super.setParent(parent);
    }

    public void invalidate() {
        if (this.isIdRequired()) {
            super.invalidate();
        } else {
            this.getParent().invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        boolean idRequired = this.isIdRequired();
        if (idRequired) {
            out.write("<span id=\"");
            out.write(this.getUuid());
            out.write("\">");
        }
        out.write(this._value);
        if (idRequired) {
            out.write("</span>");
        }
    }

    public boolean isChildable() {
        return false;
    }
}

