/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Gmaps;
import org.zkoss.gmaps.event.MapTypeChangeEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class MapTypeChangeCommand
extends Command {
    public MapTypeChangeCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 1) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Gmaps gmaps = (Gmaps)comp;
        String type = data[0];
        gmaps.setMapTypeByClient(type);
        Events.postEvent((Event)new MapTypeChangeEvent(this.getId(), comp, type));
    }
}

