/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.event.MapDropEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.au.in.Commands;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

class MapDropCommand
extends Command {
    public MapDropCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 8) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Component dragged = data[0] != null ? comp.getDesktop().getComponentByUuidIfAny(data[0]) : null;
        double lat = Double.parseDouble(data[1]);
        double lng = Double.parseDouble(data[2]);
        int x = (int)Math.round(Double.parseDouble(data[3]));
        int y = (int)Math.round(Double.parseDouble(data[4]));
        int clientX = (int)Math.round(Double.parseDouble(data[5]));
        int clientY = (int)Math.round(Double.parseDouble(data[6]));
        Events.postEvent((Event)new MapDropEvent(this.getId(), comp, dragged, lat, lng, x, y, clientX, clientY, Commands.parseKeys((String)data[7])));
    }
}

