/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.zk.ui.UiException;

public class GmapsUtil {
    public static int[] latlngToXy(double lat, double lng, int zoomLevel) {
        if (lat > 90.0 || lat < -90.0) {
            throw new UiException("latitude must be in the range of -90 degree ~ 90 degree");
        }
        if (lng > 180.0 || lng < -180.0) {
            throw new UiException("longitude must be in the range of -180 degree ~ 180 degree");
        }
        if (lat > 89.2) {
            lat = 89.2;
        } else if (lat < -89.2) {
            lat = -89.2;
        }
        int[] out = new int[2];
        int base = 256 << zoomLevel;
        int zero = base >> 1;
        out[0] = (int)((double)base * lng / 360.0) + zero;
        out[1] = zero - (int)Math.round(Math.log(Math.tan(0.7853981633974483 + 0.5 * lat * Math.PI / 180.0)) * (double)zero / Math.PI);
        return out;
    }

    public static double[] xyToLatlng(int x, int y, int zoomLevel) {
        int base = 256 << zoomLevel;
        int zero = base >> 1;
        double[] out = new double[2];
        out[1] = (double)(x - zero) * 360.0 / (double)base;
        if (out[1] > 180.0) {
            out[1] = out[1] - 360.0;
        } else if (out[1] < -180.0) {
            out[1] = out[1] + 360.0;
        }
        out[0] = Math.atan(Math.exp((double)(zero - y) * Math.PI / (double)zero)) * 360.0 / Math.PI - 90.0;
        return out;
    }

    public static double[] getBounds(double lat, double lng, int width, int height, int zoomLevel) {
        int eastx;
        int base = 256 << zoomLevel;
        int[] centerxy = GmapsUtil.latlngToXy(lat, lng, zoomLevel);
        int westx = centerxy[0] - width / 2;
        if (westx < 0) {
            westx = 0;
        }
        if ((eastx = westx + width) > base) {
            eastx = base;
        }
        int northy = centerxy[1] - height / 2;
        int southy = northy + height;
        double[] sw = GmapsUtil.xyToLatlng(westx, southy, zoomLevel);
        double[] ne = GmapsUtil.xyToLatlng(eastx, northy, zoomLevel);
        double[] out = new double[]{sw[0], sw[1], ne[0], ne[1]};
        return out;
    }
}

