/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.gmaps.Ginfo;
import org.zkoss.gmaps.GmapsUtil;
import org.zkoss.gmaps.InfoChangeCommand;
import org.zkoss.gmaps.MapClickCommand;
import org.zkoss.gmaps.MapDoubleClickCommand;
import org.zkoss.gmaps.MapDropCommand;
import org.zkoss.gmaps.MapModel;
import org.zkoss.gmaps.MapMoveCommand;
import org.zkoss.gmaps.MapOpenCommand;
import org.zkoss.gmaps.MapRightClickCommand;
import org.zkoss.gmaps.MapTypeChangeCommand;
import org.zkoss.gmaps.MapZoomCommand;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.gmaps.MapitemRenderer;
import org.zkoss.gmaps.MarkerDropCommand;
import org.zkoss.gmaps.event.MapDataEvent;
import org.zkoss.gmaps.event.MapDataListener;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zul.impl.XulElement;

public class Gmaps
extends XulElement {
    private static final long serialVersionUID = 200807040842L;
    private transient Ginfo _oneinfo;
    private transient Ginfo _info;
    private double _lat = 37.4419;
    private double _lng = -122.1419;
    private int _zoom = 13;
    private boolean _large;
    private boolean _small;
    private boolean _type;
    private boolean _smallZoom;
    private boolean _scale;
    private boolean _overview;
    private boolean _normal = true;
    private boolean _satellite = true;
    private boolean _hybrid = true;
    private boolean _physical;
    private String _mapType = "normal";
    private boolean _enableDragging = true;
    private boolean _continuousZoom;
    private boolean _doubleClickZoom;
    private boolean _scrollWheelZoom;
    private boolean _enableGoogleBar;
    private double _swlat = 37.41802693231111;
    private double _swlng = -122.1933746338;
    private double _nelat = 37.4657298516;
    private double _nelng = -122.0903778076;
    private MapModel _model;
    private MapitemRenderer _renderer;
    private MapDataListener _dataListener;
    private EventListener _moveListener;
    private Map _dataMap = new HashMap(64);
    private Component _selected;

    public void setCenter(double lat, double lng) {
        boolean update = false;
        if (lat != this._lat) {
            this._lat = lat;
            update = true;
        }
        if (lng != this._lng) {
            this._lng = lng;
            update = true;
        }
        if (update) {
            this.smartUpdate("z.center", this.getCenter());
        }
    }

    public void setLat(double lat) {
        if (lat != this._lat) {
            this._lat = lat;
            this.smartUpdate("z.center", this.getCenter());
        }
    }

    public double getLat() {
        return this._lat;
    }

    public void setLng(double lng) {
        if (lng != this._lng) {
            this._lng = lng;
            this.smartUpdate("z.center", this.getCenter());
        }
    }

    public double getLng() {
        return this._lng;
    }

    private String getCenter() {
        return "" + this._lat + "," + this._lng;
    }

    public double getSwLat() {
        return this._swlat;
    }

    public double getSwLng() {
        return this._swlng;
    }

    public double getNeLat() {
        return this._nelat;
    }

    public double getNeLng() {
        return this._nelng;
    }

    public void panTo(double lat, double lng) {
        boolean update = false;
        if (lat != this._lat) {
            this._lat = lat;
            update = true;
        }
        if (lng != this._lng) {
            this._lng = lng;
            update = true;
        }
        if (update) {
            this.smartUpdate("z.panTo", this.getCenter());
        }
    }

    public void setZoom(int zoom) {
        if (zoom != this._zoom) {
            this._zoom = zoom;
            this.smartUpdate("z.zoom", "" + this._zoom);
        }
    }

    public int getZoom() {
        return this._zoom;
    }

    public void setShowLargeCtrl(boolean b) {
        if (this._large == b) {
            return;
        }
        this._large = b;
        if (b) {
            this.setShowSmallCtrl(false);
            this.setShowZoomCtrl(false);
        }
        this.smartUpdate("z.lctrl", "" + b);
    }

    public boolean isShowLargeCtrl() {
        return this._large;
    }

    public void setShowSmallCtrl(boolean b) {
        if (this._small == b) {
            return;
        }
        this._small = b;
        if (b) {
            this.setShowLargeCtrl(false);
            this.setShowZoomCtrl(false);
        }
        this.smartUpdate("z.sctrl", "" + b);
    }

    public boolean isShowSmallCtrl() {
        return this._small;
    }

    public void setShowZoomCtrl(boolean b) {
        if (this._smallZoom == b) {
            return;
        }
        this._smallZoom = b;
        if (b) {
            this.setShowLargeCtrl(false);
            this.setShowSmallCtrl(false);
        }
        this.smartUpdate("z.zctrl", "" + b);
    }

    public boolean isShowZoomCtrl() {
        return this._smallZoom;
    }

    public void setShowTypeCtrl(boolean b) {
        if (this._type == b) {
            return;
        }
        this._type = b;
        this.smartUpdate("z.tctrl", "" + b);
    }

    public boolean isShowTypeCtrl() {
        return this._type;
    }

    public void setShowScaleCtrl(boolean b) {
        if (this._scale == b) {
            return;
        }
        this._scale = b;
        this.smartUpdate("z.cctrl", "" + b);
    }

    public boolean isShowScaleCtrl() {
        return this._scale;
    }

    public void setShowOverviewCtrl(boolean b) {
        if (this._overview == b) {
            return;
        }
        this._overview = b;
        this.smartUpdate("z.octrl", "" + b);
    }

    public boolean isShowOverviewCtrl() {
        return this._overview;
    }

    public void setNormal(boolean b) {
        if (this._normal != b) {
            if (!b && "normal".equals(this._mapType)) {
                if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._normal = b;
            this.smartUpdate("z.nmap", b);
        }
    }

    public boolean isNormal() {
        return this._normal;
    }

    public void setSatellite(boolean b) {
        if (this._satellite != b) {
            if (!b && "satellite".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._satellite = b;
            this.smartUpdate("z.smap", b);
        }
    }

    public boolean isSatellite() {
        return this._satellite;
    }

    public void setHybrid(boolean b) {
        if (this._hybrid != b) {
            if (!b && "hybrid".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else if (this.isPhysical()) {
                    this.setMapType("physical");
                } else {
                    return;
                }
            }
            this._hybrid = b;
            this.smartUpdate("z.hmap", b);
        }
    }

    public boolean isHybrid() {
        return this._hybrid;
    }

    public void setPhysical(boolean b) {
        if (this._physical != b) {
            if (!b && "physical".equals(this._mapType)) {
                if (this.isNormal()) {
                    this.setMapType("normal");
                } else if (this.isHybrid()) {
                    this.setMapType("hybrid");
                } else if (this.isSatellite()) {
                    this.setMapType("satellite");
                } else {
                    return;
                }
            }
            this._physical = b;
            this.smartUpdate("z.pmap", b);
        }
    }

    public boolean isPhysical() {
        return this._physical;
    }

    public String getMapType() {
        return this._mapType;
    }

    public void setMapType(String mapType) {
        if ("normal".equals(mapType)) {
            this.setNormal(true);
        } else if ("satellite".equals(mapType)) {
            this.setSatellite(true);
        } else if ("hybrid".equals(mapType)) {
            this.setHybrid(true);
        } else if ("physical".equals(mapType)) {
            this.setPhysical(true);
        }
        this._mapType = mapType;
        this.smartUpdate("z.mt", mapType);
    }

    public void setEnableDragging(boolean b) {
        if (this._enableDragging != b) {
            this._enableDragging = b;
            this.smartUpdate("z.dg", "" + b);
        }
    }

    public boolean isEnableDragging() {
        return this._enableDragging;
    }

    public void setContinuousZoom(boolean b) {
        if (this._continuousZoom != b) {
            this._continuousZoom = b;
            this.smartUpdate("z.cz", "" + b);
        }
    }

    public boolean isContinuousZoom() {
        return this._continuousZoom;
    }

    public void setDoubleClickZoom(boolean b) {
        if (this._doubleClickZoom != b) {
            this._doubleClickZoom = b;
            this.smartUpdate("z.dz", "" + b);
        }
    }

    public boolean isDoubleClickZoom() {
        return this._doubleClickZoom;
    }

    public void setScrollWheelZoom(boolean b) {
        if (this._scrollWheelZoom != b) {
            this._scrollWheelZoom = b;
            this.smartUpdate("z.wz", "" + b);
        }
    }

    public boolean isScrollWheelZoom() {
        return this._scrollWheelZoom;
    }

    public void setEnableGoogleBar(boolean b) {
        if (this._enableGoogleBar != b) {
            this._enableGoogleBar = b;
            this.smartUpdate("z.gb", "" + b);
        }
    }

    public boolean isEnableGoogleBar() {
        return this._enableGoogleBar;
    }

    public void openInfo(Ginfo info) {
        if (info != null) {
            if (info != this._info) {
                if (info.getParent() != this) {
                    throw new UiException("The to be opened Ginfo or Gmarker must be child of this Gmaps!");
                }
                if (this._info != null) {
                    this._info.setOpenByClient(false);
                }
                this._info = info;
                this.smartUpdate("z.open", info.getUuid());
            }
        } else {
            this.closeInfo();
        }
    }

    public void closeInfo() {
        if (this._info != null) {
            this._info = null;
            this.smartUpdate("z.close", "");
        }
    }

    public Ginfo getInfo() {
        return this._info;
    }

    public MapModel getModel() {
        return this._model;
    }

    public void setModel(MapModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeMapDataListener(this._dataListener);
                } else {
                    this.smartUpdate("z.onMapMove", "true");
                }
                this._model = model;
                this.initMapDataListener();
            }
            this.addOnMapMove();
            this.syncModel();
        } else {
            this.onMapDataChange(new MapDataEvent(this._model, 4, null));
            this._model.removeMapDataListener(this._dataListener);
            this.removeOnMapMove();
            this._model = null;
            if (!Events.isListened((Component)this, (String)"onMapMove", (boolean)true)) {
                this.smartUpdate("z.onMapMove", null);
            }
        }
    }

    private void addOnMapMove() {
        if (this._moveListener == null) {
            this._moveListener = new UpdateBoundsListener();
            this.addEventListener("onMapMove", this._moveListener);
        }
    }

    private void removeOnMapMove() {
        if (this._moveListener != null) {
            this.removeEventListener("onMapMove", this._moveListener);
        }
    }

    private void syncModel() {
        if (this._swlat == 37.41802693231111) {
            this.initBounds();
        }
        if (this._model != null) {
            this.onMapDataChange(new MapDataEvent(this._model, 3, this._model.getItemsIn(this._swlat, this._swlng, this._nelat, this._nelng, this._lat, this._lng, this._zoom)));
        }
    }

    private void initMapDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new MapDataListener(){

                public void onChange(MapDataEvent event) {
                    Gmaps.this.onMapDataChange(event);
                }
            };
        }
        this._model.addMapDataListener(this._dataListener);
    }

    private void onMapDataChange(MapDataEvent event) {
        Ginfo info = null;
        switch (event.getType()) {
            case 1: {
                MapitemRenderer renderer = this.getRealRenderer();
                Iterator it = event.getItems().iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    Mapitem mitem = renderer.newMapitem(data);
                    if (info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen()) {
                        info = (Ginfo)mitem;
                    }
                    this._dataMap.put(data, mitem);
                    this.appendChild(mitem);
                }
                break;
            }
            case 2: {
                Iterator it = event.getItems().iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    Mapitem mitem = (Mapitem)this._dataMap.remove(data);
                    if (mitem == null) continue;
                    this.removeChild(mitem);
                }
                break;
            }
            case 0: {
                MapitemRenderer renderer = this.getRealRenderer();
                Collection items = event.getItems();
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    Object data = it.next();
                    if (!this._dataMap.containsKey(data)) continue;
                    Mapitem mitem = (Mapitem)this._dataMap.remove(data);
                    boolean isopen = info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen();
                    this.removeChild(mitem);
                    Mapitem nitem = renderer.newMapitem(data);
                    if (isopen) {
                        info = (Ginfo)nitem;
                    }
                    this._dataMap.put(data, nitem);
                    this.appendChild(nitem);
                }
                break;
            }
            case 3: {
                MapitemRenderer renderer = this.getRealRenderer();
                Collection items = event.getItems();
                Iterator it = this._dataMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object data = entry.getKey();
                    Mapitem mitem = (Mapitem)entry.getValue();
                    if (items.contains(data)) continue;
                    it.remove();
                    this.removeChild(mitem);
                }
                it = items.iterator();
                while (it.hasNext()) {
                    Map.Entry data = it.next();
                    if (this._dataMap.containsKey(data)) continue;
                    Mapitem mitem = renderer.newMapitem(data);
                    if (info == null && mitem instanceof Ginfo && ((Ginfo)mitem).isOpen()) {
                        info = (Ginfo)mitem;
                    }
                    this._dataMap.put(data, mitem);
                    this.appendChild(mitem);
                }
                break;
            }
            case 4: {
                Iterator it = this._dataMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Mapitem mitem = (Mapitem)entry.getValue();
                    this.removeChild(mitem);
                }
                this._dataMap.clear();
            }
        }
        if (info != null && info != this._info) {
            this.openInfo(info);
        }
    }

    private MapitemRenderer getRealRenderer() {
        return this._renderer == null ? new MapitemRenderer(){

            public Mapitem newMapitem(Object data) {
                return (Mapitem)data;
            }
        } : this._renderer;
    }

    public MapitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(MapitemRenderer renderer) {
        this._renderer = renderer;
    }

    public void setSelectedItem(Component item) {
        if (item == null) {
            this._selected = null;
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + item);
            }
            this._selected = item;
        }
    }

    public Component getSelectedItem() {
        return this._selected;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        StringBuffer sb = new StringBuffer(64);
        if (attrs != null) {
            sb.append(attrs);
        }
        if (Events.isListened((Component)this, (String)"onMapMove", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapMove", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onMapZoom", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapZoom", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onInfoChange", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onInfoChange", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onMapClick", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapClick", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onMapDoubleClick", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapDoubleClick", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onSelect", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onSelect", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onMapRightClick", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapRightClick", (String)"true");
        }
        if (Events.isListened((Component)this, (String)"onMapTypeChange", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMapTypeChange", (String)"true");
        }
        StringBuffer ctrls = new StringBuffer(3);
        if (this.isShowLargeCtrl()) {
            ctrls.append("l");
        }
        if (this.isShowSmallCtrl()) {
            ctrls.append("s");
        }
        if (this.isShowZoomCtrl()) {
            ctrls.append("z");
        }
        if (this.isShowTypeCtrl()) {
            ctrls.append("t");
        }
        if (this.isShowScaleCtrl()) {
            ctrls.append("c");
        }
        if (this.isShowOverviewCtrl()) {
            ctrls.append("o");
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.init", (String)(this.getCenter() + "," + this._zoom + (ctrls.length() == 0 ? "" : "," + ctrls)));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.mt", (String)this.getMapType());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dg", (boolean)this.isEnableDragging());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cz", (boolean)this.isContinuousZoom());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dz", (boolean)this.isDoubleClickZoom());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.wz", (boolean)this.isScrollWheelZoom());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.gb", (boolean)this.isEnableGoogleBar());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.smap", (boolean)this.isSatellite());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.hmap", (boolean)this.isHybrid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pmap", (boolean)this.isPhysical());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.nmap", (boolean)this.isNormal());
        return sb.toString();
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Mapitem)) {
            throw new UiException("Only Mapitem such as Ginfo, Gmarker, Gpolyline, Gpolygon, Gimage, Gscreen is allowed to be child of Gmaps: " + (Object)((Object)this) + ", " + child);
        }
        if (this.isGinfo(child)) {
            if (this._oneinfo != null && this._oneinfo != child) {
                throw new UiException("Only one Ginfo is allowed: " + (Object)((Object)this));
            }
            this._oneinfo = (Ginfo)child;
        }
        boolean ret = super.insertBefore(child, insertBefore);
        if (child instanceof Ginfo && ((Ginfo)child).isOpen()) {
            this.openInfo((Ginfo)child);
        }
        return ret;
    }

    public void onChildRemoved(Component child) {
        if (this.isGinfo(child)) {
            this._oneinfo = null;
        }
        if (child == this._info) {
            this._info.setOpenByClient(false);
            this._info = null;
        }
        super.onChildRemoved(child);
    }

    private boolean isGinfo(Component comp) {
        return comp instanceof Ginfo && ((Ginfo)comp).isGinfo();
    }

    public Object clone() {
        Gmaps clone = (Gmaps)((Object)super.clone());
        if (clone._oneinfo != null || clone._info != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (this.isGinfo((Component)child)) {
                this._oneinfo = (Ginfo)child;
            }
            if (this._info == null || ((Component)child).getId() != this._info.getId()) continue;
            this._info = (Ginfo)child;
            break;
        }
    }

    void setCenterByClient(double lat, double lng) {
        this._lat = lat;
        this._lng = lng;
    }

    void setZoomByClient(int zoom) {
        this._zoom = zoom;
    }

    void setMapTypeByClient(String type) {
        this._mapType = type;
    }

    void setInfoByClient(Ginfo info) {
        if (info == null && this._info != null) {
            this._info.setOpenByClient(false);
        }
        this._info = info;
    }

    void setBoundsByClient(double swlat, double swlng, double nelat, double nelng) {
        this._swlat = swlat;
        this._swlng = swlng;
        this._nelat = nelat;
        this._nelng = nelng;
    }

    private int width(String width) {
        if ((width = width.trim()).endsWith("%")) {
            return 1280;
        }
        return this.stringToInt(width);
    }

    private int height(String height) {
        if (height.endsWith("%")) {
            return 1024;
        }
        return this.stringToInt(height);
    }

    private int stringToInt(String str) {
        if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else {
            if (str.endsWith("pt")) {
                str = str.substring(0, str.length() - 2);
                return (int)((double)Integer.parseInt(str) * 1.3333);
            }
            if (str.endsWith("em")) {
                str = str.substring(0, str.length() - 2);
                return (int)((double)Integer.parseInt(str) * 13.3333);
            }
        }
        return Integer.parseInt(str);
    }

    private void initBounds() {
        double[] bounds = GmapsUtil.getBounds(this._lat, this._lng, this.width(this.getWidth()), this.height(this.getHeight()), this._zoom);
        this._swlat = bounds[0];
        this._swlng = bounds[1];
        this._nelat = bounds[2];
        this._nelng = bounds[3];
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        new MapMoveCommand("onMapMove", 8);
        new MapZoomCommand("onMapZoom", 8);
        new InfoChangeCommand("onInfoChange", 8);
        new MapClickCommand("onMapClick", 8);
        new MapDoubleClickCommand("onMapDoubleClick", 8);
        new MapRightClickCommand("onMapRightClick", 8);
        new MarkerDropCommand("onMarkerDrop", 8);
        new MapDropCommand("onMapDrop", 8);
        new MapOpenCommand("onMapOpen", 8);
        new MapTypeChangeCommand("onMapTypeChange", 8);
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Selectable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Gmaps.this);
        }

        public void selectItemsByClient(Set selItems) {
            Component mitem = selItems == null || selItems.isEmpty() ? null : (Component)selItems.iterator().next();
            Gmaps.this.setSelectedItem(mitem);
        }

        public void clearSelectionByClient() {
        }
    }

    private class UpdateBoundsListener
    implements EventListener,
    Express,
    Serializable {
        private static final long serialVersionUID = 200808261207L;

        private UpdateBoundsListener() {
        }

        public void onEvent(Event evt) {
            Gmaps.this.syncModel();
        }
    }
}

