/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Mapitem;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;

public class Gimage
extends HtmlBasedComponent
implements Mapitem {
    protected double _swlat = 37.4419;
    protected double _swlng = -122.1419;
    protected double _nelat = 37.4419;
    protected double _nelng = -122.1419;
    private String _src;
    private Image _image;
    private int _imgver;

    public Gimage() {
    }

    public Gimage(String src, double swlat, double swlng, double nelat, double nelng) {
        this.setSrc(src);
        this.setSwlat(swlat);
        this.setSwlng(swlng);
        this.setNelat(nelat);
        this.setNelng(nelng);
    }

    public double getSwlat() {
        return this._swlat;
    }

    public void setSwlat(double swlat) {
        if (this._swlat != swlat) {
            this._swlat = swlat;
            this.invalidate();
        }
    }

    public double getSwlng() {
        return this._swlng;
    }

    public void setSwlng(double swlng) {
        if (this._swlng != swlng) {
            this._swlng = swlng;
            this.invalidate();
        }
    }

    public double getNelat() {
        return this._nelat;
    }

    public void setNelat(double nelat) {
        if (this._nelat != nelat) {
            this._nelat = nelat;
            this.invalidate();
        }
    }

    public double getNelng() {
        return this._nelng;
    }

    public void setNelng(double nelng) {
        if (this._nelng != nelng) {
            this._nelng = nelng;
            this.invalidate();
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._image == null) {
                this.invalidate();
            }
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._image != null ? this.getContentSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "");
    }

    public void setContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.invalidate();
        }
    }

    public Image getContent() {
        return this._image;
    }

    private String getContentSrc() {
        return Gimage.getDynamicMediaURI((AbstractComponent)this, this._imgver, this._image.getName(), this._image.getFormat());
    }

    static String getDynamicMediaURI(AbstractComponent comp, int version, String name, String format) {
        Desktop desktop = comp.getDesktop();
        if (desktop == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64).append('/');
        Strings.encode((StringBuffer)sb, (int)version);
        if (name != null || format != null) {
            sb.append('/');
            boolean bExtRequired = true;
            if (name != null && name.length() != 0) {
                sb.append(name.replace('\\', '/'));
                bExtRequired = name.lastIndexOf(46) < 0;
            } else {
                sb.append(comp.getId());
            }
            if (bExtRequired && format != null) {
                sb.append('.').append(format);
            }
        }
        return desktop.getDynamicMediaURI((Component)comp, sb.toString());
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        StringBuffer sb = new StringBuffer(128);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.src", (String)this.getEncodedSrc());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.swlat", (String)("" + this.getSwlat()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.swlng", (String)("" + this.getSwlng()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.nelat", (String)("" + this.getNelat()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.nelng", (String)("" + this.getNelng()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }
}

