/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.GenericComposer;

public abstract class GenericAutowireComposer
extends GenericComposer
implements ComponentCloneListener {
    private static final long serialVersionUID = 20091006115726L;
    private static final String COMPOSER_CLONE = "COMPOSER_CLONE";
    private static final String ON_CLONE_DO_AFTER_COMPOSE = "onCLONE_DO_AFTER_COMPOSE";
    protected transient Component self;
    protected transient IdSpace spaceOwner;
    protected transient Page page;
    protected transient Desktop desktop;
    protected transient Session session;
    protected transient WebApp application;
    protected transient Map componentScope;
    protected transient Map spaceScope;
    protected transient Map pageScope;
    protected transient Map desktopScope;
    protected transient Map sessionScope;
    protected transient Map applicationScope;
    protected transient Map requestScope;
    protected transient Execution execution;
    protected transient Map arg;
    protected transient Map param;
    protected final char _separator;
    private static Method SHOW;

    protected GenericAutowireComposer() {
        this._separator = (char)36;
    }

    protected GenericAutowireComposer(char separator) {
        this._separator = separator;
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        Components.wireVariables(comp, (Object)this, this._separator);
        comp.addEventListener("onCreate", new BeforeCreateWireListener());
    }

    protected void alert(String m) {
        try {
            if (SHOW == null) {
                Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                SHOW = mboxcls.getMethod("show", String.class);
            }
            SHOW.invoke(null, m);
        }
        catch (InvocationTargetException e) {
            throw UiException.Aide.wrap(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone(Component comp) {
        try {
            Execution exec = Executions.getCurrent();
            int idcode = System.identityHashCode(comp);
            Composer composerClone = (Composer)exec.getAttribute(COMPOSER_CLONE + idcode);
            if (composerClone == null) {
                composerClone = (Composer)Classes.newInstance(this.getClass(), null);
                exec.setAttribute(COMPOSER_CLONE + idcode, composerClone);
                comp.addEventListener(ON_CLONE_DO_AFTER_COMPOSE, new CloneDoAfterCompose());
                Events.postEvent(new Event(ON_CLONE_DO_AFTER_COMPOSE, comp, composerClone));
            }
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public void didActivate(Namespace ns) {
        Component comp = this.getAppliedComponent(ns);
        if (comp != null) {
            super.didActivate(ns);
            if (this.self == null) {
                Components.wireVariables(comp, (Object)this, this._separator);
            }
        }
    }

    private static class CloneDoAfterCompose
    implements EventListener {
        private CloneDoAfterCompose() {
        }

        public void onEvent(Event event) throws Exception {
            Component clone = event.getTarget();
            GenericAutowireComposer composerClone = (GenericAutowireComposer)event.getData();
            composerClone.doAfterCompose(clone);
            clone.removeEventListener(GenericAutowireComposer.ON_CLONE_DO_AFTER_COMPOSE, this);
        }
    }

    private class BeforeCreateWireListener
    implements EventListener,
    Express {
        private BeforeCreateWireListener() {
        }

        public void onEvent(Event event) throws Exception {
            Components.wireVariables(event.getTarget(), (Object)GenericAutowireComposer.this, GenericAutowireComposer.this._separator);
            event.getTarget().removeEventListener("onCreate", this);
        }
    }
}

