/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.zkoss.io.Files;
import org.zkoss.util.Locales;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuCloseErrorBox;
import org.zkoss.zk.au.out.AuConfirmClose;
import org.zkoss.zk.au.out.AuMoveBy;
import org.zkoss.zk.au.out.AuMoveTo;
import org.zkoss.zk.au.out.AuPrint;
import org.zkoss.zk.au.out.AuResizeBy;
import org.zkoss.zk.au.out.AuResizeTo;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.au.out.AuScrollBy;
import org.zkoss.zk.au.out.AuScrollIntoView;
import org.zkoss.zk.au.out.AuScrollTo;
import org.zkoss.zk.au.out.AuShowBusy;
import org.zkoss.zk.au.out.AuSubmitForm;
import org.zkoss.zk.fn.DspFns;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;

public class Clients {
    public static final void response(AuResponse response) {
        Executions.getCurrent().addAuResponse(response.getCommand(), response);
    }

    public static final void response(String key, AuResponse response) {
        Executions.getCurrent().addAuResponse(key, response);
    }

    public static final void confirmClose(String mesg) {
        Clients.response(new AuConfirmClose(mesg));
    }

    public static final void closeErrorBox(Component owner) {
        Clients.response(new AuCloseErrorBox(owner));
    }

    public static final void closeErrorBox(List comps) {
        Clients.response(new AuCloseErrorBox(comps));
    }

    public static final void closeErrorBox(Component[] comps) {
        Clients.response(new AuCloseErrorBox(comps));
    }

    public static final void submitForm(String formId) {
        Clients.response(new AuSubmitForm(formId));
    }

    public static final void submitForm(Component form) {
        Clients.submitForm(form.getUuid());
    }

    public static void print() {
        Clients.response(new AuPrint());
    }

    public static final void scrollIntoView(Component cmp) {
        Clients.response(new AuScrollIntoView(cmp));
    }

    public static final void scrollBy(int x, int y) {
        Clients.response(new AuScrollBy(x, y));
    }

    public static final void scrollTo(int x, int y) {
        Clients.response(new AuScrollTo(x, y));
    }

    public static final void resizeBy(int x, int y) {
        Clients.response(new AuResizeBy(x, y));
    }

    public static final void resizeTo(int x, int y) {
        Clients.response(new AuResizeTo(x, y));
    }

    public static final void moveBy(int x, int y) {
        Clients.response(new AuMoveBy(x, y));
    }

    public static final void moveTo(int x, int y) {
        Clients.response(new AuMoveTo(x, y));
    }

    public static final void evalJavaScript(String javaScript) {
        Clients.response(new AuScript(null, javaScript));
    }

    public static final void showBusy(String msg, boolean open) {
        Clients.response(new AuShowBusy(msg, open));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reloadMessages(Locale locale) throws IOException {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        StringBuffer sb = new StringBuffer(4096);
        Locale oldl = Locales.setThreadLocal((Locale)locale);
        try {
            Execution exec = Executions.getCurrent();
            sb.append(Clients.loadJS(exec, "~./js/zk/html/lang/mesg*.js"));
            sb.append(DspFns.outLocaleJavaScript());
            sb.append(Clients.loadJS(exec, "~./js/zul/lang/msgzul*.js"));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Locales.setThreadLocal((Locale)oldl);
            throw throwable;
        }
        Locales.setThreadLocal((Locale)oldl);
        Clients.response(new AuScript(null, sb.toString()));
    }

    private static String loadJS(Execution exec, String path) throws IOException {
        path = exec.locate(path);
        InputStream is = exec.getDesktop().getWebApp().getResourceAsStream(path);
        if (is == null) {
            throw new UiException("Unable to load " + path);
        }
        byte[] bs = Files.readAll((InputStream)is);
        Files.close((InputStream)is);
        return new String(bs, "UTF-8");
    }
}

