/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.Cache;
import org.zkoss.util.Utils;
import org.zkoss.util.logging.Log;
import org.zkoss.util.logging.LogService;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.DefinitionLoaders;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ThemeProvider;

public class ConfigParser {
    private static final Log log = Log.lookup((Class)ConfigParser.class);
    private static final int MAX_VERSION_SEGMENT = 4;
    private static int[] _zkver;
    private static boolean _syscfgLoaded;
    private int _richletnm;
    static /* synthetic */ Class class$org$zkoss$zk$ui$util$CharsetFinder;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$DesktopCacheProvider;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$UiFactory;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$FailoverManager;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$UiEngine;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$IdGenerator;
    static /* synthetic */ Class class$org$zkoss$zk$ui$sys$SessionCache;
    static /* synthetic */ Class class$org$zkoss$zk$ui$WebApp;
    static /* synthetic */ Class class$org$zkoss$util$Cache;
    static /* synthetic */ Class class$org$zkoss$web$servlet$http$Encodes$URLEncoder;
    static /* synthetic */ Class class$org$zkoss$xel$ExpressionFactory;

    public static boolean checkVersion(URL url, Document doc) throws Exception {
        Class cls;
        Field fld;
        String uidInClass;
        String reqzkver;
        Element el = doc.getRootElement().getElement("version");
        if (el == null) {
            return true;
        }
        if (_zkver == null) {
            _zkver = Utils.parseVersion((String)"3.6.3");
        }
        if ((reqzkver = el.getElementValue("zk-version", true)) != null && Utils.compareVersion((int[])_zkver, (int[])Utils.parseVersion((String)reqzkver)) < 0) {
            log.info("Ignore " + url + "\nCause: ZK version must be " + reqzkver + " or later, not " + "3.6.3");
            return false;
        }
        String clsnm = el.getElementValue("version-class", true);
        if (clsnm == null) {
            if (clsnm.length() == 0) {
                log.warning("Ignored: empty version-class, " + el.getLocator());
            }
            return true;
        }
        String uid = IDOMs.getRequiredElementValue((Element)el, (String)"version-uid");
        if (!uid.equals(uidInClass = (String)(fld = (cls = Classes.forNameByThread((String)clsnm)).getField("UID")).get(null))) {
            log.info("Ignore " + url + "\nCause: version not matched; expected=" + uidInClass + ", xml=" + uid);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseConfigXml(Configuration config) {
        boolean syscfgLoaded;
        Class clazz = ConfigParser.class;
        synchronized (clazz) {
            syscfgLoaded = _syscfgLoaded;
            _syscfgLoaded = true;
        }
        if (!syscfgLoaded) {
            log.info("Loading system default");
        } else if (config == null) {
            return;
        }
        try {
            ClassLocator locator = new ClassLocator();
            List xmls = locator.getDependentXMLResources("metainfo/zk/config.xml", "config-name", "depends");
            Iterator it = xmls.iterator();
            while (it.hasNext()) {
                ClassLocator.Resource res = (ClassLocator.Resource)it.next();
                if (log.debugable()) {
                    log.debug("Loading " + res.url);
                }
                try {
                    if (!ConfigParser.checkVersion(res.url, res.document)) continue;
                    Element el = res.document.getRootElement();
                    if (!syscfgLoaded) {
                        ConfigParser.parseSubZScriptConfig(el);
                        ConfigParser.parseSubDeviceConfig(el);
                        ConfigParser.parseSubSystemConfig(el);
                        ConfigParser.parseSubClientConfig(config, el);
                    }
                    if (config == null) continue;
                    ConfigParser.parseListeners(config, el);
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap((Throwable)ex, "Failed to load " + res.url);
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private static void parseSubZScriptConfig(Element root) {
        Iterator it = root.getElements("zscript-config").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            Interpreters.add(el);
        }
    }

    private static void parseSubDeviceConfig(Element root) {
        Iterator it = root.getElements("device-config").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            Devices.add(el);
        }
    }

    private static void parseSubSystemConfig(Element root) throws Exception {
        Iterator it = root.getElements("system-config").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String s = el.getElementValue("au-writer-class", true);
            if (s == null) continue;
            AuWriters.setImplementationClass(s.length() == 0 ? null : Classes.forNameByThread((String)s));
        }
    }

    private static void parseSubClientConfig(Configuration config, Element root) throws Exception {
        Iterator it = root.getElements("client-config").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (config != null) {
                ConfigParser.parseClientConfig(config, el);
                continue;
            }
            Integer v = ConfigParser.parseInteger(el, "resend-delay", false);
            if (v == null) continue;
            Library.setProperty((String)"org.zkoss.zk.au.resendDelay", (String)v.toString());
        }
    }

    private static void parseListeners(Configuration config, Element root) throws Exception {
        Iterator it = root.getElements("listener").iterator();
        while (it.hasNext()) {
            ConfigParser.parseListener(config, (Element)it.next());
        }
    }

    private static void parseListener(Configuration config, Element el) {
        String clsnm = IDOMs.getRequiredElementValue((Element)el, (String)"listener-class");
        try {
            Class cls = Classes.forNameByThread((String)clsnm);
            config.addListener(cls);
        }
        catch (Throwable ex) {
            throw new UiException("Unable to load " + clsnm + ", at " + el.getLocator(), ex);
        }
    }

    public void parse(URL url, Configuration config, Locator locator) throws Exception {
        if (url == null || config == null) {
            throw new IllegalArgumentException("null");
        }
        log.info("Parsing " + url);
        this.parse(new SAXBuilder(true, false, true).build(url).getRootElement(), config, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Element root, Configuration config, Locator locator) throws Exception {
        Iterator it = root.getElements().iterator();
        while (it.hasNext()) {
            String val;
            String nm;
            String clsnm;
            Element el = (Element)it.next();
            String elnm = el.getName();
            if ("listener".equals(elnm)) {
                ConfigParser.parseListener(config, el);
                continue;
            }
            if ("richlet".equals(elnm)) {
                clsnm = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-class");
                Map params = IDOMs.parseParams((Element)el, (String)"init-param", (String)"param-name", (String)"param-value");
                String path = el.getElementValue("richlet-url", true);
                if (path != null) {
                    int cnt;
                    ConfigParser configParser = this;
                    synchronized (configParser) {
                        ++this._richletnm;
                    }
                    String name = "z_obs_" + Integer.toHexString(cnt);
                    try {
                        config.addRichlet(name, clsnm, params);
                        config.addRichletMapping(name, path);
                        continue;
                    }
                    catch (Throwable ex) {
                        throw new UiException("Illegal richlet definition at " + el.getLocator(), ex);
                    }
                }
                String nm2 = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-name");
                try {
                    config.addRichlet(nm2, clsnm, params);
                    continue;
                }
                catch (Throwable ex) {
                    throw new UiException("Illegal richlet definition at " + el.getLocator(), ex);
                }
            }
            if ("richlet-mapping".equals(elnm)) {
                nm = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-name");
                String path = IDOMs.getRequiredElementValue((Element)el, (String)"url-pattern");
                try {
                    config.addRichletMapping(nm, path);
                    continue;
                }
                catch (Throwable ex) {
                    throw new UiException("Illegal richlet mapping at " + el.getLocator(), ex);
                }
            }
            if ("desktop-config".equals(elnm)) {
                ConfigParser.parseDesktopConfig(config, el);
                ConfigParser.parseClientConfig(config, el);
                continue;
            }
            if ("client-config".equals(elnm)) {
                ConfigParser.parseClientConfig(config, el);
                continue;
            }
            if ("session-config".equals(elnm)) {
                String s;
                Integer v = ConfigParser.parseInteger(el, "session-timeout", false);
                if (v != null) {
                    config.setSessionMaxInactiveInterval(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-desktops-per-session", false)) != null) {
                    config.setSessionMaxDesktops(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-requests-per-session", false)) != null) {
                    config.setSessionMaxRequests(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-pushes-per-session", false)) != null) {
                    config.setSessionMaxPushes(v);
                }
                if ((s = el.getElementValue("timer-keep-alive", true)) != null) {
                    config.setTimerKeepAlive("true".equals(s));
                }
                ConfigParser.parseTimeoutURI(config, el);
                continue;
            }
            if ("language-config".equals(elnm)) {
                ConfigParser.parseLangAddon(locator, el);
                continue;
            }
            if ("language-mapping".equals(elnm)) {
                DefinitionLoaders.addExtension(IDOMs.getRequiredElementValue((Element)el, (String)"extension"), IDOMs.getRequiredElementValue((Element)el, (String)"language-name"));
                continue;
            }
            if ("system-config".equals(elnm)) {
                Class cls;
                Integer v;
                String s = el.getElementValue("disable-event-thread", true);
                if (s != null) {
                    boolean enable = "false".equals(s);
                    if (!enable) {
                        log.info("The event processing thread is disabled");
                    }
                    config.enableEventThread(enable);
                }
                if ((v = ConfigParser.parseInteger(el, "max-spare-threads", false)) != null) {
                    config.setMaxSpareThreads(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-suspended-threads", false)) != null) {
                    config.setMaxSuspendedThreads(v);
                }
                if ((v = ConfigParser.parseInteger(el, "event-time-warning", false)) != null) {
                    config.setEventTimeWarning(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-upload-size", false)) != null) {
                    config.setMaxUploadSize(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-process-time", true)) != null) {
                    config.setMaxProcessTime(v);
                }
                if ((s = el.getElementValue("upload-charset", true)) != null) {
                    config.setUploadCharset(s);
                }
                if ((s = el.getElementValue("response-charset", true)) != null) {
                    config.setResponseCharset(s);
                }
                if ((cls = ConfigParser.parseClass(el, "upload-charset-finder-class", class$org$zkoss$zk$ui$util$CharsetFinder == null ? ConfigParser.class$("org.zkoss.zk.ui.util.CharsetFinder") : class$org$zkoss$zk$ui$util$CharsetFinder)) != null) {
                    config.setUploadCharsetFinder((CharsetFinder)cls.newInstance());
                }
                if ((cls = ConfigParser.parseClass(el, "cache-provider-class", class$org$zkoss$zk$ui$sys$DesktopCacheProvider == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.DesktopCacheProvider") : class$org$zkoss$zk$ui$sys$DesktopCacheProvider)) != null) {
                    config.setDesktopCacheProviderClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "ui-factory-class", class$org$zkoss$zk$ui$sys$UiFactory == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.UiFactory") : class$org$zkoss$zk$ui$sys$UiFactory)) != null) {
                    config.setUiFactoryClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "failover-manager-class", class$org$zkoss$zk$ui$sys$FailoverManager == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.FailoverManager") : class$org$zkoss$zk$ui$sys$FailoverManager)) != null) {
                    config.setFailoverManagerClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "engine-class", class$org$zkoss$zk$ui$sys$UiEngine == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.UiEngine") : class$org$zkoss$zk$ui$sys$UiEngine)) != null) {
                    config.setUiEngineClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "id-generator-class", class$org$zkoss$zk$ui$sys$IdGenerator == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.IdGenerator") : class$org$zkoss$zk$ui$sys$IdGenerator)) != null) {
                    config.setIdGeneratorClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "session-cache-class", class$org$zkoss$zk$ui$sys$SessionCache == null ? ConfigParser.class$("org.zkoss.zk.ui.sys.SessionCache") : class$org$zkoss$zk$ui$sys$SessionCache)) != null) {
                    config.setSessionCacheClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "web-app-class", class$org$zkoss$zk$ui$WebApp == null ? ConfigParser.class$("org.zkoss.zk.ui.WebApp") : class$org$zkoss$zk$ui$WebApp)) != null) {
                    config.setWebAppClass(cls);
                }
                if ((cls = ConfigParser.parseClass(el, "method-cache-class", class$org$zkoss$util$Cache == null ? ConfigParser.class$("org.zkoss.util.Cache") : class$org$zkoss$util$Cache)) != null) {
                    ComponentsCtrl.setEventMethodCache((Cache)cls.newInstance());
                }
                if ((cls = ConfigParser.parseClass(el, "url-encoder-class", class$org$zkoss$web$servlet$http$Encodes$URLEncoder == null ? ConfigParser.class$("org.zkoss.web.servlet.http.Encodes$URLEncoder") : class$org$zkoss$web$servlet$http$Encodes$URLEncoder)) != null) {
                    Encodes.setURLEncoder((Encodes.URLEncoder)((Encodes.URLEncoder)cls.newInstance()));
                }
                if ((s = el.getElementValue("au-writer-class", true)) == null) continue;
                AuWriters.setImplementationClass(s.length() == 0 ? null : Classes.forNameByThread((String)s));
                continue;
            }
            if ("xel-config".equals(elnm)) {
                Class cls = ConfigParser.parseClass(el, "evaluator-class", class$org$zkoss$xel$ExpressionFactory == null ? ConfigParser.class$("org.zkoss.xel.ExpressionFactory") : class$org$zkoss$xel$ExpressionFactory);
                if (cls == null) continue;
                config.setExpressionFactoryClass(cls);
                continue;
            }
            if ("zscript-config".equals(elnm)) {
                Interpreters.add(el);
                continue;
            }
            if ("device-config".equals(elnm)) {
                Devices.add(el);
                ConfigParser.parseTimeoutURI(config, el);
                continue;
            }
            if ("log".equals(elnm)) {
                String base = el.getElementValue("log-base", true);
                if (base == null) continue;
                LogService.init((String)base, null);
                continue;
            }
            if ("error-page".equals(elnm)) {
                Class cls;
                clsnm = IDOMs.getRequiredElementValue((Element)el, (String)"exception-type");
                String loc = IDOMs.getRequiredElementValue((Element)el, (String)"location");
                String deviceType = el.getElementValue("device-type", true);
                if (deviceType == null) {
                    deviceType = "ajax";
                } else if (deviceType.length() == 0) {
                    throw new UiException("device-type not specified at " + el.getLocator());
                }
                try {
                    cls = Classes.forNameByThread((String)clsnm);
                }
                catch (Throwable ex) {
                    throw new UiException("Unable to load " + clsnm + ", at " + el.getLocator(), ex);
                }
                config.addErrorPage(deviceType, cls, loc);
                continue;
            }
            if ("preference".equals(elnm)) {
                nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
                val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
                config.setPreference(nm, val);
                continue;
            }
            if ("library-property".equals(elnm)) {
                nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
                val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
                Library.setProperty((String)nm, (String)val);
                continue;
            }
            if ("system-property".equals(elnm)) {
                nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
                val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
                System.setProperty(nm, val);
                continue;
            }
            throw new UiException("Unknown element: " + elnm + ", at " + el.getLocator());
        }
    }

    private static void parseTimeoutURI(Configuration config, Element conf) throws Exception {
        String deviceType = conf.getElementValue("device-type", true);
        String s = conf.getElementValue("timeout-uri", true);
        if (s != null) {
            config.setTimeoutURI(deviceType, s, 0);
        }
        if ((s = conf.getElementValue("automatic-timeout", true)) != null) {
            config.setAutomaticTimeout(deviceType, !"false".equals(s));
        }
    }

    private static void parseDesktopConfig(Configuration config, Element conf) throws Exception {
        String s;
        Integer v;
        String uri;
        Element el;
        Iterator it = conf.getElements("theme-uri").iterator();
        while (it.hasNext()) {
            el = (Element)it.next();
            uri = el.getText(true);
            if (uri.length() == 0) continue;
            config.addThemeURI(uri);
        }
        it = conf.getElements("disable-theme-uri").iterator();
        while (it.hasNext()) {
            el = (Element)it.next();
            uri = el.getText(true);
            if (uri.length() == 0) continue;
            config.addDisabledThemeURI(uri);
        }
        Class cls = ConfigParser.parseClass(conf, "theme-provider-class", ThemeProvider.class);
        if (cls != null) {
            config.setThemeProvider((ThemeProvider)cls.newInstance());
        }
        if ((v = ConfigParser.parseInteger(conf, "desktop-timeout", false)) != null) {
            config.setDesktopMaxInactiveInterval(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "file-check-period", true)) != null) {
            Library.setProperty((String)"org.zkoss.util.resource.checkPeriod", (String)v.toString());
        }
        if ((v = ConfigParser.parseInteger(conf, "extendlet-check-period", true)) != null) {
            Library.setProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod", (String)v.toString());
        }
        if ((s = conf.getElementValue("repeat-uuid", true)) != null) {
            config.setRepeatUuid(!"false".equals(s));
        }
        if ((s = conf.getElementValue("id-to-uuid-prefix", true)) != null) {
            Library.setProperty((String)"org.zkoss.zk.ui.id2uuidPrefix", (String)s);
        }
    }

    private static void parseClientConfig(Configuration config, Element conf) {
        String s;
        Integer v = ConfigParser.parseInteger(conf, "processing-prompt-delay", true);
        if (v != null) {
            config.setProcessingPromptDelay(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "tooltip-delay", true)) != null) {
            config.setTooltipDelay(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "resend-delay", false)) != null) {
            config.setResendDelay(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "click-filter-delay", false)) != null) {
            config.setClickFilterDelay(v);
        }
        if ((s = conf.getElementValue("keep-across-visits", true)) != null) {
            config.setKeepDesktopAcrossVisits(!"false".equals(s));
        }
        if ((s = conf.getElementValue("disable-behind-modal", true)) != null) {
            config.enableDisableBehindModal(!"false".equals(s));
        }
        if ((s = conf.getElementValue("debug-js", true)) != null) {
            config.setDebugJS(!"false".equals(s));
        }
        Iterator it = conf.getElements("error-reload").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String deviceType = el.getElementValue("device-type", true);
            String connType = el.getElementValue("connection-type", true);
            v = ConfigParser.parseInteger(el, "error-code", true);
            if (v == null) {
                throw new UiException("error-code is required, " + el.getLocator());
            }
            String uri = IDOMs.getRequiredElementValue((Element)el, (String)"reload-uri");
            if ("false".equals(uri)) {
                uri = null;
            }
            config.setClientErrorReload(deviceType, v, uri, connType);
        }
    }

    private static void parseLangAddon(Locator locator, Element conf) {
        Iterator it = conf.getElements("addon-uri").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String path = el.getText(true);
            URL url = locator.getResource(path);
            if (url == null) {
                log.error("File not found: " + path + ", at " + el.getLocator());
                continue;
            }
            DefinitionLoaders.addAddon(locator, url);
        }
    }

    private static Class parseClass(Element el, String elnm, Class cls) {
        String clsnm = el.getElementValue(elnm, true);
        if (clsnm != null && clsnm.length() != 0) {
            try {
                Class klass = Classes.forNameByThread((String)clsnm);
                if (cls != null && !cls.isAssignableFrom(klass)) {
                    throw new UiException(clsnm + " must implement " + cls.getName() + ", " + el.getLocator());
                }
                return klass;
            }
            catch (Throwable ex) {
                throw new UiException("Unable to load " + clsnm + ", at " + el.getLocator(), ex);
            }
        }
        return null;
    }

    private static Integer parseInteger(Element el, String subnm, boolean positiveOnly) throws UiException {
        String val = el.getElementValue(subnm, true);
        if (val != null && val.length() > 0) {
            try {
                int v = Integer.parseInt(val);
                if (positiveOnly && v <= 0) {
                    throw new UiException("The " + subnm + " element must be a positive number, not " + val + ", at " + el.getLocator());
                }
                return new Integer(v);
            }
            catch (NumberFormatException ex) {
                throw new UiException("The " + subnm + " element must be a number, not " + val + ", at " + el.getLocator());
            }
        }
        return null;
    }
}

