/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.impl.MultiComposerExt;
import org.zkoss.zk.ui.metainfo.impl.MultiFullComposer;
import org.zkoss.zk.ui.metainfo.impl.MultiFullComposerExt;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.FullComposer;

public class MultiComposer
implements Composer {
    private final Composer[] _cs;

    public static Composer getComposer(Page page, Object[] ary) throws Exception {
        Composer[] cs;
        if (ary == null || ary.length == 0) {
            return null;
        }
        if (ary.length == 1) {
            return MultiComposer.toComposer(page, ary[0]);
        }
        boolean ext = false;
        boolean full = false;
        if (ary instanceof Composer[]) {
            cs = (Composer[])ary;
            int j = cs.length;
            while (--j >= 0) {
                if (cs[j] instanceof ComposerExt) {
                    ext = true;
                    if (full) break;
                }
                if (!(cs[j] instanceof FullComposer)) continue;
                full = true;
                if (!ext) continue;
                break;
            }
        } else {
            cs = new Composer[ary.length];
            int j = ary.length;
            while (--j >= 0) {
                cs[j] = MultiComposer.toComposer(page, ary[j]);
                ext = ext || cs[j] instanceof ComposerExt;
                full = full || cs[j] instanceof FullComposer;
            }
        }
        if (full) {
            if (ext) {
                return new MultiFullComposerExt(cs);
            }
            return new MultiFullComposer(cs);
        }
        if (ext) {
            return new MultiComposerExt(cs);
        }
        return new MultiComposer(cs);
    }

    private static Composer toComposer(Page page, Object o) throws Exception {
        if (o instanceof String) {
            String clsnm = ((String)o).trim();
            o = page != null ? page.resolveClass(clsnm).newInstance() : Classes.newInstanceByThread((String)clsnm);
        } else if (o instanceof Class) {
            o = ((Class)o).newInstance();
        }
        return (Composer)o;
    }

    protected MultiComposer(Composer[] cs) throws Exception {
        this._cs = cs;
    }

    public void doAfterCompose(Component comp) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            this._cs[j].doAfterCompose(comp);
        }
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || (compInfo = ((ComposerExt)((Object)this._cs[j])).doBeforeCompose(page, parent, compInfo)) != null) continue;
            return null;
        }
        return compInfo;
    }

    public void doBeforeComposeChildren(Component comp) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt)) continue;
            ((ComposerExt)((Object)this._cs[j])).doBeforeComposeChildren(comp);
        }
    }

    public boolean doCatch(Throwable ex) throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt) || !((ComposerExt)((Object)this._cs[j])).doCatch(ex)) continue;
            return true;
        }
        return false;
    }

    public void doFinally() throws Exception {
        for (int j = 0; j < this._cs.length; ++j) {
            if (!(this._cs[j] instanceof ComposerExt)) continue;
            ((ComposerExt)((Object)this._cs[j])).doFinally();
        }
    }
}

