/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class AnnotationHelper {
    final List _annots = new LinkedList();

    public void add(String annotName, Map annotAttrs) {
        if (annotName == null || annotName.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._annots.add(new Object[]{annotName, annotAttrs});
    }

    public void addByRawValue(String annotName, String rawValue) {
        Map attrs = Maps.parse(null, (String)rawValue, (char)',', (char)'\'', (boolean)true);
        this.add(annotName, attrs);
    }

    public void addByCompoundValue(String cval) {
        char[] seps1 = new char[]{'(', ' '};
        char[] seps2 = new char[]{')'};
        int j = 0;
        int len = cval.length();
        while (j < len) {
            int k = Strings.nextSeparator((String)cval, (int)(j = Strings.skipWhitespaces((CharSequence)cval, (int)j)), (char[])seps1, (boolean)true, (boolean)true, (boolean)false);
            if (k < len && cval.charAt(k) == '(') {
                String rv;
                String nm = cval.substring(j, k).trim();
                if (nm.length() == 0) {
                    nm = "default";
                }
                if ((rv = ((k = Strings.nextSeparator((String)cval, (int)(j = k + 1), (char[])seps2, (boolean)true, (boolean)true, (boolean)false)) < len ? cval.substring(j, k) : cval.substring(j)).trim()).length() > 0) {
                    this.addByRawValue(nm, rv);
                } else {
                    this.add(nm, null);
                }
            } else {
                String rv = (k < len ? cval.substring(j, k) : cval.substring(j)).trim();
                if (rv.length() > 0) {
                    this.addByRawValue("default", rv);
                }
            }
            j = k + 1;
        }
    }

    public void applyAnnotations(ComponentInfo compInfo, String propName, boolean clear) {
        Iterator it = this._annots.iterator();
        while (it.hasNext()) {
            Object[] info = (Object[])it.next();
            String annotName = (String)info[0];
            Map annotAttrs = (Map)info[1];
            if (propName != null) {
                compInfo.addAnnotation(propName, annotName, annotAttrs);
                continue;
            }
            compInfo.addAnnotation(annotName, annotAttrs);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public void applyAnnotations(Component comp, String propName, boolean clear) {
        Iterator it = this._annots.iterator();
        while (it.hasNext()) {
            Object[] info = (Object[])it.next();
            String annotName = (String)info[0];
            Map annotAttrs = (Map)info[1];
            ComponentCtrl ctrl = (ComponentCtrl)((Object)comp);
            if (propName != null) {
                ctrl.addAnnotation(propName, annotName, annotAttrs);
                continue;
            }
            ctrl.addAnnotation(annotName, annotAttrs);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public boolean clear() {
        if (!this._annots.isEmpty()) {
            this._annots.clear();
            return true;
        }
        return false;
    }
}

