/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ArgumentInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class VariableResolverInfo
extends ArgumentInfo {
    private final Object _resolver;

    public VariableResolverInfo(Class cls, Map args) {
        super(args);
        VariableResolverInfo.checkClass(cls);
        this._resolver = cls;
    }

    public VariableResolverInfo(Class cls) {
        this(cls, null);
    }

    private static void checkClass(Class cls) {
        if (!VariableResolver.class.isAssignableFrom(cls)) {
            throw new UiException(VariableResolver.class + " must be implemented: " + cls);
        }
    }

    public VariableResolverInfo(String clsnm, Map args) throws ClassNotFoundException {
        super(args);
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        if (clsnm.indexOf("${") < 0) {
            try {
                Class cls = Classes.forNameByThread((String)clsnm);
                VariableResolverInfo.checkClass(cls);
                this._resolver = cls;
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm, ex);
            }
        } else {
            this._resolver = new ExValue(clsnm, String.class);
        }
    }

    public VariableResolverInfo(String clsnm) throws ClassNotFoundException {
        this(clsnm, null);
    }

    public VariableResolverInfo(VariableResolver resolver) {
        super(null);
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        this._resolver = resolver;
    }

    public VariableResolver newVariableResolver(PageDefinition pgdef, Page page) throws Exception {
        return this.newVariableResolver(pgdef.getEvaluator(), page);
    }

    public VariableResolver newVariableResolver(Evaluator eval, Page page) throws Exception {
        Class cls;
        if (this._resolver instanceof VariableResolver) {
            return (VariableResolver)this._resolver;
        }
        if (this._resolver instanceof ExValue) {
            String clsnm = (String)((ExValue)this._resolver).getValue(eval, page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
            try {
                cls = Classes.forNameByThread((String)clsnm);
                VariableResolverInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._resolver + ")", ex);
            }
        } else {
            cls = (Class)this._resolver;
        }
        return (VariableResolver)this.newInstance(cls, eval, page);
    }

    public String toString() {
        return "[variable-resolver " + this._resolver + "]";
    }
}

