/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;

public class ComponentDefinitionMap
implements Cloneable,
Serializable {
    private transient Map _compdefs;
    private transient Map _compdefsByClass;
    private final boolean _ignoreCase;

    public ComponentDefinitionMap(boolean ignoreCase) {
        this._ignoreCase = ignoreCase;
    }

    public boolean isCaseInsensitive() {
        return this._ignoreCase;
    }

    public Collection getNames() {
        return this._compdefs != null ? this._compdefs.keySet() : Collections.EMPTY_LIST;
    }

    public Collection getDefinitions() {
        return this._compdefs != null ? this._compdefs.values() : Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ComponentDefinition compdef) {
        Object implcls;
        if (compdef == null) {
            throw new IllegalArgumentException("null");
        }
        String name = compdef.getName();
        if (this.isCaseInsensitive()) {
            name = name.toLowerCase();
        }
        if ((implcls = compdef.getImplementationClass()) instanceof Class) {
            implcls = ((Class)implcls).getName();
        }
        ComponentDefinitionMap componentDefinitionMap = this;
        synchronized (componentDefinitionMap) {
            if (this._compdefs == null) {
                this._compdefsByClass = Collections.synchronizedMap(new HashMap(3));
                this._compdefs = Collections.synchronizedMap(new HashMap(3));
            }
            this._compdefs.put(name, compdef);
            this._compdefsByClass.put(implcls, compdef);
        }
    }

    public boolean contains(String name) {
        return this._compdefs != null && this._compdefs.containsKey(this.isCaseInsensitive() ? name.toLowerCase() : name);
    }

    public ComponentDefinition get(String name) {
        return this._compdefs != null ? (ComponentDefinition)this._compdefs.get(this.isCaseInsensitive() ? name.toLowerCase() : name) : null;
    }

    public ComponentDefinition get(Class cls) {
        if (this._compdefsByClass != null) {
            while (cls != null) {
                ComponentDefinition compdef = (ComponentDefinition)this._compdefsByClass.get(cls.getName());
                if (compdef != null) {
                    return compdef;
                }
                cls = cls.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._compdefs != null) {
            Map map = this._compdefs;
            synchronized (map) {
                s.writeInt(this._compdefs.size());
                Iterator it = this._compdefs.values().iterator();
                while (it.hasNext()) {
                    s.writeObject(it.next());
                }
            }
        } else {
            s.writeInt(0);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cnt = s.readInt();
        while (--cnt >= 0) {
            this.add((ComponentDefinition)s.readObject());
        }
    }

    public Object clone() {
        ComponentDefinitionMap clone;
        try {
            clone = (ComponentDefinitionMap)super.clone();
            clone._compdefs = Collections.synchronizedMap(new HashMap(this._compdefs));
            clone._compdefsByClass = Collections.synchronizedMap(new HashMap(this._compdefsByClass));
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        return clone;
    }
}

