/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.zkoss.util.TimeZones;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.sys.SessionsCtrl;

public class I18Ns {
    private static final Log log = Log.lookup((Class)I18Ns.class);
    private static final String ATTR_SETUP = "org.zkoss.zk.ui.http.charset.setup";

    public static final Object setup(Session sess, ServletRequest request, ServletResponse response, String charset) {
        return I18Ns.setup((Object)sess, request, response, charset);
    }

    public static final Object setup(HttpSession sess, ServletRequest request, ServletResponse response, String charset) {
        return I18Ns.setup((Object)sess, request, response, charset);
    }

    private static final Object setup(Object sess, ServletRequest request, ServletResponse response, String charset) {
        Object[] old;
        if (request.getAttribute(ATTR_SETUP) != null) {
            old = null;
        } else {
            HttpSession hsess;
            if (sess instanceof Session) {
                Session se = (Session)sess;
                se.getWebApp().getConfiguration().invokeRequestInterceptors(se, request, response);
                hsess = (HttpSession)se.getNativeSession();
            } else {
                hsess = (HttpSession)sess;
            }
            Object ol = Charsets.setup((HttpSession)hsess, (ServletRequest)request, (ServletResponse)response, (String)charset);
            TimeZone tz = I18Ns.checkTimeZone(hsess.getAttribute("px_preferred_time_zone"));
            if (tz == null) {
                tz = I18Ns.checkTimeZone(hsess.getServletContext().getAttribute("px_preferred_time_zone"));
            }
            TimeZone otz = TimeZones.setThreadLocal((TimeZone)tz);
            request.setAttribute(ATTR_SETUP, (Object)Boolean.TRUE);
            old = new Object[]{ol, otz};
        }
        if (sess instanceof Session) {
            SessionsCtrl.setCurrent((Session)sess);
        }
        return old;
    }

    private static TimeZone checkTimeZone(Object tz) {
        if (tz != null && !(tz instanceof TimeZone)) {
            log.warning("px_preferred_time_zone ignored. TimeZone is required, not " + tz.getClass());
            return null;
        }
        return (TimeZone)tz;
    }

    public static final void cleanup(ServletRequest request, Object old) {
        if (old != null) {
            request.removeAttribute(ATTR_SETUP);
            SessionsCtrl.setCurrent(null);
            Object[] op = (Object[])old;
            TimeZones.setThreadLocal((TimeZone)((TimeZone)op[1]));
            Charsets.cleanup((ServletRequest)request, (Object)op[0]);
        }
    }

    public static final void setPreferredTimeZone(HttpSession hsess, TimeZone timezone) {
        if (timezone != null) {
            hsess.setAttribute("px_preferred_time_zone", (Object)timezone);
        } else {
            hsess.removeAttribute("px_preferred_time_zone");
        }
    }

    public static final void setPreferredTimeZone(ServletContext ctx, TimeZone timezone) {
        if (timezone != null) {
            ctx.setAttribute("px_preferred_time_zone", (Object)timezone);
        } else {
            ctx.removeAttribute("px_preferred_time_zone");
        }
    }
}

