/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class DHtmlLayoutServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)DHtmlLayoutServlet.class);
    private static final String ATTR_LAYOUT_SERVLET = "org.zkoss.zk.ui.http.LayoutServlet";
    private ServletContext _ctx;
    private WebManager _webman;
    private boolean _compress = true;

    public static DHtmlLayoutServlet getLayoutServlet(WebApp wapp) {
        return (DHtmlLayoutServlet)((Object)((ServletContext)wapp.getNativeContext()).getAttribute(ATTR_LAYOUT_SERVLET));
    }

    public void init(ServletConfig config) throws ServletException {
        String param = config.getInitParameter("log-level");
        if (param != null && param.length() > 0) {
            Level level = Log.getLevel((String)param);
            if (level != null) {
                Log.lookup((String)"org.zkoss").setLevel(level);
            } else {
                log.error("Unknown log-level: " + param);
            }
        }
        this._compress = (param = config.getInitParameter("compress")) == null || param.length() == 0 || "true".equals(param);
        this._ctx = config.getServletContext();
        this._webman = WebManager.getWebManagerIfAny(this._ctx);
        if (this._webman != null) {
            log.info("Web Manager was created before ZK loader");
        } else {
            String updateURI = config.getInitParameter("update-uri");
            if (updateURI == null || (updateURI = updateURI.trim()).length() == 0 || updateURI.charAt(0) != '/') {
                throw new ServletException("The update-uri parameter must be specified and starts with /");
            }
            if (updateURI.indexOf(59) >= 0 || updateURI.indexOf(63) >= 0) {
                throw new ServletException("The update-uri parameter cannot contain ';' or '?'");
            }
            if (updateURI.charAt(updateURI.length() - 1) == '\\') {
                if (updateURI.length() == 1) {
                    throw new ServletException("The update-uri parameter cannot contain only '/'");
                }
                updateURI = updateURI.substring(0, updateURI.length() - 1);
            }
            this._webman = new WebManager(this._ctx, updateURI);
        }
        this._ctx.setAttribute(ATTR_LAYOUT_SERVLET, (Object)this);
    }

    public void destroy() {
        if (this._webman != null) {
            this._webman.destroy();
        }
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            Session sess;
            boolean bRichlet;
            String path = Https.getThisPathInfo((ServletRequest)request);
            boolean bl = bRichlet = path != null && path.length() > 0;
            if (!bRichlet) {
                path = Https.getThisServletPath((ServletRequest)request);
            }
            if (!SessionsCtrl.requestEnter(sess = WebManager.getSession(this.getServletContext(), request))) {
                response.sendError(503, Messages.get((int)MZk.TOO_MANY_REQUESTS));
                return;
            }
            try {
                Object old;
                block10: {
                    old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, sess.getWebApp().getConfiguration().getResponseCharset());
                    try {
                        if (this.process(sess, request, response, path, bRichlet)) break block10;
                        this.handleError(sess, request, response, path, null);
                    }
                    catch (Throwable ex) {
                        try {
                            this.handleError(sess, request, response, path, ex);
                            break block11;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            I18Ns.cleanup((ServletRequest)request, old);
                        }
                    }
                }
                I18Ns.cleanup((ServletRequest)request, old);
            }
            finally {
                SessionsCtrl.requestExit(sess);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected boolean process(Session sess, HttpServletRequest request, HttpServletResponse response, String path, boolean bRichlet) throws ServletException, IOException {
        Writer out;
        ExecutionImpl exec;
        Page page;
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Desktop desktop = this._webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
        if (desktop == null) {
            return true;
        }
        RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, PageDefinitions.getLocator(wapp, path));
        sess.setAttribute("_z_gae_fix", new Integer(0));
        ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
        boolean compress = this._compress && !Servlets.isIncluded((ServletRequest)request);
        UiFactory uf = wappc.getUiFactory();
        if (uf.isRichlet(ri, bRichlet)) {
            Richlet richlet = uf.getRichlet(ri, path);
            if (richlet == null) {
                return false;
            }
            page = WebManager.newPage(uf, (RequestInfo)ri, richlet, (ServletResponse)response, path);
            exec = new ExecutionImpl(this._ctx, request, response, desktop, page);
            out = compress ? new StringWriter() : response.getWriter();
            wappc.getUiEngine().execNewPage((Execution)exec, richlet, page, out);
        } else {
            PageDefinition pagedef = uf.getPageDefinition(ri, path);
            if (pagedef == null) {
                return false;
            }
            page = WebManager.newPage(uf, (RequestInfo)ri, pagedef, (ServletResponse)response, path);
            exec = new ExecutionImpl(this._ctx, request, response, desktop, page);
            out = compress ? new StringWriter() : response.getWriter();
            wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, out);
        }
        if (compress) {
            String result = ((StringWriter)out).toString();
            try {
                byte[] bs;
                ServletOutputStream os = response.getOutputStream();
                byte[] data = result.getBytes(wapp.getConfiguration().getResponseCharset());
                if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                    data = bs;
                }
                response.setContentLength(data.length);
                os.write(data);
                response.flushBuffer();
            }
            catch (IllegalStateException ex) {
                response.getWriter().write(result);
            }
        }
        return true;
    }

    private void handleError(Session sess, HttpServletRequest request, HttpServletResponse response, String path, Throwable err) throws ServletException, IOException {
        String errpg;
        if (err != null && Servlets.isIncluded((ServletRequest)request) && (errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err)) != null) {
            try {
                request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                request.setAttribute("javax.servlet.error.exception", (Object)err);
                request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                if (this.process(sess, request, response, errpg, false)) {
                    return;
                }
                log.warning("The error page not found: " + errpg);
            }
            catch (IOException ex) {
            }
            catch (Throwable ex) {
                log.warning("Failed to load the error page: " + errpg, ex);
            }
        }
        Utils.handleError(this._ctx, request, response, path, err);
    }
}

