/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.bsh;

import bsh.BshMethod;
import bsh.NameSpace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.bsh.BSHInterpreter;
import org.zkoss.zk.scripting.bsh.NSWrap;

class NSWrapX
extends NSWrap
implements Serializable {
    private static final Log log = BSHInterpreter.log;
    private Map _vars;
    private List _mtds;
    private List _clses;
    private List _pkgs;

    NSWrapX(NameSpace ns) {
        super(ns);
    }

    public NSWrapX() {
    }

    public NameSpace unwrap(Namespace ns) {
        if (this._bshns == null) {
            String name;
            Iterator it;
            this._bshns = BSHInterpreter.getInterpreter(ns).newNS(ns);
            if (this._vars != null) {
                it = this._vars.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    try {
                        this._bshns.setVariable((String)me.getKey(), me.getValue(), false);
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure of set " + me.getKey(), ex);
                    }
                }
                this._vars = null;
            }
            if (this._mtds != null) {
                it = this._mtds.iterator();
                while (it.hasNext()) {
                    BshMethod mtd = (BshMethod)it.next();
                    try {
                        this._bshns.setMethod(mtd.getName(), mtd);
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure of set " + mtd, ex);
                    }
                }
                this._mtds = null;
            }
            if (this._clses != null) {
                it = this._clses.iterator();
                while (it.hasNext()) {
                    name = (String)((Object)it.next());
                    try {
                        this._bshns.importClass(name);
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure of import class " + name, ex);
                    }
                }
                this._clses = null;
            }
            if (this._pkgs != null) {
                it = this._pkgs.iterator();
                while (it.hasNext()) {
                    name = (String)((Object)it.next());
                    try {
                        this._bshns.importPackage(name);
                    }
                    catch (Throwable ex) {
                        log.warning("Ignored failure of import package " + name, ex);
                    }
                }
                this._pkgs = null;
            }
        }
        return this._bshns;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeBoolean(this._bshns != null);
        if (this._bshns != null) {
            BSHInterpreter.write(this._bshns, s, new SerializableAware.Filter(){

                public boolean accept(String name, Object value) {
                    return value == null || value instanceof Serializable || value instanceof Externalizable;
                }
            });
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (s.readBoolean()) {
            BSHInterpreter.read(new NameSpace(null, null, "nst"){

                public void setVariable(String name, Object value, boolean strictJava) {
                    if (NSWrapX.this._vars == null) {
                        NSWrapX.this._vars = new HashMap();
                    }
                    NSWrapX.this._vars.put(name, value);
                }

                public void setMethod(String name, BshMethod mtd) {
                    if (NSWrapX.this._mtds == null) {
                        NSWrapX.this._mtds = new LinkedList();
                    }
                    NSWrapX.this._mtds.add(mtd);
                }

                public void importClass(String name) {
                    if (NSWrapX.this._clses == null) {
                        NSWrapX.this._clses = new LinkedList();
                    }
                    NSWrapX.this._clses.add(name);
                }

                public void importPackage(String name) {
                    if (NSWrapX.this._pkgs == null) {
                        NSWrapX.this._pkgs = new LinkedList();
                    }
                    NSWrapX.this._pkgs.add(name);
                }

                public void loadDefaultImports() {
                }
            }, s);
        }
    }
}

