/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.util.SimpleNamespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;

public class Namespaces {
    private static final Log log = Log.lookup((Class)Namespaces.class);
    private static final ThreadLocal _implicits = new ThreadLocal();
    private static final ThreadLocal _curnss = new ThreadLocal();

    public static final Namespace beforeInterpret(Component comp) {
        Namespace ns = comp.getNamespace();
        if (ns == null) {
            ns = new SimpleNamespace();
        }
        Implicit impl = Namespaces.beforeInterpret0(ns);
        impl.setImplicit("self", comp);
        impl.setImplicit("componentScope", comp.getAttributes(0));
        return ns;
    }

    public static final Namespace beforeInterpret(Page page) {
        Namespace ns = page.getNamespace();
        Implicit impl = Namespaces.beforeInterpret0(ns);
        impl.setImplicit("self", page);
        return ns;
    }

    private static Implicit beforeInterpret0(Namespace ns) {
        LinkedList<Implicit> impls = (LinkedList<Implicit>)_implicits.get();
        if (impls == null) {
            impls = new LinkedList<Implicit>();
            _implicits.set(impls);
        }
        Implicit impl = new Implicit();
        impls.add(0, impl);
        Execution exec = Executions.getCurrent();
        impl.setImplicit("arg", exec != null ? exec.getArg() : null);
        Namespaces.push(ns);
        return impl;
    }

    public static final void afterInterpret() {
        ((List)_implicits.get()).remove(0);
        Namespaces.pop();
    }

    public static void setImplicit(String name, Object value) {
        ((Implicit)((List)Namespaces._implicits.get()).get(0)).setImplicit(name, value);
    }

    public static Object getImplicit(String name, Object defValue) {
        List implicits = (List)_implicits.get();
        if (implicits != null && !implicits.isEmpty()) {
            return ((Implicit)implicits.get(0)).getImplicit(name, defValue);
        }
        return defValue;
    }

    public static final Namespace beforeInterpret(Map backup, Component comp, boolean pushNS) {
        return Namespaces.beforeInterpret(comp);
    }

    public static final Namespace beforeInterpret(Map backup, Page page, boolean pushNS) {
        return Namespaces.beforeInterpret(page);
    }

    public static final void afterInterpret(Map backup, Namespace ns, boolean popNS) {
        Namespaces.afterInterpret();
    }

    public static final void backupVariable(Map backup, Namespace ns, String name) {
    }

    public static final Namespace getCurrent(Page page) {
        List nss = (List)_curnss.get();
        Namespace ns = nss != null && !nss.isEmpty() ? (Namespace)nss.get(0) : null;
        return ns != null ? ns : page.getNamespace();
    }

    private static final void push(Namespace ns) {
        LinkedList<Namespace> nss = (LinkedList<Namespace>)_curnss.get();
        if (nss == null) {
            nss = new LinkedList<Namespace>();
            _curnss.set(nss);
        }
        nss.add(0, ns);
    }

    private static final void pop() {
        ((List)_curnss.get()).remove(0);
    }

    private static class Implicit {
        private final Map _vars = new HashMap();

        private Implicit() {
        }

        private void setImplicit(String name, Object value) {
            this._vars.put(name, value);
        }

        private Object getImplicit(String name, Object defValue) {
            Object o = this._vars.get(name);
            return o != null || this._vars.containsKey(name) ? o : defValue;
        }
    }
}

