/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.zkoss.image.AImage;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.sound.AAudio;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.media.Media;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.au.http.ZkFileItemFactory;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Configuration;

public class AuUploader
implements AuProcessor {
    private static final Log log = Log.lookup((Class)AuUploader.class);

    public void process(Session sess, ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException, IOException {
        if (sess == null) {
            response.sendError(410, Messages.get((int)MZk.PAGE_NOT_FOUND, (Object)pathInfo));
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        String alert = null;
        String uuid = null;
        String nextURI = null;
        try {
            if (!AuUploader.isMultipartContent(request)) {
                alert = "enctype must be multipart/form-data";
            } else {
                uuid = request.getParameter("uuid");
                if (uuid == null || uuid.length() == 0) {
                    alert = "uuid is required";
                } else {
                    attrs.put("uuid", uuid);
                    String dtid = request.getParameter("dtid");
                    if (dtid == null || dtid.length() == 0) {
                        alert = "dtid is required";
                    } else {
                        Desktop desktop = ((WebAppCtrl)((Object)sess.getWebApp())).getDesktopCache(sess).getDesktop(dtid);
                        Map params = AuUploader.parseRequest(request, desktop);
                        nextURI = (String)params.get("nextURI");
                        AuUploader.processItems(desktop, params, attrs);
                    }
                }
            }
        }
        catch (Throwable ex) {
            if (uuid == null && (uuid = request.getParameter("uuid")) != null) {
                attrs.put("uuid", uuid);
            }
            if (nextURI == null) {
                nextURI = request.getParameter("nextURI");
            }
            alert = ex instanceof ComponentNotFoundException ? Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)uuid) : this.handleError(ex);
        }
        if (alert != null) {
            attrs.put("alert", alert);
        }
        if (log.finerable()) {
            log.finer(attrs);
        }
        if (nextURI == null || nextURI.length() == 0) {
            nextURI = "~./zul/html/fileupload-done.html.dsp";
        }
        Servlets.forward((ServletContext)ctx, (ServletRequest)request, (ServletResponse)response, (String)nextURI, attrs, (int)3);
    }

    protected String handleError(Throwable ex) {
        log.realCauseBriefly("Failed to upload", ex);
        return Exceptions.getMessage((Throwable)ex);
    }

    private static final void processItems(Desktop desktop, Map params, Map attrs) throws IOException {
        LinkedList<Media> meds = new LinkedList<Media>();
        boolean alwaysNative = "true".equals(params.get("native"));
        Object fis = params.get("file");
        if (fis instanceof FileItem) {
            meds.add(AuUploader.processItem(desktop, (FileItem)fis, alwaysNative));
        } else if (fis != null) {
            Iterator it = ((List)fis).iterator();
            while (it.hasNext()) {
                meds.add(AuUploader.processItem(desktop, (FileItem)it.next(), alwaysNative));
            }
        }
        String contentId = Strings.encode((StringBuffer)new StringBuffer(12).append("z__ul_"), (int)((DesktopCtrl)((Object)desktop)).getNextKey()).toString();
        attrs.put("contentId", contentId);
        desktop.setAttribute(contentId, meds);
    }

    private static final Media processItem(Desktop desktop, FileItem fi, boolean alwaysNative) throws IOException {
        String s;
        int j;
        String ctype;
        String ctypelc;
        int k;
        int j2;
        String name = AuUploader.getBaseName(fi);
        if (name != null && (j2 = name.lastIndexOf(59)) > 0 && (k = name.lastIndexOf(46)) >= 0 && j2 > k && k > name.lastIndexOf(47)) {
            name = name.substring(0, j2);
        }
        String string = ctypelc = (ctype = fi.getContentType()) != null ? ctype.toLowerCase() : null;
        if (name != null && "application/octet-stream".equals(ctypelc) && (j = name.lastIndexOf(46)) >= 0 && (s = ContentTypes.getContentType((String)name.substring(j + 1))) != null) {
            ctypelc = ctype = s;
        }
        if (!alwaysNative && ctypelc != null) {
            if (ctypelc.startsWith("image/")) {
                try {
                    return fi.isInMemory() ? new AImage(name, fi.get()) : new AImage(name, fi.getInputStream());
                }
                catch (Throwable ex) {
                    if (log.debugable()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("audio/")) {
                try {
                    return fi.isInMemory() ? new AAudio(name, fi.get()) : new StreamAudio(name, fi);
                }
                catch (Throwable ex) {
                    if (log.debugable()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("text/")) {
                String charset = AuUploader.getCharset(ctype);
                if (charset == null) {
                    Configuration conf = desktop.getWebApp().getConfiguration();
                    CharsetFinder chfd = conf.getUploadCharsetFinder();
                    if (chfd != null) {
                        charset = chfd.getCharset(ctype, fi.isInMemory() ? new ByteArrayInputStream(fi.get()) : fi.getInputStream());
                    }
                    if (charset == null) {
                        charset = conf.getUploadCharset();
                    }
                }
                return fi.isInMemory() ? new AMedia(name, null, ctype, fi.getString(charset)) : new ReaderMedia(name, null, ctype, fi, charset);
            }
        }
        return fi.isInMemory() ? new AMedia(name, null, ctype, fi.get()) : new StreamMedia(name, null, ctype, fi);
    }

    private static String getCharset(String ctype) {
        String ctypelc = ctype.toLowerCase();
        int j = 0;
        while ((j = ctypelc.indexOf("charset", j)) >= 0) {
            int k = Strings.skipWhitespacesBackward((CharSequence)ctype, (int)(j - 1));
            if ((k < 0 || ctype.charAt(k) == ';') && (k = Strings.skipWhitespaces((CharSequence)ctype, (int)(j + 7))) <= ctype.length() && ctype.charAt(k) == '=') {
                String charset;
                if ((charset = ((j = ctype.indexOf(59, ++k)) >= 0 ? ctype.substring(k, j) : ctype.substring(k)).trim()).length() <= 0) break;
                return charset;
            }
            j += 7;
        }
        return null;
    }

    private static Map parseRequest(HttpServletRequest request, Desktop desktop) throws FileUploadException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ZkFileItemFactory fty = new ZkFileItemFactory(desktop, request);
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)fty);
        sfu.setProgressListener((ProgressListener)new ZkFileItemFactory.ProgressCallback(fty));
        Configuration conf = desktop.getWebApp().getConfiguration();
        int maxsz = conf.getMaxUploadSize();
        try {
            int mz = Integer.parseInt(request.getParameter("maxsize"));
            if (mz != -1) {
                maxsz = mz;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        sfu.setSizeMax(maxsz >= 0 ? 1024L * (long)maxsz : -1L);
        Iterator it = sfu.parseRequest(request).iterator();
        while (it.hasNext()) {
            LinkedList<FileItem> vals;
            Object val;
            FileItem fi = (FileItem)it.next();
            String nm = fi.getFieldName();
            FileItem old = params.put(nm, val = fi.isFormField() ? fi.getString() : fi);
            if (old == null) continue;
            if (old instanceof List) {
                vals = (LinkedList<FileItem>)old;
                params.put(nm, vals);
            } else {
                vals = new LinkedList<FileItem>();
                params.put(nm, vals);
                vals.add(old);
            }
            vals.add((FileItem)val);
        }
        return params;
    }

    private static String getBaseName(FileItem fi) {
        String name = fi.getName();
        if (name == null) {
            return null;
        }
        String[] seps = new String[]{"/", "\\", "%5c", "%5C", "%2f", "%2F"};
        int j = seps.length;
        while (--j >= 0) {
            int k = name.lastIndexOf(seps[j]);
            if (k < 0) continue;
            name = name.substring(k + seps[j].length());
        }
        return name;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        return "post".equals(request.getMethod().toLowerCase()) && FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(request));
    }

    private static class StreamAudio
    extends AAudio {
        private final FileItem _fi;

        public StreamAudio(String name, FileItem fi) throws IOException {
            super(name, DYNAMIC_STREAM);
            this._fi = fi;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }
    }

    private static class ReaderMedia
    extends AMedia {
        private final FileItem _fi;
        private final String _charset;

        public ReaderMedia(String name, String format, String ctype, FileItem fi, String charset) {
            super(name, format, ctype, DYNAMIC_READER);
            this._fi = fi;
            this._charset = charset;
        }

        public Reader getReaderData() {
            try {
                return new InputStreamReader(this._fi.getInputStream(), this._charset);
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }
    }

    private static class StreamMedia
    extends AMedia {
        private final FileItem _fi;

        public StreamMedia(String name, String format, String ctype, FileItem fi) {
            super(name, format, ctype, DYNAMIC_STREAM);
            this._fi = fi;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }
    }
}

