/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.BulkAccess;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class BulkAccessImpl
extends AMXImplBase
implements BulkAccess {
    public String getGroup() {
        return "utility";
    }

    public Object[] bulkGetMBeanInfo(ObjectName[] objectNames) {
        Object[] infos = new Object[objectNames.length];
        for (int i = 0; i < infos.length; ++i) {
            try {
                infos[i] = this.getMBeanServer().getMBeanInfo(objectNames[i]);
                continue;
            }
            catch (Throwable t) {
                infos[i] = t;
            }
        }
        return infos;
    }

    public Object[] bulkGetMBeanAttributeInfo(ObjectName[] objectNames) {
        Object[] results = new Object[objectNames.length];
        Object[] mbeanInfos = this.bulkGetMBeanInfo(objectNames);
        for (int i = 0; i < results.length; ++i) {
            results[i] = mbeanInfos[i] instanceof MBeanInfo ? ((MBeanInfo)mbeanInfos[i]).getAttributes() : mbeanInfos[i];
        }
        return results;
    }

    public Object[] bulkGetAttributeNames(ObjectName[] objectNames) {
        Object[] results = new Object[objectNames.length];
        Object[] mbeanInfos = this.bulkGetMBeanInfo(objectNames);
        for (int i = 0; i < results.length; ++i) {
            if (mbeanInfos[i] instanceof MBeanInfo) {
                MBeanInfo info = (MBeanInfo)mbeanInfos[i];
                results[i] = JMXUtil.getAttributeNames(info.getAttributes());
                continue;
            }
            results[i] = mbeanInfos[i];
        }
        return results;
    }

    public Object[] bulkGetMBeanOperationInfo(ObjectName[] objectNames) {
        Object[] results = new Object[objectNames.length];
        Object[] mbeanInfos = this.bulkGetMBeanInfo(objectNames);
        for (int i = 0; i < results.length; ++i) {
            if (mbeanInfos[i] instanceof MBeanInfo) {
                MBeanInfo info = (MBeanInfo)mbeanInfos[i];
                results[i] = info.getOperations();
                continue;
            }
            results[i] = mbeanInfos[i];
        }
        return results;
    }

    public Object[] bulkGetAttribute(ObjectName[] objectNames, String attributeName) {
        Object[] results = new Object[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            try {
                results[i] = this.getMBeanServer().getAttribute(objectNames[i], attributeName);
                continue;
            }
            catch (Throwable t) {
                results[i] = t;
            }
        }
        return results;
    }

    public Object[] bulkSetAttribute(ObjectName[] objectNames, Attribute attr) {
        Object[] results = new Object[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            try {
                results[i] = null;
                this.getMBeanServer().setAttribute(objectNames[i], attr);
                continue;
            }
            catch (Throwable t) {
                results[i] = t;
            }
        }
        return results;
    }

    public Object[] bulkGetAttributes(ObjectName[] objectNames, String[] attributeNames) {
        Object[] results = new Object[objectNames.length];
        if (attributeNames.length != 0) {
            for (int i = 0; i < objectNames.length; ++i) {
                String[] attributesCopy = (String[])attributeNames.clone();
                try {
                    results[i] = this.getMBeanServer().getAttributes(objectNames[i], attributesCopy);
                    continue;
                }
                catch (Throwable t) {
                    results[i] = t;
                }
            }
        }
        return results;
    }

    public Object[] bulkSetAttributes(ObjectName[] objectNames, AttributeList attrs) {
        Object[] results = new Object[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            try {
                AttributeList attrsCopy = (AttributeList)attrs.clone();
                results[i] = this.getMBeanServer().setAttributes(objectNames[i], attrsCopy);
                continue;
            }
            catch (Throwable t) {
                results[i] = t;
            }
        }
        return results;
    }

    public Object[] bulkInvoke(ObjectName[] objectNames, String operationName, Object[] args, String[] types) {
        Object[] results = new Object[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            try {
                results[i] = this.getMBeanServer().invoke(objectNames[i], operationName, args, types);
                continue;
            }
            catch (Throwable t) {
                results[i] = t;
            }
        }
        return results;
    }
}

