/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.management.offline.StdConfigBeanHelper;
import java.util.Arrays;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaConfigConfigBeanHelper
extends StdConfigBeanHelper {
    private static final String JVM_OPTIONS_ATTR = "JvmOptions";

    public JavaConfigConfigBeanHelper(ConfigContext configContext, ConfigBean configBean) {
        super(configContext, configBean);
    }

    private boolean hasJVMOptions() {
        return this.hasValue(JVM_OPTIONS_ATTR);
    }

    @Override
    protected Set<String> _getAttributeNames() {
        Set<String> attrNames = super._getAttributeNames();
        if (this.hasJVMOptions()) {
            attrNames.add(JVM_OPTIONS_ATTR);
        }
        return attrNames;
    }

    @Override
    protected Class getAttributeClass(String attrName) {
        Class result = null;
        result = JVM_OPTIONS_ATTR.equals(attrName) ? String[].class : super.getAttributeClass(attrName);
        return result;
    }

    @Override
    public Object getAttribute(String attrName) throws AttributeNotFoundException {
        Object result = null;
        result = JVM_OPTIONS_ATTR.equals(attrName) ? this.getJVMOptions() : super.getAttribute(attrName);
        return result;
    }

    @Override
    public void setAttribute(String name, Object value) throws AttributeNotFoundException, InvalidAttributeValueException {
        if (JVM_OPTIONS_ATTR.equals(name)) {
            this.setJVMOptions((String[])value);
        } else {
            super.setAttribute(name, value);
        }
    }

    private JavaConfig getJavaConfigConfigBean() {
        return (JavaConfig)this.getConfigBean();
    }

    public String[] getJVMOptions() {
        String[] result = this.getJavaConfigConfigBean().getJvmOptions();
        return result;
    }

    public void setJVMOptions(String[] optionsIn) {
        Set<String> optionsSet = GSetUtil.newUnmodifiableStringSet(optionsIn);
        Object[] options = GSetUtil.toStringArray(optionsSet);
        Arrays.sort(options);
        this.getJavaConfigConfigBean().setJvmOptions((String[])options);
    }
}

