/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.monitor.ServletMonitor;
import com.sun.appserv.management.monitor.WebModuleVirtualServerMonitor;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.j2ee.J2EEManagedObjectImplBase;
import com.sun.enterprise.management.support.Delegate;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletImpl
extends J2EEManagedObjectImplBase {
    private static final Set<String> IGNORE_MISSING = GSetUtil.newUnmodifiableStringSet("maxTimeMillis", "minTimeMillis", "processingTimeMillis", "requestCount", "errorCount");

    public ServletImpl(Delegate delegate) {
        super(delegate);
    }

    @Override
    protected void handleMissingOriginals(Set<String> missingOriginals) {
        missingOriginals.removeAll(IGNORE_MISSING);
        super.handleMissingOriginals(missingOriginals);
    }

    @Override
    protected String getMonitoringPeerJ2EEType() {
        return "X-ServletMonitor";
    }

    @Override
    protected ObjectName queryMonitoringPeerFailed(Map<String, String> propsMap) {
        WebModule webModule = (WebModule)this.getContainer();
        this.debug((Object)("queryMonitoringPeerFailed: expecting to find " + MapUtil.toString(propsMap)));
        if (webModule == null) {
            this.logWarning("ServletImpl.queryMonitoringPeerFailed: Can't get containing WebModule, my ObjectName = " + this.getObjectName());
        }
        ObjectName result = null;
        try {
            WebModuleVirtualServerMonitor webModuleVirtualServerMonitor = (WebModuleVirtualServerMonitor)webModule.getMonitoringPeer();
            if (webModuleVirtualServerMonitor == null) {
                ObjectName objectName = Util.getObjectName(webModule);
                String msg = "ServletImpl.queryMonitoringPeerFailed: Can't get WebModuleVirtualServerMonitor for " + ServletImpl.quote(ServletImpl.toString(objectName));
                this.debug((Object)msg);
                this.logFine(msg);
            } else {
                Map<String, ServletMonitor> servletMap = webModuleVirtualServerMonitor.getServletMonitorMap();
                ServletMonitor sm = servletMap.get(this.getName());
                if (sm != null) {
                    result = Util.getObjectName(sm);
                } else {
                    String servletMonitorNames = CollectionUtil.toString(Util.toObjectNames(servletMap).values(), StringUtil.NEWLINE());
                    this.logWarning("ServletImpl.queryMonitoringPeerFailed: Can't find ServletMonitor, my ObjectName = " + ServletImpl.quote(ServletImpl.toString(this.getObjectName())) + ", WebModuleVirtualServerMonitor " + ServletImpl.quote(ServletImpl.toString(Util.getObjectName(webModuleVirtualServerMonitor))) + " ServletMonitor names:" + StringUtil.NEWLINE() + servletMonitorNames);
                }
            }
        }
        catch (Exception e) {
            this.logWarning("ServletImpl.queryMonitoringPeerFailed: " + e);
            this.debug((Object)("ServletImpl.queryMonitoringPeerFailed: " + e + "\n" + ExceptionUtil.getStackTrace(e)));
        }
        return result;
    }
}

