/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.AssertImpl;
import com.sun.enterprise.admin.util.BaseValidator;
import com.sun.enterprise.admin.util.StringValidator;
import com.sun.enterprise.admin.util.Validator;

public class ArgChecker {
    private static final boolean sChecksEnabled = true;
    private static final AssertImpl sImpl = new AssertImpl("ArgChecker Failure", 1);

    private ArgChecker() {
        Assert.assertit(false, "You can't call the ArgChecker constructor!");
    }

    public static final void check(boolean b, Object msg) throws IllegalArgumentException {
        sImpl.assertIt(b, msg);
    }

    public static final void check(long value, long min, long max, Object userMsg) throws IllegalArgumentException {
        ArgChecker.checkRange(value, min, max, userMsg);
    }

    public static final void checkRange(long value, long min, long max, Object userMsg) throws IllegalArgumentException {
        sImpl.assertRange(value, min, max, userMsg);
    }

    public static void checkValid(Object object, String name, Validator validator) throws IllegalArgumentException {
        sImpl.assertValid(object, name, validator);
    }

    public static void check(Object object, String name, Validator validator) throws IllegalArgumentException {
        ArgChecker.checkValid(object, name, validator);
    }

    public static void checkValid(Object object, String name) throws IllegalArgumentException {
        Validator validator = object instanceof Validator ? (Validator)object : BaseValidator.getInstance();
        ArgChecker.check(object, name, validator);
    }

    public static void check(Object object, String name) throws IllegalArgumentException {
        ArgChecker.checkValid(object, name);
    }

    public static void check(String checkMe, String name) throws IllegalArgumentException {
        ArgChecker.check((Object)checkMe, name, StringValidator.getInstance());
    }

    public static void check(String checkMe, int minimumLength, String name) throws IllegalArgumentException {
        ArgChecker.check((Object)checkMe, name, new StringValidator(minimumLength));
    }

    static {
        sImpl.setWantStackTrace(false);
    }
}

