/*
 * Decompiled with CFR 0.152.
 */
package com.tamak.core.utils;

import com.tamak.core.bean.MessageBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.compiere.Adempiere;
import org.compiere.model.MMessage;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.Trx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgImporter {
    private static String USER_MAINTAINED_MSG = "User maintained";
    private static String INFORMATION_MSG = "Information";

    public ArrayList<MessageBean> getMessageList(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String strLine = null;
        ArrayList<MessageBean> messageList = new ArrayList<MessageBean>();
        strLine = bufferedReader.readLine();
        while ((strLine = bufferedReader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(strLine, ";");
            String searchKey = tokenizer.nextToken().replaceAll("\"", "");
            String msgText = tokenizer.nextToken().replaceAll("\"", "");
            String msgTip = null;
            if (tokenizer.hasMoreTokens()) {
                msgTip = tokenizer.nextToken().replaceAll("\"", "");
            }
            MessageBean msgBean = new MessageBean();
            msgBean.setSearchKey(searchKey);
            msgBean.setEntityType(USER_MAINTAINED_MSG);
            msgBean.setMsgType(INFORMATION_MSG);
            msgBean.setMsgText(msgText);
            msgBean.setMsgTip(msgTip);
            messageList.add(msgBean);
        }
        bufferedReader.close();
        fileReader.close();
        return messageList;
    }

    private String getEntityType(String entityType) {
        if (entityType == null) {
            throw new IllegalArgumentException("Entity Type cannot be null");
        }
        if (entityType.compareTo(USER_MAINTAINED_MSG) == 0) {
            return "U";
        }
        throw new IllegalArgumentException("Unknown entity type: " + entityType);
    }

    private String getMessageType(String messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException("Message Type cannot be null");
        }
        if (messageType.compareTo(INFORMATION_MSG) == 0) {
            return "I";
        }
        throw new IllegalArgumentException("Unknown message type: " + messageType);
    }

    public void importMessages(Properties ctx, ArrayList<MessageBean> msgList, String trxName) {
        for (MessageBean msgBean : msgList) {
            int msgId = MMessage.getAD_Message_ID((Properties)ctx, (String)msgBean.getSearchKey());
            MMessage msg = new MMessage(ctx, msgId, trxName);
            String entityType = this.getEntityType(msgBean.getEntityType());
            String msgType = this.getMessageType(msgBean.getMsgType());
            msg.setEntityType(entityType);
            msg.setMsgType(msgType);
            msg.setMsgText(msgBean.getMsgText());
            msg.setMsgTip(msgBean.getMsgTip());
            msg.setValue(msgBean.getSearchKey());
            msg.save();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 1) {
            throw new Exception("Should provide only one argument, that is the path of the file to import");
        }
        File adMsgFile = new File(args[0]);
        if (!adMsgFile.exists()) {
            throw new Exception("File does not exist:" + args[0]);
        }
        Properties ctx = Env.getCtx();
        CLogMgt.initialize((boolean)true);
        Adempiere.startup((boolean)true);
        ctx.setProperty("#AD_Client_ID", "0");
        ctx.setProperty("#AD_Org_ID", "0");
        ctx.setProperty("#AD_User_ID", "100");
        Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);
        trx.start();
        try {
            try {
                MsgImporter msgImporter = new MsgImporter();
                ArrayList<MessageBean> msgList = msgImporter.getMessageList(adMsgFile);
                msgImporter.importMessages(ctx, msgList, trx.getTrxName());
                trx.commit();
            }
            catch (Exception ex) {
                trx.rollback();
                ex.printStackTrace();
            }
        }
        finally {
            trx.close();
        }
    }
}

