/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Authenticator;
import org.apache.catalina.startup.ContextConfig;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossContextConfig
extends ContextConfig {
    private static Logger log = Logger.getLogger(JBossContextConfig.class);
    private boolean isTrace = log.isTraceEnabled();
    private boolean DELEGATE_TO_PARENT = false;

    public JBossContextConfig() {
        try {
            Map authMap = this.getAuthenticators();
            if (authMap.size() > 0) {
                this.customAuthenticators = authMap;
            }
            this.DELEGATE_TO_PARENT = this.getDeleteWorkDir();
        }
        catch (Exception e) {
            log.error((Object)"Failed to customize authenticators::", (Throwable)e);
        }
    }

    protected synchronized void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("destroy called with DELEGATE_TO_PARENT=" + this.DELEGATE_TO_PARENT));
        }
        if (this.DELEGATE_TO_PARENT) {
            super.destroy();
        }
    }

    private Map getAuthenticators() throws Exception {
        HashMap<String, Authenticator> cmap = new HashMap<String, Authenticator>();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Properties authProps = this.getAuthenticatorsFromJMX();
        if (authProps != null) {
            Iterator<Object> iter;
            Set<Object> keys = authProps.keySet();
            Iterator<Object> iterator = iter = keys != null ? keys.iterator() : null;
            while (iter != null && iter.hasNext()) {
                String key = (String)iter.next();
                String authenticatorStr = (String)authProps.get(key);
                Class<?> authClass = tcl.loadClass(authenticatorStr);
                cmap.put(key, (Authenticator)authClass.newInstance());
            }
        }
        if (this.isTrace) {
            log.trace((Object)("Authenticators plugged in::" + cmap));
        }
        return cmap;
    }

    private Properties getAuthenticatorsFromJMX() throws JMException {
        Properties props = null;
        MBeanServer server = MBeanServerLocator.locateJBoss();
        props = (Properties)server.getAttribute(new ObjectName("jboss.web:service=WebServer"), "Authenticators");
        return props;
    }

    private boolean getDeleteWorkDir() throws JMException {
        Boolean flag = Boolean.FALSE;
        MBeanServer server = MBeanServerLocator.locateJBoss();
        flag = (Boolean)server.getAttribute(new ObjectName("jboss.web:service=WebServer"), "DeleteWorkDirOnContextDestroy");
        return flag;
    }
}

